/* pp.h    header file for pforge.c program    jpb 5/27/95 */

#include <stdio.h>

#define PGM  0          /* PGM ascii type */
#define TGA  1          /* POV-Ray 2.2 TGA heightfield format */
#define PNG  2          /* PNG format (not yet supported) */
#define PG8  3          /* 8-bit binary PGM format */
#define OCT  4          /* Octave ascii format */
#define MAT  5          /* Matlab Level 1.0 binary format */

#define DOS  yuck                     /* compiling on DOS system */
#define MAX_PIXVAL 65535              /* ascii integer output max value */

#ifdef BigEndian
#define NUM_FMT 1
#else
#define NUM_FMT 0       /* 0 IEEE Little Endian (80x86, DEC Risc) */
                        /* 1 IEEE Big Endian (SPARC, SGI, Motorola, etc.) */
#endif

#define PREC 1          /* storing Matlab file as floats rather than longs */
#define PTYPE float     /* internal representation of float numbers */

FILE *fpout;                          /* pointer to image output file */

typedef struct image_data_struct {
  char fname[100];                      /* image filename */
  int type;                             /* storage format type */
  double *dim;                       
  double *dscale;
  int d_factors;
  double powscale;
  double xfrac, yfrac;
  unsigned int rseed;
  int meshsize;
  int peakspec;
  int adimspec;
  int craterspec;
  double craterdens;
  double craterscale;
  int limitspec;
  double limit_lo;
  double limit_hi;
} image_data;

                        /* Matlab Level 1.0 format data file header */
typedef struct matlab_header_struct {
        long type;      /* type */
        long mrows;     /* row dimension */
        long ncols;     /* column dimension */
        long imagf;     /* flag indicating imag part */
        long namelen;    /* name length (including NULL) */
} Fmatrix;

int pp_filetype;                      /* file format type: PGM, TGA etc */
int pm_keymatch(char* str, char* key, int minchar);  /* keyword matcher */
void pperror( char* str);               /* print an error string and exit */
void write_info(FILE *f, image_data img);     /* write data header */
void pp_writerow(image_data img, PTYPE *row);
void pp_writepixel(float pf);            /* write pixel to output file */
void pp_writenewline();                        /* finished output line */
int pp_openfile(image_data img);              /* open output file */
int pp_closefile(image_data img);              /* close output file */
void fpc(unsigned char c);                     /* print byte to file */



