/********************************************************************************
 *  Projektname		: AERO
 *  Filename		: vektor.h
 *  Filetyp		: Header
 ********************************************************************************
 *  Modulname		: vektor.o
 *  Version           	: 0.0.2
 *  letzte Aenderung	: 10.01.93
 *  Autor		: Horst Stolz (HUS)
 *  Status:		: lauffaehig
 *  
 *  exportierte Funktionen:
 *    void MV_MUL(TVektor *x, TMatrix *a, TVektor *b)
 *    void RotMatrix(TMatrix *Rot, TQuaternion q)
 *    void MV_MUL(TVektor x, TMatrix a, TVektor b)
 * 
 *  Beschreibung:
 *    Funtionen die im headerfile "vektor.h" nicht als MAKRO definiert sind
 *    bereitzustellen
 *  
 * 
 *  Versionsgeschichte:
 *  -------------------
 *  02.12.92    RotMatrix aus folges... hierher gesetzt
 *  10.01.93    Type TQuaternion eingefuehrt
 *  21.01.93      MV_MUL2(..) eingebaut
 *  
 ********************************************************************************/

#include <math.h>
#include "vektor.h"



void MV_MUL(TVektor *x, TMatrix *a, TVektor *b)
{
    (*x)[0] = ((*b)[0])*(*a)[0][0] + ((*b)[1])*(*a)[0][1] + ((*b)[2])*(*a)[0][2];
    (*x)[1] = ((*b)[0])*(*a)[1][0] + ((*b)[1])*(*a)[1][1] + ((*b)[2])*(*a)[1][2];
    (*x)[2] = ((*b)[0])*(*a)[2][0] + ((*b)[1])*(*a)[2][1] + ((*b)[2])*(*a)[2][2];
}

void MV_MUL2(TVektor x, TMatrix a, TVektor b)
{ /* [zeile][spalte] */
    x[0] = b[0]*a[0][0] + b[1]*a[0][1] + b[2]*a[0][2];
    x[1] = b[0]*a[1][0] + b[1]*a[1][1] + b[2]*a[1][2];
    x[2] = b[0]*a[2][0] + b[1]*a[2][1] + b[2]*a[2][2];
}

void MM_MUL(TMatrix x, TMatrix a, TMatrix b)
{ /* [zeile][spalte] */

    x[0][0] = a[0][0]*b[0][0] + a[0][1]*b[1][0] + a[0][2]*b[2][0];
    x[0][1] = a[0][0]*b[0][1] + a[0][1]*b[1][1] + a[0][2]*b[2][1];
    x[0][2] = a[0][0]*b[0][2] + a[0][1]*b[1][2] + a[0][2]*b[2][2];

    x[1][0] = a[1][0]*b[0][0] + a[1][1]*b[1][0] + a[1][2]*b[2][0];
    x[1][1] = a[1][0]*b[0][1] + a[1][1]*b[1][1] + a[1][2]*b[2][1];
    x[1][2] = a[1][0]*b[0][2] + a[1][1]*b[1][2] + a[1][2]*b[2][2];

    x[2][0] = a[2][0]*b[0][0] + a[2][1]*b[1][0] + a[2][2]*b[2][0];
    x[2][1] = a[2][0]*b[0][1] + a[2][1]*b[1][1] + a[2][2]*b[2][1];
    x[2][2] = a[2][0]*b[0][2] + a[2][1]*b[1][2] + a[2][2]*b[2][2];
}


void RotMatrix(TMatrix Rot, TQuaternion q)
{
    TReal q00 = q[0] * q[0];
    TReal q01 = q[0] * q[1];
    TReal q02 = q[0] * q[2];
    TReal q03 = q[0] * q[3];
    TReal q11 = q[1] * q[1];
    TReal q12 = q[1] * q[2];
    TReal q13 = q[1] * q[3];
    TReal q22 = q[2] * q[2];
    TReal q23 = q[2] * q[3];
    TReal q33 = q[3] * q[3];

    Rot[0][0] = 2.0 * (q00 + q11) - 1.0;
    Rot[0][1] = 2.0 * (q12 + q03);
    Rot[0][2] = 2.0 * (q13 - q02);
    Rot[1][0] = 2.0 * (q12 - q03);
    Rot[1][1] = 2.0 * (q00 + q22) - 1.0;
    Rot[1][2] = 2.0 * (q23 + q01);
    Rot[2][0] = 2.0 * (q13 + q02);
    Rot[2][1] = 2.0 * (q23 - q01);
    Rot[2][2] = 2.0 * (q00 + q33) - 1.0;
}

void EbenenVektoren(TVektor i, TVektor j, TVektor k)
/***************************************************************************
 * 1) Aendert k zun einem Einheitsvektor (Betrag=1)
 * 2) Bildet die Vektoren i, j wobei i zu k, i zu j, j zu k im rechten
 *    Winkel zueindander stehn.
 * 3) k, i, j bilden ein Rechtssystem.
 */
{
    TReal h;


    FehlerOrt("EbenenVektor()");
    
    h = V_BETRAG(k);
    if (h == 0.0) Fehler("Normalenvektor k=0");
    h = 1/h;
    V_SKALAR(k, k, h); 

    if (k[1]==0.0) {
	i[1] = 1.0;
	i[0] = 0.0;
      }
    else {
	h = sqrt(fabs(k[0]*k[0] + k[1]*k[1]));
	i[1] = k[0] / h;
	i[0] = -k[1] / h;
    }
    i[2] = 0.0;

    V_MUL(j, k, i);
}




void Q_MUL(TQuaternion x, TQuaternion a, TQuaternion b)
{
    TQuaternion e;

    e[0] = a[0]*b[0] - (V_PRODUKT(&a[1], &b[1]));
    V_MUL(&e[1], &a[1], &b[1]);

    e[1] += a[0]*b[1] + b[0]*a[1];
    e[2] += a[0]*b[2] + b[0]*a[2];
    e[3] += a[0]*b[3] + b[0]*a[3];

    x[0] = e[0];
    x[1] = e[1];
    x[2] = e[2];
    x[3] = e[3];
}



TReal NormGeschw(TVektor v1, TVektor w1, TVektor p1, 
	   TVektor v2, TVektor w2, TVektor p2, TVektor n)
{
    TVektor hv1, hv2;

    V_MUL(hv1, w1, p1);      /* p1 und p2 in Weltkoordinaten (raumfest!!!!) */
    V_MUL(hv2, w2, p2);

    V_INC(hv1, v1);
    V_DEC(hv1, v2);
    V_DEC(hv1, hv2);

    return V_PRODUKT(hv1, n);
}


void RotMatrizen(TMatrix Rot, TMatrix Rot1, TQuaternion q)
{
    TReal q00 = q[0] * q[0];
    TReal q01 = q[0] * q[1];
    TReal q02 = q[0] * q[2];
    TReal q03 = q[0] * q[3];
    TReal q11 = q[1] * q[1];
    TReal q12 = q[1] * q[2];
    TReal q13 = q[1] * q[3];
    TReal q22 = q[2] * q[2];
    TReal q23 = q[2] * q[3];
    TReal q33 = q[3] * q[3];

    Rot[0][0] = 2.0 * (q00 + q11) - 1.0;
    Rot[0][1] = 2.0 * (q12 + q03);
    Rot[0][2] = 2.0 * (q13 - q02);
    Rot[1][0] = 2.0 * (q12 - q03);
    Rot[1][1] = 2.0 * (q00 + q22) - 1.0;
    Rot[1][2] = 2.0 * (q23 + q01);
    Rot[2][0] = 2.0 * (q13 + q02);
    Rot[2][1] = 2.0 * (q23 - q01);
    Rot[2][2] = 2.0 * (q00 + q33) - 1.0;

    /* Rot1 berechnet sich aus q=(q0, -q1, -q2, -q3) */

    Rot1[0][0] = Rot[0][0];
    Rot1[0][1] = 2.0 * (q12 - q03);
    Rot1[0][2] = 2.0 * (q13 + q02);
    Rot1[1][0] = 2.0 * (q12 + q03);
    Rot1[1][1] = Rot[1][1];
    Rot1[1][2] = 2.0 * (q23 - q01);
    Rot1[2][0] = 2.0 * (q13 - q02);
    Rot1[2][1] = 2.0 * (q23 + q01);
    Rot1[2][2] = Rot[2][2];
}




TReal TanGeschw(TVektor t, TVektor v1, TVektor w1, TVektor p1, 
	        TVektor v2, TVektor w2, TVektor p2, TVektor n)
/* Betrag n == 1 !! */
{
    
    TVektor v;
    TReal f;
/*
    printvektor("v1=", v1);
    printvektor("w1=", w1);
    printvektor("p1=", p1);
    printvektor("v2=", v2);
    printvektor("w2=", w2);
    printvektor("p2=", p2);
    printvektor("n=", n);
*/
    V_MUL(v, w1, p1);      /* p1 und p2 in Weltkoordinaten (raumfest!!!!) */
    V_MUL(t, w2, p2);

    V_INC(v, v1);
    V_DEC(v, v2);
    V_DEC(v, t);	   /* v - Geschwindigkeit des Punktes P */
/*
    printvektor("v=", v);
*/
    f = V_BETRAG(v);
    if (f<=0.0000001) {
	V_SET(t, 0.0, 0.0, 0.0);
	return 0.0;
    }    
    f = V_PRODUKT(n, v);
    V_SUBSKAL(t, v, f, n);
/*
    printvektor("t=", t);
*/
    return  V_BETRAG(t);
}








void MultiGeschw(TReal *bt, TVektor t, TReal *bt1, TVektor t1, TReal *bt2, TVektor t2, /*o*/
		TVektor v1, TVektor w1, TVektor p1, 			/* in */
	        TVektor v2, TVektor w2, TVektor p2, TVektor n)
/* Betrag n == 1 !! */
{
    
    TVektor v, x1, x2;
    TReal f;


    V_MUL(x1, w1, p1);      /* p1 und p2 in Weltkoordinaten (raumfest!!!!) */
    V_MUL(x2, w2, p2);

   
    V_ADD(v, v1, x1);
    V_DEC(v, v2);
    V_DEC(v, x2);	   /* v - Geschwindigkeit des Punktes P */

    f = V_PRODUKT(v, v);
    if (f<=0.00000001) {
	V_SET(t, 0.0, 0.0, 0.0);
	*bt = 0.0;
    } else {
	f = V_PRODUKT(n, v);
	V_SUBSKAL(t, v, f, n);
	*bt = V_BETRAG(t);
    }


    f = V_PRODUKT(x1, x1);
    if (f<=0.00000001) {
	V_SET(t1, 0.0, 0.0, 0.0);
	*bt1 = 0.0;
    } else {    
	f = V_PRODUKT(n, x1);
	V_SUBSKAL(t1, x1, f, n);
	*bt1 = V_BETRAG(t1);
    }


    f = V_PRODUKT(x2, x2);
    if (f<=0.00000001) {
	V_SET(t2, 0.0, 0.0, 0.0);
	*bt2 = 0.0;
    } else {    
	f = V_PRODUKT(n, x2);
	V_SUBSKAL(t2, x2, f, n);
	*bt2 = V_BETRAG(t2);
    }
/*
    printvektor("t = ", t);
    printvektor("t1 = ", t);
    printvektor("t2 = ", t);
    printf("|t|=%f, |t1|=%f, |t2|=%f\n", *bt, *bt1, *bt2);
*/
}
