.\" Copyright (c) 1994-1996 Michael J. Gourlay
.TH XMORPH 1


.SH NAME
xmorph \- digital image warping (morphing) for X window system


.SH SYNOPSIS
.B xmorph
.RB "[\|" \-start
.I srcimgfile
.RB "[\|" \-finish
.IR destimgfile "\|]\|]"


.SH DESCRIPTION
.B xmorph
is a digital image warping program, also known as a "morphing"
program.  It runs under the X Window System.

.LP
If
.I imgfile
names are provided on the command line, then those images are loaded
in.  Otherwise,
.B xmorph
generates images to be used in lieu of images
provided by the user.  Images may be loaded from menus within
.BR xmorph .

.LP
.B xmorph
has built-in help pages that answer questions about the details
of its use.  Run
.B xmorph
and look at the online help for more information.


.SH OPTIONS
.TP
.B \-start \fIsrcimgfile\fP
Load the
.I srcimgfile
as the "source" image.
.TP
.B \-finish \fIdestimgfile\fP
Load the
.I destimgfile
as the "destination" image.


.SH "MAKING MOVIES"
.B xmorph
is NOT a tool for making movies.
.B xmorph
is intended to be used with OTHER tools for editting movies in the
digital domain.  I do not intend to add movie making abilities to
.BR xmorph .

.LP
However, morphing is fun for some people who don't
already have the means for making movies, so here is a brief
explanation of how to make a movie from the images generated by
.BR xmorph :

.LP
You can use PBMplus or netpbm or ImageMagick to convert Targa to
other still image formats.  This will be necessary if you use the
Berkeley MPEG encoder.  See ftp://ikaros.fysik4.kth.se/pub/netpbm/.

.LP
Use another program, such as Berkeley's mpeg_encode, to turn the
sequence of images that
.B xmorph
created into a single animation.  See
ftp://mm-ftp.cs.berkeley.edu/pub/multimedia/mpeg/encode/.

.LP
Use another program, such as mpeg_play, to view the animation.  See
ftp://mm-ftp.cs.berkeley.edu/pub/multimedia/mpeg/play/.

.LP
There are plenty of other programs available for doing that, and many
of them are excellent.


.SH AUTHOR
Written and Copyright (C) 1994-1996 by Michael J. Gourlay.

.LP
Help came from many places, including Andy Thaller, Warwick Allison,
and Mike Hoefelein.

.LP
The original morphing algorithm is presented in ``A Two-Pass Mesh
Warping Algorithm for Object Transformation and Image
Interpolation'', ILM Technical Memo #1030, Computer Graphics
Department, Lucasfilm Ltd., 1990.

.LP
Mesh-based digital image warping is discussed in detail in
.I Digital Image Warping
by George Wolberg.


.SH "SEE ALSO"
.BR X (1),
.BR ppmtotga (1),
.BR tgatoppm (1),
(netpbm or PBMplus),
.BR mpeg_encode (1)
from U.C. Berkeley,
.BR mpeg_play (1)
from U.C. Berkeley,
ImageMagick,
.BR dmconvert (1)
(under Silicon Graphics IRIX).

.LP
Adobe Premier,
Art Department Pro Professional Conversion Pack (under Amiga).

.SH BUGS
The only image file type currently supported is Truevision Targa, but
it will load any type of Targa, such as 8-bit, 15-bit, or 16-bit
colormapped or grayscale; 24-bit or 32-bit true color (with or
without alpha channel); run-length encoded or uncompressed.

.LP
The program "xv" can not read xmorph's TGA files.

.LP
Report bugs to michael.gourlay@colorado.edu
