/* rgba_image.h : image handling routines
**
** Written and Copyright (C) 1994 by Michael J. Gourlay
**
** PROVIDED AS IS.  NO WARRANTEES, EXPRESS OR IMPLIED.
*/

#ifndef _IMAGE_H__INCLUDED_
#define _IMAGE_H__INCLUDED_




#ifndef UCHAR
#define UCHAR unsigned char
#endif




/* BITS_PER_CHANNEL is the number of bits per channel per pixel that
** an rgba_image uses to store image data.
** This should be the same as the size of the storage class used for
** rgba_image channels, i.e. UCHAR.
*/
#define BITS_PER_CHANNEL 8

/* RGBA_IMAGE_MAXVAL is the maximum value a channel can have for a
** single pixel.
*/
#define RGBA_IMAGE_MAXVAL ((1<<BITS_PER_CHANNEL) - 1)

/* RGBA_IMAGE_OPAQUE is the same as RGBA_IMAGE_MAXVAL, except that
** it's for the alpha (opacity) channel, and this is a reminder that zero
** is transparent and the MAXVAL is opaque.
*/
#define RGBA_IMAGE_OPAQUE RGBA_IMAGE_MAXVAL




typedef struct rgba_image_ {
  int nrows;       /* number of rows in (i.e. the height of) the image */
  int ncols;       /* number of columns in (i.e. the width of) the image */
  int compressed;
  int pixel_size;
  int color_mapped;
  int type;
  UCHAR *ri;       /* red channel image data */
  UCHAR *gi;       /* green channel image data */
  UCHAR *bi;       /* blue channel image data */
  UCHAR *ai;       /* alpha (opacity) channel image data */
} RgbaImageT;




extern void initImageRGBA(RgbaImageT *imgP);

extern void freeImageRGBA(RgbaImageT *imgP);

extern int allocImageRGBA(RgbaImageT *imgP, char *proc);

extern int loadImageRGBA(char *fn, RgbaImageT *imgP);

extern int saveImageRGBA(char *fn, RgbaImageT *si, RgbaImageT *di, double t);

extern int make_test_image(RgbaImageT *imgP, int type);

#endif
