//------------------------------------------------------ X Code
#define MAX_COLORS   256
static unsigned long Pixels[MAX_COLORS];

typedef unsigned char PIXEL;
PIXEL **Bitmap;

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#include <string.h>
#include <stdlib.h>

static XEvent Event;

static Display *display = NULL;
static int screen;
static XImage *XImg;
static unsigned char *XData;
static int BpS;
static Colormap Cmap=0;
static Window Win = (Window) NULL;
static XGCValues Values;
static GC gc;
static XSetWindowAttributes W_Attribs;

 /* Shared memory */

static int Shm_Ok;
static XShmSegmentInfo ShmInfo;
static int Completion_Type;

static void Allocate_XImage(int Resx,int Resy,int depth);
static int Allocate_Shm_XImage(int Resx,int Resy,int depth);
#define MASKS     StructureNotifyMask| ExposureMask      \
                | KeyReleaseMask | KeyPressMask          \
                | ButtonPressMask | ButtonReleaseMask    \
                | ButtonMotionMask | PointerMotionMask


static int Open_Graphics(int Resx,int Resy,int *depth,char *name)
{
    char *Name;
    char Me[256];
    XSizeHints Size_Hints;
    XWindowAttributes attrib;
    
    if (display != NULL)
        return (FALSE);

    if (gethostname(Me, 256) == -1)
    {
        perror("gethostname");
        return (TRUE);
    }

    Name = XDisplayName(NULL);

    display = XOpenDisplay(Name);
    if (display == NULL)
    {
        fprintf(stderr, "Can't open X connection ( DISPLAY: '%s' ).\n", Name);
        return (TRUE);
    }

    Shm_Ok = TRUE;                               /* A priori guess... */
    if (XShmQueryExtension(display) != TRUE)
    {
        fprintf(stderr, " Shared memory extension not available...\n");
        Shm_Ok = FALSE;
    }
    else if (Name[0] != ':')
        if (strncmp(Me, Name, strlen(Me)) != 0)
        {
            fprintf(stderr, " Can't use shared memory when DISPLAY is redirected...\n");
            Shm_Ok = FALSE;
        }

    if (Shm_Ok)
        fprintf(stderr, "Using shared memory with DISPLAY '%s'...\n", Name);

    screen = DefaultScreen(display);

	Win=XCreateWindow(display, RootWindow( display, screen ),
         0, 0, Resx,Resy, 0, CopyFromParent, InputOutput, CopyFromParent,
         CWBackingStore, &W_Attribs );

    gc = XCreateGC(display, Win, 0, &(Values));

                                                /* No resize */

    Size_Hints.width = Resx;
    Size_Hints.height = Resy;
    Size_Hints.min_width = Size_Hints.width;
    Size_Hints.max_width = Size_Hints.width;
    Size_Hints.min_height = Size_Hints.height;
    Size_Hints.max_height = Size_Hints.height;
    Size_Hints.flags = PSize | PMinSize | PMaxSize;
    XSetWMNormalHints(display, Win, &Size_Hints);
    
    W_Attribs.backing_store = Always;
    XChangeWindowAttributes(display, Win,
                            CWBackingStore, &(W_Attribs));

    XGetWindowAttributes( display, Win, &attrib );
    *depth=attrib.depth;
	
    /* Colors */

    /* Try with default CMap */
   if(*depth==8)
   {
      Cmap = DefaultColormap(display, screen);

      if (!XAllocColorCells(display, Cmap,
                        	FALSE, NULL, 0, Pixels, MAX_COLORS))
      {
          // It failed ->Private CMap 

          Cmap = XCreateColormap(
                            	 display,
                            	 RootWindow(display, screen),
                            	 DefaultVisual(display, screen),
                            	 AllocNone);
          XAllocColorCells(display, Cmap,
                           FALSE, NULL, 0, Pixels, MAX_COLORS);
      }

      XSetWindowColormap(display, Win, Cmap);
    }

    XStoreName(display, Win, name);

    XSelectInput(display, Win, MASKS);

    XMapWindow(display, Win);
    XFlush(display);


    /* Main bitmap setup */

    if (Shm_Ok)                                  /* Try to allocate segment */
        Shm_Ok = Allocate_Shm_XImage(Resx,Resy,*depth);

    if (Shm_Ok)                                  /* It worked ... */
        Completion_Type = XShmGetEventBase(display) + ShmCompletion;
    else
        Allocate_XImage(Resx,Resy,*depth);                       /* Usual fashion... */

    if (XImg == NULL || Bitmap == NULL)
        return (TRUE);

    XData = Bitmap[0];
    BpS = sizeof(short) * (Resx + 1) +1;

    return (FALSE);
}

static void Close_Graphics()
{
    /* Destroy resources */

    if (display != NULL)
    {
        while (XPending(display) > 0)
            XNextEvent(display, &Event);

        if (XImg != NULL)
        {
            if (Shm_Ok)
            {
                XShmDetach(display, &(ShmInfo));
                XDestroyImage(XImg);
                shmdt(ShmInfo.shmaddr);
                shmctl(ShmInfo.shmid, IPC_RMID, 0);
            }
            else
                XDestroyImage(XImg);
        }
        XData = NULL;                            /* Already freed by
                                                    XDestroyImage ... */
        XImg = NULL;

        /* Destroy window */

        if (Win != (Window) NULL)
        {
            XUnmapWindow(display, Win);
            XDestroyWindow(display, Win);
            if(Cmap!=0)XFreeColormap(display, Cmap);
            XFreeGC(display, gc);
        }
        Win = (Window) NULL;

        XCloseDisplay(display);
    }

    display = NULL;
}

static void Allocate_XImage(int Resx,int Resy,int depth)
{
    int i;
    XImg = NULL;
    Bitmap = (PIXEL **) malloc(Resy * sizeof(PIXEL *));

    if (Bitmap == NULL)
    {
        XImg = NULL;
        return;
    }

    Bitmap[0] = (PIXEL *) malloc(Resy * Resx * (depth/8)*sizeof(PIXEL));
    if (Bitmap[0] == NULL)
    {
        free(Bitmap);
        Bitmap = NULL;
        return;
    }

    for (i = 1; i < Resy; ++i)
        Bitmap[i] = Bitmap[i - 1] + Resx*(depth/8);

    XImg = XCreateImage(
                        display,
                        DefaultVisual(display, screen),
                        depth, ZPixmap, 0,
                        &(Bitmap[0][0]),
                        Resx, Resy,
                        32, 0);

    if (XImg == NULL)
    {
        free(Bitmap[0]);
        free(Bitmap);
        Bitmap = NULL;
        return;
    }

    return;
}

static int Allocate_Shm_XImage(int Resx,int Resy,int depth)
{
    int i;
    XImg = NULL;

    ShmInfo.shmid = shmget(
                           IPC_PRIVATE,
                           Resx * Resy*(depth/8),
                           IPC_CREAT | 0x1ff);

    if (ShmInfo.shmid < 0)
    {
        fprintf(stderr, "Error with shared memory ID...");
        return (FALSE);
    }

    ShmInfo.shmaddr = (char *) shmat(ShmInfo.shmid, NULL, 0);
    if (ShmInfo.shmaddr == (void *) (-1))
    {
        fprintf(stderr, "Error with shared memory segment allocation...");
        return (FALSE);
    }

    Bitmap = (PIXEL **) malloc(Resy * sizeof(PIXEL *));

    if (Bitmap == NULL)
        return (FALSE);

    Bitmap[0] = (PIXEL *) (ShmInfo.shmaddr);

    for (i = 1; i < Resy; ++i)
        Bitmap[i] = Bitmap[i - 1] + Resx*(depth/8);

    XImg = XShmCreateImage(
                           display,
                           DefaultVisual(display, screen),
                           depth, ZPixmap, (unsigned char *) &(Bitmap[0][0]),
                           &(ShmInfo), Resx, Resy);

    if (XImg == NULL)
    {
        free(Bitmap[0]);
        free(Bitmap);
        Bitmap = NULL;
        return (FALSE);
    }

    if (XImg->xoffset != 0)
    {
        fprintf(stderr, "Error with XImage xoffset...");
        goto Failed;
    }

    if (XImg->bytes_per_line != (Resx*(depth/8)))
    {
        fprintf(stderr, "Error with XImg->bytes_per_line");
        goto Failed;
    }

    ShmInfo.readOnly = FALSE;
    if (!XShmAttach(display, &(ShmInfo)))
    {
        fprintf(stderr, "Error with XShmAttach...");
        goto Failed;
    }

    return (TRUE);

Failed:

    XDestroyImage(XImg);
    XImg = NULL;
    free(Bitmap);
    Bitmap = NULL;

    return (FALSE);
}

void Refresh()
{
    if (Shm_Ok)
    {
        XShmPutImage(
                     display, Win, gc, XImg,
                     0, 0, 0, 0, Resx, Resy, TRUE);

        while (1)
        {
            XNextEvent(display, &Event);
            if (Event.type == Completion_Type)
                break;
        }
    }
    else
        XPutImage(
                  display, Win, gc, XImg,
                  0, 0, 0, 0, Resx, Resy);
}

void Store_Colors(PVRGB pal[256])
{
    int i;

    static XColor colors[MAX_COLORS];
    for (i = 0; i < MAX_COLORS; i++)
    {
        colors[i].red = (((float) (pal[i].r)) / 63) * 65535;
        colors[i].green = (((float) (pal[i].g)) / 63) * 65535;
        colors[i].blue = (((float) (pal[i].b)) / 63) * 65535;
        colors[i].pixel = Pixels[i];
        colors[i].flags = DoRed | DoGreen | DoBlue;
    }

    XStoreColors(display, Cmap, colors, MAX_COLORS);
}

//--------------------------------------------------- End X Code
