static unsigned int Indiani(unsigned int a)
{
#ifdef __INDIAN_SWAP__
        unsigned int c;

	c=(a&0xff)<<24;
	c|=((a&0xff00)>>8)<<16;
	c|=((a&0xff0000)>>16)<<8;
	c|=((a&0xff000000)>>24);

	return c;
#else
    return a;
#endif
}

static unsigned short Indians(unsigned short a)
{
#ifdef __INDIAN_SWAP__
    unsigned short c;

        c=(a&0xff)<<8;
	c|=((a&0xff00)>>8);

	return c;
#else
    return a;
#endif
}

static float Indianf(float a)
{
#ifdef __INDIAN_SWAP__
        int *d,t;
	float *h;

	d=(int*)&a;
	t=((*d)&0xff)<<24;
	t|=(((*d)&0xff00)>>8)<<16;
	t|=(((*d)&0xff0000)>>16)<<8;
	t|=(((*d)&0xff000000)>>24);
	h=(float*)&t;
	return *h;
#else
    return a;
#endif

}
