// Panard Vision Sample
// (C) 1997-98, Olivier Brunet (bruneto@efrei.fr)

// Some dynamic things using Panard Primitves 3D
// Demonstrates what ambient mapping & bilinear can do for you

// This sample is directly taken/converted/simplified from the OpenGL SDK for MS Windows 95
// The conversion has been done straight forward, that's why it's not as clean as
// it should be :) Enjoy.

// Moreover, a great performance improvement would appear if instead of using Panard Primitives
// we use the mesh oriented functions of PV. This is an exercise left to the reader :)

// This samples demonstrates also palette management

// SMKaribou/GMF

#include <math.h>
#include <stdio.h>
#include <pvision.h>
#include <pvut.h>
#include "DirectDrawEasy.h"
#include "DXMen.h"


#define GETCOORD(frame, x, y) (&(theMesh.coords[frame*theMesh.numCoords+(x)+(y)*(theMesh.widthX+1)]))
#define GETFACET(frame, x, y) (&(theMesh.facets[frame*theMesh.numFacets+(x)+(y)*theMesh.widthX]))

class PVEasy:public DDrawEasy
{
public:
	struct facet {
    float color[3];
    float normal[3];
};

struct coord {
    float vertex[3];
    float normal[3];
};

struct mesh {
    int widthX, widthY;
    int numFacets;
    int numCoords;
    int frames;
    struct coord *coords;
    struct facet *facets;
} theMesh;

	int widthX, widthY;
	int checkerSize;
	float height;

	int frames, curFrame, nextFrame;
	
	unsigned lighting;

	PVMaterial *mat;

	// Member functions
	PVEasy();
	void InitPV(void);
	void InitMesh(void);
	void Animate(void);
	void SetColorMap(void);
	int OnIdle(void);
};

///////////////////////////////////////////////////////////////////////////////
PVEasy::PVEasy():DDrawEasy()
{
	curFrame=nextFrame=0;
    frames = 10;
    widthX = 10;
    widthY = 10;
    checkerSize = 2;
    height = 0.2;
	
	lighting = !FALSE;
}

void PVEasy::InitMesh(void)
{
    struct coord *coord;
    struct facet *facet;
    float dp1[3], dp2[3];
    float *pt1, *pt2, *pt3;
    float angle, d, x, y;
    int numFacets, numCoords, frameNum, i, j;

    theMesh.widthX = widthX;
    theMesh.widthY = widthY;
    theMesh.frames = frames;

    numFacets = widthX * widthY;
    numCoords = (widthX + 1) * (widthY + 1);

    theMesh.numCoords = numCoords;
    theMesh.numFacets = numFacets;

    theMesh.coords = (struct coord *)malloc(frames*numCoords*
                        sizeof(struct coord));
    theMesh.facets = (struct facet *)malloc(frames*numFacets*
                        sizeof(struct facet));
    if (theMesh.coords == NULL || theMesh.facets == NULL) {
		printf("Out of memory.\n");
		exit(1);
    }

    for (frameNum = 0; frameNum < frames; frameNum++) {
    for (i = 0; i <= widthX; i++) {
        x = i / (float)widthX;		

        for (j = 0; j <= widthY; j++) {
        y = j / (float)widthY;

        d = sqrt(x*x+y*y);
        if (d == 0.0) {
            d = 0.0001;
        }
        angle = 2 * PI * d + (2 * PI / frames * frameNum);

        coord = GETCOORD(frameNum, i, j);

        coord->vertex[0] = 100*(x - 0.5);
        coord->vertex[1] = 100*(y - 0.5);
        coord->vertex[2] = 100*(height - height * d) * cos(angle);

        coord->normal[0] = -(height / d) * x * ((1 - d) * 2 * PI *
                   sin(angle) + cos(angle));
        coord->normal[1] = -(height / d) * y * ((1 - d) * 2 * PI *
                   sin(angle) + cos(angle));
        coord->normal[2] = -1;

        d = 1.0 / sqrt(coord->normal[0]*coord->normal[0]+
                   coord->normal[1]*coord->normal[1]+1);
        coord->normal[0] *= d;
        coord->normal[1] *= d;
        coord->normal[2] *= d;
        }
    }
    }
}

void PVEasy::InitPV(void)
{
    PVRGBF ambient={0.1,0.1,0.1,0};    // Ambient Light

    PVMat3x3 Id={1,0,0,0,1,0,0,0,1};
    PVPoint Pos={0,0,0};

    PVCam *c;
	PVWorld *w;

    // Render Mode Setup
    PV_SetClipLimit(0,Width-1,0,Height-1,Pitch);			// Sets rendering window
    PV_SetMode(PVM_BILINEAR|(Depth==8?PVM_PALETIZED8:PVM_RGB));			// Sets rendering mode

	if(!(PV_Mode&PVM_PALETIZED8)) 
	{
		// We are in RGB rendering, sets the RGB masks according to the current device
		PV_SetRGBIndexingMode(GetMaskSize(RedMask),GetMaskSize(GreenMask),GetMaskSize(BlueMask),GetMaskPos(RedMask),GetMaskPos(GreenMask),GetMaskPos(BlueMask),GetMaskSize(AlphaMask));
	}
	
    // Material Setup
    mat=PV_CreateMaterial("RED",AMBIENT_MAPPING,TEXTURE_RGB|TEXTURE_BILINEAR,0);// Gets a ambient mapped material
	if(pvuLoadJpeg("../data/ambient.jpg",mat)!=COOL)
	{
		Error("Unable to load texture");
		exit(1);
	}
	// Here it's a trick, we need to quantize the texture 
	// so we create a world, add the material to it
	// compile the world, and then use the quantized material :)
	w=PV_CreateWorld();
	w->ReservedColors=10; // Windows needs the first  colors free in windowed mode
	PV_AddMaterial(w,mat);
	PV_CompileMaterials(w,NULL,NULL);

	// Stes the palette
	if(PV_Mode&PVM_PALETIZED8)
	{
		// We are on a paletized device, sets a nice palette 
		char Pal[768];
		unsigned i;
		for(i=0;i<256;i++)
		{
			// This is because PV's palette is from 0 to 64
			Pal[i*3]=w->Global256Palette[i].r*4;
			Pal[i*3+1]=w->Global256Palette[i].g*4;
			Pal[i*3+2]=w->Global256Palette[i].b*4;
		}

		SetPal(Pal);
	}

	// Setup a camera
    c=PV_CreateCam("zeCam");
    PV_SetCamFieldOfView(c,Width/Height);
    c->Height=Height;
    c->Width=Width;
    c->CenterX=Width/2;
    c->CenterY=Height/2;    
	PV_SetCamPos(c,0,100,100);
	PV_SetCamTarget(c,0,0,0);

    // Panard Primitive Setup
    pvSetMode(PV_3D);								// 3D drawing    
    pvSetCull(PV_CULL_NONE);						// every faces will be displayed
	pvSetLightingMode(PV_NOLIGHTING);				// Perform lighting ourself

	pvSetCamera(c);
    pvSetModelMatrix(Id);
    pvSetModelPos(Pos);
    pvSetModelPivot(Pos);

	pvSetMaterial(mat);								// Sets the current filling material
}

void PVEasy::Animate(void)
{
    struct coord *coord;
    int i, j;
	static float ax=0,ay=0,az=0;
	PVMat3x3 m;

	Fill(0,0,0,Height,Width,0);
    
    curFrame++;    
    if (curFrame >= theMesh.frames) {
    curFrame = 0;
    }

	SetupMatrix3x3(m,ax,ay,az);
	az+=2*PI/50;
	pvSetModelMatrix(m);
    
	PV_BeginFrame();

	pvBegin(PV_QUADS,Lock());
    for (i = 0; i < theMesh.widthX-1; i++) {
    for (j = 0; j < theMesh.widthY-1; j++) {

        coord = GETCOORD(curFrame, i, j);

		pvNormal(coord->normal[0],coord->normal[1],coord->normal[2]);
		pvVertex(coord->vertex[0],coord->vertex[1],coord->vertex[2]);

		coord = GETCOORD(curFrame, i+1, j);

		pvNormal(coord->normal[0],coord->normal[1],coord->normal[2]);
		pvVertex(coord->vertex[0],coord->vertex[1],coord->vertex[2]);

		coord = GETCOORD(curFrame, i+1, j+1);

		pvNormal(coord->normal[0],coord->normal[1],coord->normal[2]);  
		pvVertex(coord->vertex[0],coord->vertex[1],coord->vertex[2]);

		coord = GETCOORD(curFrame, i, j+1);

		pvNormal(coord->normal[0],coord->normal[1],coord->normal[2]);  
		pvVertex(coord->vertex[0],coord->vertex[1],coord->vertex[2]);        
    }
    }

	pvEnd();
	Unlock();

	PV_EndFrame();

	Flip();
}

int PVEasy::OnIdle(void)
{
	Animate();
	return TRUE;
}

//////////////////////////////////////////////////////////////

int main(int argc,char **argv)
{
	PVEasy pve;
	DDInfo *ddi;

	InitPVision();

	printf("Panard Vision : Ambient mapped filtered wave using Panard Primitive 3D\n ALT+F4 to quit.");
	printf("\nRun this in true RGB modes (ie >8bit) on a fast machine, bilinear is CPU crunching");
	printf("\n\nPanard Vision version : %s\nBuild : %s, %s\n",PVISION_VERSION,PVISION_DATE,PVISION_TIME);
	
	// Direct X Initialization
	ddi=DoDXMenu();	
	if(ddi==NULL) return 1;	
	if(pve.SetMode(&ddi->GUID,NULL,ddi->Width,ddi->Height,ddi->Depth,!ddi->Windowed)!=0) return 1;
		
	// Panard Vision Setup
	pve.InitPV();

	// Mesh Setup
	pve.InitMesh();	

	// Some nice things
	pve.Run();

	return 0;
}
