// Panard Vision Sample
// (C) 1997-98, Olivier Brunet (bruneto@efrei.fr)

// Demonstrates Mirrors, for a more strong sample see the comment at the beginning of ddwin.cpp
// in the ViewerSrc\ directory

// SMKaribou/GMF

#include <stdio.h>
#include <pvision.h>
#include <3dsread.h>						// The 3dstudio 4 driver
#include <pvut.h>
#include "DirectDrawEasy.h"
#include "DXMen.h"

class PVEasy:public DDrawEasy
{
	PVWorld *World;
	PVCam *Cam;	

	PVMesh *Mesh1;
	float ax,ay,az;

public:
	PVEasy();
	~PVEasy();
	void InitPV(void);
	int OnIdle(void);
};

///////////////////////////////////////////////////////////////////////////////
PVEasy::PVEasy()
{
	ax=ay=az=0;
	World=NULL;
	Cam=NULL;
}

PVEasy::~PVEasy()
{
	// Destructor
	PV_KillWorld(World);
	PV_KillCam(Cam);
}

void PVEasy::InitPV(void)
{
    PVRGBF ambient={0.5,0.5,0.5,0};    // Ambient Light
    PVRGBF em={0,0,0,0};				 // Material's emmissive
	PVRGBF di={1,1,1,1};				 // Material's diffuse
	PVRGBF sp={0,0,0,0};				 // Material's Specular

    PVMaterial *m;

    // Render Mode Setup
    PV_SetClipLimit(0,Width-1,0,Height-1,Pitch);			// Sets rendering window   
	
	PV_SetMode((Depth!=8?PVM_RGB:PVM_PALETIZED8));			// Sets rendering mode

	if(!(PV_Mode&PVM_PALETIZED8)) 
	{
		// We are in RGB rendering, sets the RGB masks according to the current device
		PV_SetRGBIndexingMode(GetMaskSize(RedMask),GetMaskSize(GreenMask),GetMaskSize(BlueMask),GetMaskPos(RedMask),GetMaskPos(GreenMask),GetMaskPos(BlueMask),GetMaskSize(AlphaMask));
	}
	
	// World setup
	World=PV_CreateWorld();
	if(World==NULL)
	{
		Error("Unable to Create World");
		exit(1);
	}
	if(Depth==8) World->ReservedColors=10;							// the 10 first colors are for windows
	PV_WorldSetAmbientLight(World,ambient);

	// Camera Setup
	Cam=PV_CreateCam("CAMERA");
	if(Cam==NULL)
	{
		Error("Unable to create camera");
		exit(1);
	}
	PV_SetCamFieldOfView(Cam,Width/Height);
	Cam->Height=Height;
    Cam->Width=Width;
	Cam->CenterX=Width/2;
	Cam->CenterY=Height/2;
	World->Camera=Cam;
	PV_SetCamPos(Cam,0,-100,800);

	// Mesh Setup
	if(LoadMeshFrom3DS("../data/cube.3ds",World)!=COOL)
	{
		Error("Unable to load mesh");
		exit(1);
	}
	Mesh1=World->Objs;		// Gets a pointer to the first mesh
	PV_MeshSetupPos(Mesh1,0,-100,-350);

    // Material Setup
    m=PV_CreateMaterial("APE",PERSPECTIVE|MAPPING,TEXTURE_RGB,0);	// Gets a perspective textured material, APE is the material of the cube 
	PV_SetMaterialLightInfo(m,em,di,sp,0);							// Sets material light props
	if(Depth==8)
	{
		PV_SetMaterialPureColorsIndex(m,10,245);					// Sets the extent of the used colors for gouraud inside the whole palette
	}
	if(pvuLoadJpeg("../data/seymou21.jpg",m)!=COOL)
	{
		Error("Unable to load texture");
		exit(1);
	}
	PV_AddMaterial(World,m);

    // Prepare to render
	printf("Thinking please wait ...\n");
	if(PV_CompileMeshes(World)!=COOL)
	{
		Error("Unable to compile meshes");
		exit(1);
	}
	if(PV_CompileMaterials(World,NULL,NULL)!=COOL)
	{
		Error("Unable to compile materials");
		exit(1);
	}

	// Sets the final reduced color map if needed
	if(Depth==8)
	{
		// We are on a paletized device, sets a grayscale palette 		
		char Pal[256*3];
		unsigned i;
		for(i=0;i<256;i++)
		{
			// This is because PV's palette is from 0 to 64
			Pal[i*3]=World->Global256Palette[i].r*4;
			Pal[i*3+1]=World->Global256Palette[i].g*4;
			Pal[i*3+2]=World->Global256Palette[i].b*4;
		}

		SetPal(Pal);
	}

	// Adds a mirror, no more than 8 vertices per mirror
	// There is a limit in the number of mirrors, but I'm too lazzy to calc this now :)
	// Don't forget that the mirror polygon should be planar !
	PV_AddMirror(World,PV_CreateMirror());
    World->Mirrors->NbrVertexes=4;
    
	World->Mirrors->Vertex[0].xf=-150;
    World->Mirrors->Vertex[0].yf=30;
    World->Mirrors->Vertex[0].zf=-550;
    
	World->Mirrors->Vertex[1].xf=+130;
    World->Mirrors->Vertex[1].yf=30;
    World->Mirrors->Vertex[1].zf=-550;
    
	World->Mirrors->Vertex[2].xf=+130;
    World->Mirrors->Vertex[2].yf=100;
    World->Mirrors->Vertex[2].zf=40;
    
	World->Mirrors->Vertex[3].xf=-150;
    World->Mirrors->Vertex[3].yf=100;
    World->Mirrors->Vertex[3].zf=40;
    PV_SetupMirror(World->Mirrors);
}

int PVEasy::OnIdle(void)
{		
	Fill(0,0,0,Height,Width,0);

	// Animate the beauty
	ay+=PI/50;
	az+=PI/40;
	if(ay>2*PI) ay-=2*PI;
	if(az>2*PI) az-=2*PI;

	PV_MeshSetupMatrix(Mesh1,ay,ax,ax);
	
	// The Lock primitives gives access to the DirectDraw surface
	// The surface should be unlocked ASAP!
	PV_RenderWorld(World,Lock());

	Unlock();
		
	Flip();

	return TRUE;
}

//////////////////////////////////////////////////////////////

int main(int argc,char **argv)
{
	PVEasy pve;
	DDInfo *ddi;

	InitPVision();

	printf("Panard Vision : Mirror demonstration\n ALT+F4 to quit.");
	printf("\n\nPanard Vision version : %s\nBuild : %s, %s\n",PVISION_VERSION,PVISION_DATE,PVISION_TIME);
	
	// Direct X Initialization
	ddi=DoDXMenu();	
	if(ddi==NULL) return 1;	
	if(pve.SetMode(&ddi->GUID,NULL,ddi->Width,ddi->Height,ddi->Depth,!ddi->Windowed)!=0) return 1;
		
	// Panard Vision Setup
	pve.InitPV();

	// Some nice things
	pve.Run();

	return 0;
}
