// Panard Vision Sample
// (C) 1997-98, Olivier Brunet (bruneto@efrei.fr)

// Hardware acceleration, demonstrates some materials attributes

// Uncomment commented lines and comment corresponding lines to run this in software
// It's not clear I know, just look at the source you will see the light

// SMKaribou/GMF

#include <stdio.h>
#include <pvision.h>
#include <pvut.h>
#include "DirectDrawEasy.h"
#include "DXMen.h"

#include "pvgl.h"							// Direct3D driver, change at will

class PVEasy:public DDrawEasy
{
	PVMaterial *m,*m2;
public:
	void InitPV(void);
	int OnIdle(void);
};

///////////////////////////////////////////////////////////////////////////////

void PVEasy::InitPV(void)
{
    PVRGBF ambient={0.1,0.1,0.1,0};    // Ambient Light
    PVRGBF em={0,0,0,0};				 // Material's emmissive
	PVRGBF di={1,1,1,1};				 // Material's diffuse
	PVRGBF sp={0,0,0,0};				 // Material's Specular    

    // Render Mode Setup
    PV_SetClipLimit(0,Width-1,0,Height-1,Pitch);			// Sets rendering window
    PV_SetHardwareDriver(&PVDriver);						// Register the hardware driver
	//PV_SetRGBIndexingMode(GetMaskSize(RedMask),GetMaskSize(GreenMask),GetMaskSize(BlueMask),GetMaskPos(RedMask),GetMaskPos(GreenMask),GetMaskPos(BlueMask),GetMaskSize(AlphaMask));
	
	// Starts Hardware
    	if(PV_InitAccelSupport((long)win)!=COOL)                                                       // Other driver needs a handle to the window
	//if(PV_InitAccelSupport((long)lpDD)!=COOL)				// The Direct3D driver needs a pointer to the DirectDraw object, other driver take the window handle
	{
		printf("Unable to initialize hardware");
		exit(1);
	}

	PV_SetMode(PVM_ZBUFFER|PVM_RGB|PVM_USEHARDWARE);					// Sets rendering mode
	//PV_SetMode(PVM_ZBUFFER|PVM_RGB);									// Sets rendering mode
	
    // Material Setup
    m=PV_CreateMaterial("SMOOTH MATERIAL",GOURAUD|ZBUFFER,TEXTURE_NONE,0);	// Gets a GOURAUD shaded material
	PV_SetMaterialLightInfo(m,em,di,sp,0);							// Sets material light props
    PV_CompileMaterial(m,NULL,NULL,ambient,0);						// Prepare material for use

	m2=PV_CreateMaterial("TEXTURE MATERIAL",MAPPING|NOTHING,TEXTURE_RGB,0);	// Gets a mapped material
	pvuLoadJpeg("../data/seymou21.jpg",m2);
	
	PV_SetMaterialLightInfo(m2,em,di,sp,0);							// Sets material light props
	m2->RepeatU=TEXTURE_WRAP;										// Texture wrapping modes
	m2->RepeatV=TEXTURE_CLAMP;
    PV_CompileMaterial(m2,NULL,NULL,ambient,0);						// Prepare material for use

    // Panard Primitive Setup
    pvSetMode(PV_2D);								// 2.5D drawing
    pvSetCull(PV_CULL_NONE);						// every faces will be displayed	
	pvSetDepthField(1,1000);						// Sets the possible Z extent of the scene (useful for perspective correction or ZBuffer)
	pvSetAmbientLight(0.1,0.1,0.1,0);
}

int PVEasy::OnIdle(void)
{	
	PV_FillSurface(0,0,0,0,0);
//Fill(0,0,0,Height,Width,0);

	PV_BeginFrame();						// This required before every drawing, it clears zbuffer by example											
		
	pvBegin(PV_TRIANGLES,0);				// 0 always means render to backbuffer
//pvBegin(PV_TRIANGLES,Lock());
		
		// First draw 2 triangles with 'normal' zbuffering
		pvSetMaterial(m);	
		m->Type=GOURAUD|ZBUFFER;
		m->DepthTest=CMP_LESS;
		PV_RefreshMaterial(m);				// Tells the driver that material properties changed
		pvColor(1.0,0,0,0);
		pvVertex(0,0,0.01);		

		pvColor(0,0,1.0,0);
		pvVertex(Width/4,0,0.01);		

		pvColor(0,1.0,0,0);
		pvVertex(Width/8,Height/2,1.0);

		pvColor(0,1.0,0,0);
		pvVertex(0,Height/2,0.01);		

		pvColor(0,0,1.0,0);
		pvVertex(Width/4,Height/2,0.01);		

		pvColor(1.0,0,0,0);
		pvVertex(Width/8,0,0.6);
		
		// Now change the depth function
		m->DepthTest=CMP_ALWAYS;
		PV_RefreshMaterial(m);				// Tells the driver that material properties changed

		pvColor(1.0,0,0,0);
		pvVertex(0+Width/4,0,0.001);

		pvColor(0,0,1.0,0);
		pvVertex(Width/4+Width/4,0,0.001);

		pvColor(0,1.0,0,0);
		pvVertex(Width/8+Width/4,Height/2,0.8);

		m->DepthTest=CMP_GREATER;
		PV_RefreshMaterial(m);				// Tells the driver that material properties changed

		pvColor(0,1.0,0,0);
		pvVertex(0+Width/4,Height/2,0.001);

		pvColor(0,0,1.0,0);
		pvVertex(Width/4+Width/4,Height/2,0.001);

		pvColor(1.0,0,0,0);
		pvVertex(Width/8+Width/4,0,1);

		// Play with Transparency
		PV_SetMode(ADDFLAG(PV_Mode,PVM_ALPHABLENDING));
		m->DepthTest=CMP_ALWAYS;
		m->BlendRgbSrcFactor=BLEND_SRC_ALPHA;
		m->BlendRgbDstFactor=BLEND_ONE_MINUS_SRC_ALPHA;
		PV_RefreshMaterial(m);				// Tells the driver that material properties changed
		
		pvColor(1.0,0,0,1);
		pvVertex(0+Width/2,0,0.01);

		pvColor(0,0,1.0,1);
		pvVertex(Width/4+Width/2,0,0.01);

		pvColor(0,1.0,0,0);
		pvVertex(Width/8+Width/2,Height/2,0.8);
		
		m->Type=FLAT|ZBUFFER;
		PV_RefreshMaterial(m);				// Tells the driver that material properties changed

		pvColor(0,1.0,0,0.5);
		pvVertex(0+Width/2,Height/2,0.01);
		pvVertex(Width/4+Width/2,Height/2,0.01);
		pvVertex(Width/8+Width/2,0,1);

		// One More time
		m->Type=GOURAUD|ZBUFFER;
		m->BlendRgbSrcFactor=BLEND_ONE;
		m->BlendRgbDstFactor=BLEND_ZERO;
		PV_RefreshMaterial(m);				// Tells the driver that material properties changed

		pvColor(1.0,0,0,1);
		pvVertex(0+Width/4+Width/2,0,0.01);

		pvColor(0,0,1.0,1);
		pvVertex(Width/4+Width/4+Width/2,0,0.01);

		pvColor(0,1.0,0,0);
		pvVertex(Width/8+Width/4+Width/2,Height/2,0.1);

		m->BlendRgbSrcFactor=BLEND_DST_COLOR;
		m->BlendRgbDstFactor=BLEND_ZERO;
		PV_RefreshMaterial(m);				// Tells the driver that material properties changed

		pvColor(0,1.0,0,1);
		pvVertex(0+Width/4+Width/2,Height/2,0.01);

		pvColor(0,0,1.0,1);
		pvVertex(Width/4+Width/4+Width/2,Height/2,0.01);

		pvColor(1.0,0,0,0);
		pvVertex(Width/8+Width/4+Width/2,0,1);

		PV_SetMode(REMOVEFLAG(PV_Mode,PVM_ALPHABLENDING));		
	pvEnd();
//Unlock();
		
	// Now some mapping stuffs
	pvBegin(PV_QUADS,0);
//pvBegin(PV_QUADS,Lock());
		pvSetMaterial(m2);
		m2->Type=NOTHING|MAPPING;
		PV_RefreshMaterial(m2);				// Tells the driver that material properties changed

		pvMapCoord(0,0);
		pvVertex(0,0+Height/2,1);
		
		pvMapCoord(1,0);
		pvVertex(Width/4,0+Height/2,1);
		
		pvMapCoord(1,1);
		pvVertex(Width/4,Height/2+Height/2,1);
		
		pvMapCoord(0,1);
		pvVertex(0,Height/2+Height/2,1);

		// The same alpha blended
		PV_SetMode(ADDFLAG(PV_Mode,PVM_ALPHABLENDING));
		PV_SetMode(REMOVEFLAG(PV_Mode,PVM_ZBUFFER));
		m2->BlendRgbSrcFactor=BLEND_SRC_ALPHA;
		m2->BlendRgbDstFactor=BLEND_ONE_MINUS_SRC_ALPHA;
		
		m2->Type=GOURAUD|MAPPING;
		PV_RefreshMaterial(m2);				// Tells the driver that material properties changed

		pvColor(1,1,1,0.5);
		pvMapCoord(0,0);
		pvVertex(Width/8,0+Height/2,1);
				
		pvColor(1,0,0,0.9);
		pvMapCoord(1,0);
		pvVertex(Width/4,0+Height/2+Height/4,1);
				
		pvColor(0,1,0,0.9);
		pvMapCoord(1,1);
		pvVertex(Width/8,Height,1);
		
		pvColor(0,0,1,0.9);
		pvMapCoord(0,1);
		pvVertex(0,Height/2+Height/4,1);
		PV_SetMode(REMOVEFLAG(PV_Mode,PVM_ALPHABLENDING));
		PV_SetMode(ADDFLAG(PV_Mode,PVM_ZBUFFER));		

		// Now Play with Wrapping modes 
		m2->Type=NOTHING|MAPPING;
		PV_RefreshMaterial(m2);				// Tells the driver that material properties changed

		pvMapCoord(0,0);
		pvVertex(0+Width/4,0+Height/2,1);
		
		pvMapCoord(4,0);
		pvVertex(Width/4+Width/4,0+Height/2,1);
		
		pvMapCoord(4,2);
		pvVertex(Width/4+Width/4,Height/2+Height/2,1);
		
		pvMapCoord(0,2);
		pvVertex(0+Width/4,Height/2+Height/2,1);

		// Alpha test
		PV_SetMode(ADDFLAG(PV_Mode,PVM_ALPHATESTING));
		m2->AlphaReference=0.8;
		m2->AlphaTest=CMP_GREATER;

		m2->Type=GOURAUD|NOTHING;
		PV_RefreshMaterial(m2);				// Tells the driver that material properties changed

		pvColor(1,1,1,0.1);
		pvMapCoord(0,0);
		pvVertex(Width/8+Width/2,0+Height/2,1);
				
		pvColor(1,0,0,0.9);
		pvMapCoord(1,0);
		pvVertex(Width/4+Width/2,0+Height/2+Height/4,1);
				
		pvColor(0,1,0,0.9);
		pvMapCoord(1,1);
		pvVertex(Width/8+Width/2,Height,1);
		
		pvColor(0,0,1,0.9);
		pvMapCoord(0,1);
		pvVertex(0+Width/2,Height/2+Height/4,1);
		PV_SetMode(REMOVEFLAG(PV_Mode,PVM_ALPHATESTING));		
		
	pvEnd();	
//Unlock();

	PV_EndFrame();							// Same as BeginFrame

	Print(0,0,"CMP_LESS depth function");
	Print(Width/4,0,"CMP_ALWAYS & CMP_GREATER");
	Print(Width/2+Width/8,0,"Alpha Blending : using BLEND_xxxx");
	Print(0,Height/2,"Gouraud Texture Blending");
	Print(Width/4,Height/2,"Wrapping modes");
	Print(Width/2,Height/2,"Alpha testing");	
		
	PV_FlipSurface();
//Flip();		

	return TRUE;
}

//////////////////////////////////////////////////////////////

int main(int argc,char **argv)
{
	PVEasy pve;
	DDInfo *ddi;

	InitPVision();

	printf("Panard Vision : Hardware acceleration example through Direct3D\n Demonstrates some materials properties\n ALT+F4 to quit.");
	printf("\n\nPanard Vision version : %s\nBuild : %s, %s\n",PVISION_VERSION,PVISION_DATE,PVISION_TIME);
	
	// Direct X Initialization
	ddi=DoDXMenu();	
	if(ddi==NULL) return 1;	
	if(pve.SetMode(&ddi->GUID,NULL,ddi->Width,ddi->Height,ddi->Depth,!ddi->Windowed)!=0) return 1;
		
	// Panard Vision Setup
	pve.InitPV();

	// Some nice things
	pve.Run();

	PV_EndAccelSupport();				// Stops hardware

	return 0;
}
