// Panard Vision Sample
// (C) 1997-98, Olivier Brunet (bruneto@efrei.fr)

// Demonstrates LoadMesh, ZBuffer and world management
// Hardware version (see depht field controlling functions)

// SMKaribou/GMF

#include <stdio.h>
#include <pvision.h>
#include <3dsread.h>						// The 3dstudio 4 driver
#include "DirectDrawEasy.h"
#include "DXMen.h"
#include "pvgl.h"							// D3D driver

class PVEasy:public DDrawEasy
{
	PVWorld *World;
	PVCam *Cam;
	PVLight *Light;

	PVMesh *Mesh1,*Mesh2;
	float ax,ay,az;

public:
	PVEasy();
	~PVEasy();
	void InitPV(void);
	int OnIdle(void);
};

///////////////////////////////////////////////////////////////////////////////
PVEasy::PVEasy()
{
	ax=ay=az=0;
	World=NULL;
	Cam=NULL;
	Light=NULL;
}

PVEasy::~PVEasy()
{
	// Destructor
	PV_EndAccelSupport();
	PV_KillWorld(World);
	PV_KillCam(Cam);
	PV_KillLight(Light);
}

void PVEasy::InitPV(void)
{
    PVRGBF ambient={0.1,0.1,0.1,0};    // Ambient Light
    PVRGBF em={0,0,0,0};				 // Material's emmissive
	PVRGBF di={1,1,1,1};				 // Material's diffuse
	PVRGBF sp={0,0,0,0};				 // Material's Specular

    PVMaterial *m;

    // Render Mode Setup
    PV_SetClipLimit(0,Width-1,0,Height-1,Pitch);			// Sets rendering window   
	
	PV_SetHardwareDriver(&PVDriver);						// Register hardware driver


	// Starts Hardware
	if(PV_InitAccelSupport(/*(long)lpDD*/(long)win)!=COOL)				// The Direct3D driver needs a pointer to the DirectDraw object, other driver take the window handle
	{
		printf("Unable to initialize hardware");
		exit(1);
	}

	PV_SetMode(PVM_USEHARDWARE|PVM_ZBUFFER|(Depth!=8?PVM_RGB:PVM_PALETIZED8));			// Sets rendering mode (ZBuffer)

	if(!(PV_Mode&PVM_PALETIZED8)) 
	{
		// We are in RGB rendering, sets the RGB masks according to the current device
		PV_SetRGBIndexingMode(GetMaskSize(RedMask),GetMaskSize(GreenMask),GetMaskSize(BlueMask),GetMaskPos(RedMask),GetMaskPos(GreenMask),GetMaskPos(BlueMask),GetMaskSize(AlphaMask));
	}
	else
	{
		// We are on a paletized device, sets a grayscale palette 
		char p[768];

		for(int i=0;i<256;i++)
		{
			p[i*3]=i;
			p[i*3+1]=i;
			p[i*3+2]=i;
		}
		SetPal(p);
	}

	// World setup
	World=PV_CreateWorld();
	if(World==NULL)
	{
		Error("Unable to Create World");
		exit(1);
	}
	if(Depth==8) World->ReservedColors=10;							// the 10 first colors are for windows
	PV_WorldSetAmbientLight(World,ambient);

	// Camera Setup
	Cam=PV_CreateCam("CAMERA");
	if(Cam==NULL)
	{
		Error("Unable to create camera");
		exit(1);
	}
	PV_SetCamFieldOfView(Cam,Width/Height);
	Cam->Height=Height;
    Cam->Width=Width;
	Cam->CenterX=Width/2;
	Cam->CenterY=Height/2;
	World->Camera=Cam;
	Cam->pos.yf=-100;
	Cam->pos.zf=800;
	Cam->FrontDist=500;				// Sets a reasonable depth field, hardware have a limited precision for depth buffering
	Cam->BackDist=1000;

	// Light Setup
	Light=PV_CreateLight(PVL_DIRECTIONAL,"LIGHT");
	if(Light==NULL)
	{
		Error("Unable to create light");
		exit(1);
	}
	PV_AddLight(World,Light);
	PV_SetLightDirection(Light,0,0,-1);
	Light->Color.g=0;

	// Mesh Setup
	if(LoadMeshFrom3DS("../data/cube.3ds",World)!=COOL)
	{
		Error("Unable to load mesh");
		exit(1);
	}
	Mesh1=World->Objs;		// Gets a pointer to the first mesh
	if(LoadMeshFrom3DS("../data/cube.3ds",World)!=COOL)
	{
		Error("Unable to load mesh");
		exit(1);
	}
	Mesh2=World->Objs;		// Gets a pointer to the first mesh

    // Material Setup
    m=PV_CreateMaterial("APE",FLAT|ZBUFFER,TEXTURE_NONE,0);             // Gets a FLAT shaded material, APE is the material of the cube (activate ZBuffer for this material)
	PV_SetMaterialLightInfo(m,em,di,sp,0);							// Sets material light props
	if(Depth==8)
	{
		PV_SetMaterialPureColorsIndex(m,10,245);					// Sets the extent of the used colors for gouraud inside the whole palette
	}
	PV_AddMaterial(World,m);

    // Prepare to render
	if(PV_CompileMeshes(World)!=COOL)
	{
		Error("Unable to compile meshes");
		exit(1);
	}
	if(PV_CompileMaterials(World,NULL,NULL)!=COOL)
	{
		Error("Unable to compile materials");
		exit(1);
	}

}

int PVEasy::OnIdle(void)
{		
	PV_FillSurface(0,0,0,0,0);

	// Animate the beauty
	ay+=PI/50;
	az+=PI/40;
	if(ay>2*PI) ay-=2*PI;
	if(az>2*PI) az-=2*PI;

	PV_MeshSetupMatrix(Mesh1,ax,ay,az);
	PV_MeshSetupMatrix(Mesh2,az,ay,ax);
	
	// The second parameter of PV_RenderWorld is the surface number where the scene will be rendered	
	PV_BeginFrame();
	PV_RenderWorld(World,0);
	PV_EndFrame();
	//Sleep(100);
		
	PV_FlipSurface();

	return TRUE;
}

//////////////////////////////////////////////////////////////

int main(int argc,char **argv)
{
	PVEasy pve;
	DDInfo *ddi;

	InitPVision();

	printf("Panard Vision : LoadMesh demonstration with ZBuffer\nHardware version\n ALT+F4 to quit.");
	printf("\n\nPanard Vision version : %s\nBuild : %s, %s\n",PVISION_VERSION,PVISION_DATE,PVISION_TIME);
	
	// Direct X Initialization
	ddi=DoDXMenu();	
	if(ddi==NULL) return 1;	
	if(pve.SetMode(&ddi->GUID,NULL,ddi->Width,ddi->Height,ddi->Depth,!ddi->Windowed)!=0) return 1;
		
	// Panard Vision Setup
	pve.InitPV();

	// Some nice things
	pve.Run();

	return 0;
}
