// Panard Vision Sample
// (C) 1997-98, Olivier Brunet (bruneto@efrei.fr)

// Some dynamic things using Panard Primitves 3D

// This sample is directly taken/converted/simplified from the OpenGL SDK for MS Windows 95
// The conversion has been done straight forward, that's why it's not as clean as
// it should be :) Enjoy.

// Moreover, a great performance improvement would appear if instead of using Panard Primitives
// we use the mesh oriented functions of PV. This is an exercise left to the reader :)

// This samples demonstrates also palette management

// Mesh is drawn with indexed Panard Primitives (faster), for normal primitives drawing
// see tut9

// SMKaribou/GMF

#include <math.h>
#include <stdio.h>
#include <pvision.h>
#include "DirectDrawEasy.h"
#include "DXMen.h"


#define GETCOORD(frame, x, y) (&(theMesh.coords[frame*theMesh.numCoords+(x)+(y)*(theMesh.widthX+1)]))
#define GETFACET(frame, x, y) (&(theMesh.facets[frame*theMesh.numFacets+(x)+(y)*theMesh.widthX]))

class PVEasy:public DDrawEasy
{
public:
	struct facet {
    float color[3];
    float normal[3];
};

struct coord {
    float vertex[3];
    float normal[3];
};

struct mesh {
    int widthX, widthY;
    int numFacets;
    int numCoords;
    int frames;
    struct coord *coords;
    struct facet *facets;
} theMesh;

	int widthX, widthY;
	int checkerSize;
	float height;

	int frames, curFrame, nextFrame;

	PVMaterial *red,*green;

	// Member functions
	PVEasy();
	void InitPV(void);
	void InitMesh(void);
	void Animate(void);
	void SetColorMap(void);
	int OnIdle(void);
};

///////////////////////////////////////////////////////////////////////////////
PVEasy::PVEasy():DDrawEasy()
{
	curFrame=nextFrame=0;
    frames = 10;
    widthX = 10;
    widthY = 10;
    checkerSize = 2;
    height = 0.2;
}

void PVEasy::InitMesh(void)
{
    struct coord *coord;
    struct facet *facet;
    float dp1[3], dp2[3];
    float *pt1, *pt2, *pt3;
    float angle, d, x, y;
    int numFacets, numCoords, frameNum, i, j;

    theMesh.widthX = widthX;
    theMesh.widthY = widthY;
    theMesh.frames = frames;

    numFacets = widthX * widthY;
    numCoords = (widthX + 1) * (widthY + 1);

    theMesh.numCoords = numCoords;
    theMesh.numFacets = numFacets;

    theMesh.coords = (struct coord *)malloc(frames*numCoords*
                        sizeof(struct coord));
    theMesh.facets = (struct facet *)malloc(frames*numFacets*
                        sizeof(struct facet));
    if (theMesh.coords == NULL || theMesh.facets == NULL) {
		printf("Out of memory.\n");
		exit(1);
    }

    for (frameNum = 0; frameNum < frames; frameNum++) {
    for (i = 0; i <= widthX; i++) {
        x = i / (float)widthX;		

        for (j = 0; j <= widthY; j++) {
        y = j / (float)widthY;

        d = sqrt(x*x+y*y);
        if (d == 0.0) {
            d = 0.0001;
        }
        angle = 2 * PI * d + (2 * PI / frames * frameNum);

        coord = GETCOORD(frameNum, i, j);

        coord->vertex[0] = 100*(x - 0.5);
        coord->vertex[1] = 100*(y - 0.5);
        coord->vertex[2] = 100*(height - height * d) * cos(angle);

        coord->normal[0] = -(height / d) * x * ((1 - d) * 2 * PI *
                   sin(angle) + cos(angle));
        coord->normal[1] = -(height / d) * y * ((1 - d) * 2 * PI *
                   sin(angle) + cos(angle));
        coord->normal[2] = -1;

        d = 1.0 / sqrt(coord->normal[0]*coord->normal[0]+
                   coord->normal[1]*coord->normal[1]+1);
        coord->normal[0] *= d;
        coord->normal[1] *= d;
        coord->normal[2] *= d;
        }
    }
    for (i = 0; i < widthX; i++) {
        for (j = 0; j < widthY; j++) {
        facet = GETFACET(frameNum, i, j);
        if (((i/checkerSize)%2)^(j/checkerSize)%2) {
            if (Depth!=8) {
            facet->color[0] = 1.0;
            facet->color[1] = 0.2;
            facet->color[2] = 0.2;
            } else {
            facet->color[0] = 100+100+15;
            facet->color[1] = 0;
            facet->color[2] = 0;
            }
        } else {
            if (Depth!=8) {
            facet->color[0] = 0.2;
            facet->color[1] = 1.0;
            facet->color[2] = 0.2;
            } else {
            facet->color[0] = 100+15;
            facet->color[1] = 0;
            facet->color[2] = 0;
            }
        }
        pt1 = GETCOORD(frameNum, i, j)->vertex;
        pt2 = GETCOORD(frameNum, i, j+1)->vertex;
        pt3 = GETCOORD(frameNum, i+1, j+1)->vertex;

        dp1[0] = pt2[0] - pt1[0];
        dp1[1] = pt2[1] - pt1[1];
        dp1[2] = pt2[2] - pt1[2];

        dp2[0] = pt3[0] - pt2[0];
        dp2[1] = pt3[1] - pt2[1];
        dp2[2] = pt3[2] - pt2[2];

        facet->normal[0] = dp1[1] * dp2[2] - dp1[2] * dp2[1];
        facet->normal[1] = dp1[2] * dp2[0] - dp1[0] * dp2[2];
        facet->normal[2] = dp1[0] * dp2[1] - dp1[1] * dp2[0];

        d = 1.0 / sqrt(facet->normal[0]*facet->normal[0]+
                   facet->normal[1]*facet->normal[1]+
                   facet->normal[2]*facet->normal[2]);

        facet->normal[0] *= d;
        facet->normal[1] *= d;
        facet->normal[2] *= d;
        }
    }
    }
}

void PVEasy::InitPV(void)
{
    PVRGBF ambient={0.1,0.1,0.1,0};    // Ambient Light
    PVRGBF em={0,0,0,0};				 // Material's emmissive
	PVRGBF di={1,1,1,1};				 // Material's diffuse
	PVRGBF sp={0,0,0,0};				 // Material's Specular

    PVMat3x3 Id={1,0,0,0,1,0,0,0,1};
    PVPoint Pos={0,0,0};

    PVCam *c;
	PVLight *l;
	unsigned lHandle;

    // Render Mode Setup
    PV_SetClipLimit(0,Width-1,0,Height-1,Pitch);			// Sets rendering window
    PV_SetMode(Depth==8?PVM_PALETIZED8:PVM_RGB);			// Sets rendering mode

	if(!(PV_Mode&PVM_PALETIZED8)) 
	{
		// We are in RGB rendering, sets the RGB masks according to the current device
		PV_SetRGBIndexingMode(GetMaskSize(RedMask),GetMaskSize(GreenMask),GetMaskSize(BlueMask),GetMaskPos(RedMask),GetMaskPos(GreenMask),GetMaskPos(BlueMask),GetMaskSize(AlphaMask));
	}
	else
	{
		// We are on a paletized device, sets a nice palette 
		char p[768];

		for(int i=15;i<100+15;i++)
		{
			p[i*3]=(float)(255*(i-15))/(float)100;
			p[i*3+1]=0;
			p[i*3+2]=0;
		}
		for(i=100+15;i<100+15+100;i++)
		{
			p[i*3]=0;
			p[i*3+1]=(float)(255*(i-100-15))/(float)100;
			p[i*3+2]=0;
		}
		SetPal(p);
	}

    // Material Setup
	em.r=0.3;
	di.r=1.0;
	di.g=0.2;
	di.b=0.4;
    red=PV_CreateMaterial("RED",GOURAUD,TEXTURE_NONE,0);		// Gets a GOURAUD shaded material
	PV_SetMaterialLightInfo(red,em,di,sp,0);					// Sets material light props
	if(Depth==8) PV_SetMaterialPureColorsIndex(red,15,114);		// Sets the extent of the used colors for gouraud inside the whole palette
	PV_CompileMaterial(red,NULL,NULL,ambient,0);				// Prepare material for use

	em.g=0.3;
	em.r=0;
	di.g=1.0;
	di.r=0.2;
	di.b=0.4;
    green=PV_CreateMaterial("GREEN",GOURAUD,TEXTURE_NONE,0);	// Gets a GOURAUD shaded material
	PV_SetMaterialLightInfo(green,em,di,sp,0);					// Sets material light props
	if(Depth==8) PV_SetMaterialPureColorsIndex(green,115,214);  // Sets the extent of the used colors for gouraud inside the whole palette
    PV_CompileMaterial(green,NULL,NULL,ambient,0);				// Prepare material for use

	// Setup a camera
    c=PV_CreateCam("zeCam");
    PV_SetCamFieldOfView(c,Width/Height);
    c->Height=Height;
    c->Width=Width;
    c->CenterX=Width/2;
    c->CenterY=Height/2;    
	PV_SetCamPos(c,0,100,100);
	PV_SetCamTarget(c,0,0,0);

	// And a light
	l=PV_CreateLight(PVL_DIRECTIONAL,"LIGHT");
	PV_SetLightDirection(l,0,-1,0);
	l->Color.r=0.3;									// Some coloured light
	l->Color.g=0.7;
	l->Color.b=1;

    // Panard Primitive Setup
    pvSetMode(PV_3D);								// 3D drawing    
    pvSetCull(PV_CULL_NONE);						// every faces will be displayed
	pvSetLightingMode(PV_LIGHTING);					// Perform lighting
	pvAddLight(l,&lHandle);							// But in case we need a light, set it

	pvSetCamera(c);
    pvSetModelMatrix(Id);
    pvSetModelPos(Pos);
    pvSetModelPivot(Pos);
}

void PVEasy::Animate(void)
{
    struct coord *coord;
    struct facet *facet;
    float *thisColor;
    int i, j;
	static float ax=0,ay=0,az=0;
	PVMat3x3 m;

	Fill(0,0,0,Height,Width,0);
	    
    curFrame++;    
    if (curFrame >= theMesh.frames) curFrame = 0;

	SetupMatrix3x3(m,ax,ay,az);
	az+=2*PI/50;
	pvSetModelMatrix(m);
    
	PV_BeginFrame();

	// Indexed primitive setup
	pvEnableIndex(PPI_NORMAL);		// Vertex+normal data will be transfered with each call
									// to pvVertexIndexedf
	pvSetVertexIndex(&theMesh.coords[curFrame*theMesh.numCoords].vertex[0],sizeof(struct coord));
	pvSetNormalIndex(&theMesh.coords[curFrame*theMesh.numCoords].normal[0],sizeof(struct coord));

	pvBegin(PV_QUADS,Lock());
    for (i = 0; i < theMesh.widthX-1; i++) 
    for (j = 0; j < theMesh.widthY-1; j++) {

        facet = GETFACET(curFrame, i, j);
        coord = GETCOORD(curFrame, i, j);

		if (((i/checkerSize)%2)^(j/checkerSize)%2) {
			pvSetMaterial(red);						// Sets the current filling material
		}
		else
		{
			pvSetMaterial(green);					// Sets the current filling material
		}

		pvVertexIndexedf((i)+(j)*(theMesh.widthX+1));
		pvVertexIndexedf((i+1)+(j)*(theMesh.widthX+1));
		pvVertexIndexedf((i+1)+(j+1)*(theMesh.widthX+1));
		pvVertexIndexedf((i)+(j+1)*(theMesh.widthX+1));    
    }

	pvEnd();
	Unlock();

	PV_EndFrame();

	Flip();
}

int PVEasy::OnIdle(void)
{
	Animate();
	return TRUE;
}

//////////////////////////////////////////////////////////////

int main(int argc,char **argv)
{
	PVEasy pve;
	DDInfo *ddi;

	InitPVision();

	printf("Panard Vision : Wave using Panard Primitive 3D\n ALT+F4 to quit.");
	printf("\n\nPanard Vision version : %s\nBuild : %s, %s\n",PVISION_VERSION,PVISION_DATE,PVISION_TIME);
	
	// Direct X Initialization
	ddi=DoDXMenu();	
	if(ddi==NULL) return 1;	
	if(pve.SetMode(&ddi->GUID,NULL,ddi->Width,ddi->Height,ddi->Depth,!ddi->Windowed)!=0) return 1;
		
	// Panard Vision Setup
	pve.InitPV();

	// Mesh Setup
	pve.InitMesh();	

	// Some nice things
	pve.Run();

	return 0;
}
