// Panard Vision Sample
// (C) 1997-98, Olivier Brunet (bruneto@efrei.fr)

// Hardware acceleration

// SMKaribou/GMF

#include <stdio.h>
#include <pvision.h>
#include "DirectDrawEasy.h"
#include "DXMen.h"

#include "pvgl.h"							// Direct3D driver, change at will

class PVEasy:public DDrawEasy
{
public:
	void InitPV(void);
	int OnIdle(void);
};

///////////////////////////////////////////////////////////////////////////////

void PVEasy::InitPV(void)
{
    PVRGBF ambient={0.1,0.1,0.1,0};    // Ambient Light
    PVRGBF em={0,0,0,0};				 // Material's emmissive
	PVRGBF di={1,1,1,1};				 // Material's diffuse
	PVRGBF sp={0,0,0,0};				 // Material's Specular

    PVMaterial *m;

    // Render Mode Setup
    PV_SetClipLimit(0,Width-1,0,Height-1,Pitch);			// Sets rendering window
    PV_SetHardwareDriver(&PVDriver);						// Register the hardware driver
	
	// Starts Hardware
	if(PV_InitAccelSupport((long)win)!=COOL)
	//if(PV_InitAccelSupport((long)lpDD)!=COOL)				// The Direct3D driver needs a pointer to the DirectDraw object, other driver take the window handle
	{
		printf("Unable to initialize hardware");
		exit(1);
	}

	PV_SetMode(PVM_RGB|PVM_USEHARDWARE);					// Sets rendering mode
	
    // Material Setup
    m=PV_CreateMaterial("SMOOTH MATERIAL",GOURAUD,TEXTURE_NONE,0);	// Gets a GOURAUD shaded maetrial
	PV_SetMaterialLightInfo(m,em,di,sp,0);							// Sets material light props
    PV_CompileMaterial(m,NULL,NULL,ambient,0);						// Prepare material for use

    // Panard Primitive Setup
    pvSetMode(PV_2D);								// 2.5D drawing
    pvSetMaterial(m);								// Sets the current filling material
    pvSetCull(PV_CULL_NONE);						// every faces will be displayed	
	pvSetDepthField(1,100);							// Sets the possible Z extent of the scene (useful for perspective correction or ZBuffer)
	pvSetAmbientLight(0.1,0.1,0.1,0);
}

int PVEasy::OnIdle(void)
{	
	PV_FillSurface(0,0,0,0,0);
	PV_BeginFrame();		
	pvBegin(PV_TRIANGLES,0);				// 0 always means render to backbuffer
		pvColor(1.0,0,0,0);
		pvVertex(Width/2,0,1);

		pvColor(0,0,1.0,0);
		pvVertex(Width/4,Height-1,1);

		pvColor(0,1.0,0,0);
		pvVertex(Width/2+Width/4,Height-1,1);
	pvEnd();
	PV_EndFrame();		
		
	PV_FlipSurface();

	return TRUE;
}

//////////////////////////////////////////////////////////////

int main(int argc,char **argv)
{
	PVEasy pve;
	DDInfo *ddi;

	InitPVision();

	printf("Panard Vision : Hardware acceleration example through Direct3D\n ALT+F4 to quit.");
	printf("\n\nPanard Vision version : %s\nBuild : %s, %s\n",PVISION_VERSION,PVISION_DATE,PVISION_TIME);
	
	// Direct X Initialization
	ddi=DoDXMenu();	
	if(ddi==NULL) return 1;	
	if(pve.SetMode(&ddi->GUID,NULL,ddi->Width,ddi->Height,ddi->Depth,!ddi->Windowed)!=0) return 1;
		
	// Panard Vision Setup
	pve.InitPV();

	// Some nice things
	pve.Run();

	PV_EndAccelSupport();				// Stops hardware

	return 0;
}
