// Panard Vision Sample
// (C) 1997-98, Olivier Brunet (bruneto@efrei.fr)

// Demonstrates hand made mesh construction

// SMKaribou/GMF

#include <stdio.h>
#include <pvision.h>
#include "DirectDrawEasy.h"
#include "DXMen.h"

class PVEasy:public DDrawEasy
{
	PVWorld *World;
	PVCam *Cam;
	PVLight *Light;

	PVMesh *Mesh1,*Mesh2;
	float ax,ay,az;

public:
	PVEasy();
	~PVEasy();
	void InitPV(void);
	int OnIdle(void);
};

///////////////////////////////////////////////////////////////////////////////
PVEasy::PVEasy()
{
	ax=ay=az=0;
	World=NULL;
	Cam=NULL;
	Light=NULL;
}

PVEasy::~PVEasy()
{
	// Destructor
	PV_KillWorld(World);
	PV_KillCam(Cam);
	PV_KillLight(Light);
}

void PVEasy::InitPV(void)
{
    PVRGBF ambient={0.1,0.1,0.1,0};    // Ambient Light
    PVRGBF em={0,0,0,0};				 // Material's emmissive
	PVRGBF di={1,1,1,1};				 // Material's diffuse
	PVRGBF sp={0,0,0,0};				 // Material's Specular

    PVMaterial *m;

    // Render Mode Setup
    PV_SetClipLimit(0,Width-1,0,Height-1,Pitch);			// Sets rendering window   
	
	PV_SetMode(PVM_ZBUFFER|(Depth!=8?PVM_RGB:PVM_PALETIZED8));			// Sets rendering mode (ZBuffer)

	if(!(PV_Mode&PVM_PALETIZED8)) 
	{
		// We are in RGB rendering, sets the RGB masks according to the current device
		PV_SetRGBIndexingMode(GetMaskSize(RedMask),GetMaskSize(GreenMask),GetMaskSize(BlueMask),GetMaskPos(RedMask),GetMaskPos(GreenMask),GetMaskPos(BlueMask),GetMaskSize(AlphaMask));
	}
	else
	{
		// We are on a paletized device, sets a grayscale palette 
		char p[768];

		for(int i=0;i<256;i++)
		{
			p[i*3]=i;
			p[i*3+1]=i;
			p[i*3+2]=i;
		}
		SetPal(p);
	}

	// World setup
	World=PV_CreateWorld();
	if(World==NULL)
	{
		Error("Unable to Create World");
		exit(1);
	}
	if(Depth==8) World->ReservedColors=10;							// the 10 first colors are for windows
	PV_WorldSetAmbientLight(World,ambient);

	// Camera Setup
	Cam=PV_CreateCam("CAMERA");
	if(Cam==NULL)
	{
		Error("Unable to create camera");
		exit(1);
	}
	PV_SetCamFieldOfView(Cam,Width/Height);
	Cam->Height=Height;
    Cam->Width=Width;
	Cam->CenterX=Width/2;
	Cam->CenterY=Height/2;
	World->Camera=Cam;
	Cam->pos.yf=-100;
	Cam->pos.zf=800;

	// Light Setup
	Light=PV_CreateLight(PVL_DIRECTIONAL,"LIGHT");
	if(Light==NULL)
	{
		Error("Unable to create light");
		exit(1);
	}
	PV_AddLight(World,Light);
	PV_SetLightDirection(Light,0,0,-1);
	Light->Color.g=0;

//----------------------------------------------------------------- Hand made mesh begins here
	// Mesh Setup
	Mesh1=PV_SimpleCreateMesh(6,8,50,50);    // Randomly choosen clip values, and overestimated
	if(Mesh1==NULL) return;
    Mesh1->Flags|=MESH_NOSORT;				 // We render a cube, no need for sorting, but maybe
											 // your mesh will need :)

	Mesh1->Vertex[0].xf=-150;
    Mesh1->Vertex[0].yf=-150;
    Mesh1->Vertex[0].zf=-150;

	Mesh1->Vertex[1].xf=150;
    Mesh1->Vertex[1].yf=-150;
    Mesh1->Vertex[1].zf=-150;

	Mesh1->Vertex[2].xf=150;
    Mesh1->Vertex[2].yf=150;
    Mesh1->Vertex[2].zf=-150;

	Mesh1->Vertex[3].xf=-150;
    Mesh1->Vertex[3].yf=150;
    Mesh1->Vertex[3].zf=-150;

	Mesh1->Vertex[4].xf=-150;
    Mesh1->Vertex[4].yf=-150;
    Mesh1->Vertex[4].zf=150;

	Mesh1->Vertex[5].xf=150;
    Mesh1->Vertex[5].yf=-150;
    Mesh1->Vertex[5].zf=150;

	Mesh1->Vertex[6].xf=150;
    Mesh1->Vertex[6].yf=150;
    Mesh1->Vertex[6].zf=150;

	Mesh1->Vertex[7].xf=-150;
    Mesh1->Vertex[7].yf=150;
    Mesh1->Vertex[7].zf=150;

	// WARNING: The winding of faces matters
	// This is CounterClockWise order
	
	Mesh1->Face[0].NbrVertexes=4;        
    Mesh1->Face[0].Material=strdup("APE");		// or you let this member to NULL
												// and you set MaterialInfo insted to point
												// to the PVMaterial you want to use.
	Mesh1->Face[0].V[0]=0;
	Mesh1->Face[0].V[1]=1;
	Mesh1->Face[0].V[2]=2;
	Mesh1->Face[0].V[3]=3;

	Mesh1->Face[1].NbrVertexes=4;        
    Mesh1->Face[1].Material=strdup("APE");	

	Mesh1->Face[1].V[0]=7;
	Mesh1->Face[1].V[1]=6;
	Mesh1->Face[1].V[2]=5;
	Mesh1->Face[1].V[3]=4;


	Mesh1->Face[2].NbrVertexes=4;        
    Mesh1->Face[2].Material=strdup("APE");	

	Mesh1->Face[2].V[0]=2;
	Mesh1->Face[2].V[1]=1;
	Mesh1->Face[2].V[2]=5;
	Mesh1->Face[2].V[3]=6;

	Mesh1->Face[3].NbrVertexes=4;        
    Mesh1->Face[3].Material=strdup("APE");	

	Mesh1->Face[3].V[0]=7;
	Mesh1->Face[3].V[1]=4;
	Mesh1->Face[3].V[2]=0;
	Mesh1->Face[3].V[3]=3;

	Mesh1->Face[4].NbrVertexes=4;        
    Mesh1->Face[4].Material=strdup("APE");	

	Mesh1->Face[4].V[0]=1;
	Mesh1->Face[4].V[1]=0;
	Mesh1->Face[4].V[2]=4;
	Mesh1->Face[4].V[3]=5;

	Mesh1->Face[5].NbrVertexes=4;        
    Mesh1->Face[5].Material=strdup("APE");	

	Mesh1->Face[5].V[0]=6;
	Mesh1->Face[5].V[1]=7;
	Mesh1->Face[5].V[2]=3;
	Mesh1->Face[5].V[3]=2;

    // Normal computations, this is mandatory if you use the default PV visibility pipeline
    PV_MeshNormCalc(Mesh1);

    // And bouding boxes, this is mandatory if you use the default PV visibility pipeline
    PV_MeshBuildBoxes(Mesh1,700);
//----------------------------------------------------------------- Hand made mesh ends here

	PV_AddMesh(World,Mesh1);
	
	// to be beautiful :)
	Mesh2=PV_CloneMesh(Mesh1);	
	PV_AddMesh(World,Mesh2);
	
    // Material Setup
    m=PV_CreateMaterial("APE",FLAT|ZBUFFER,TEXTURE_NONE,0);             // Gets a FLAT shaded material, APE is the material of the cube (activate ZBuffer for this material)
	PV_SetMaterialLightInfo(m,em,di,sp,0);							// Sets material light props
	if(Depth==8)
	{
		PV_SetMaterialPureColorsIndex(m,10,245);					// Sets the extent of the used colors for gouraud inside the whole palette
	}
	PV_AddMaterial(World,m);

    // Prepare to render
	if(PV_CompileMeshes(World)!=COOL)
	{
		Error("Unable to compile meshes");
		exit(1);
	}
	if(PV_CompileMaterials(World,NULL,NULL)!=COOL)
	{
		Error("Unable to compile materials");
		exit(1);
	}

}

int PVEasy::OnIdle(void)
{		
	Fill(0,0,0,Height,Width,0);

	// Animate the beauty
	ay+=PI/50;
	az+=PI/40;
	if(ay>2*PI) ay-=2*PI;
	if(az>2*PI) az-=2*PI;

	PV_MeshSetupMatrix(Mesh1,ax,ay,az);
	PV_MeshSetupMatrix(Mesh2,az,ay,ax);
	
	// The Lock primitives gives access to the DirectDraw surface
	// The surface should be unlocked ASAP!
	PV_BeginFrame();
	PV_RenderWorld(World,Lock());
	PV_EndFrame();

	Unlock();
		
	Flip();

	return TRUE;
}

//////////////////////////////////////////////////////////////

int main(int argc,char **argv)
{
	PVEasy pve;
	DDInfo *ddi;

	InitPVision();

	printf("Panard Vision : Demonstrates hand made mesh construction\n ALT+F4 to quit.");
	printf("\n\nPanard Vision version : %s\nBuild : %s, %s\n",PVISION_VERSION,PVISION_DATE,PVISION_TIME);
	
	// Direct X Initialization
	ddi=DoDXMenu();	
	if(ddi==NULL) return 1;	
	if(pve.SetMode(&ddi->GUID,NULL,ddi->Width,ddi->Height,ddi->Depth,!ddi->Windowed)!=0) return 1;
		
	// Panard Vision Setup
	pve.InitPV();

	// Some nice things
	pve.Run();

	return 0;
}
