// Panard Vision Sample
// (C) 1997-98, Olivier Brunet (bruneto@efrei.fr)

// Demonstrates switchable nodes

// SMKaribou/GMF

#include <stdio.h>
#include <pvision.h>
#include <3dsread.h> 						// The 3dstudio 4 driver
#include <math.h>
#include "DirectDrawEasy.h"
#include "DXMen.h"

class PVEasy:public DDrawEasy
{
	PVWorld *World;
	PVCam *Cam;
	PVLight *Light;

	PVMesh *Mesh1,*Mesh2,*Mesh3,*Switch;
	float az;
	int dir;

public:
	PVEasy();
	~PVEasy();
	void InitPV(void);
	int OnIdle(void);
};


// Here the callback called each time the switch node is being processed
// That's here YOU define which switchpath will be taken according to YOUR rules.
// Here it's a quite lame 'distance' computation beetwenn the viewer and the node
// But it can be anything else, keep in mind that the call back can *act* on the world
// SwitchPath can inherit position/rotation and evrythong else from the switchnode as
// usual.
// Think about it, it's quite great.

PVMesh *PVAPI SwitchCallBack(PVMesh *swnode)
{
	// Here we compute the 'distance' beetween the camera (the viewer) and the switch node
	// We select the according switch path 

	// Here the number of switch paths defined is available in swnode->NbrSwitchItems.
	PVCam *cam=swnode->Owner->Camera;

	// Plug in a real distance computation adapted to your problem
	// and true lods to boost your rendering performance
	float dist=fabs(cam->pos.zf-swnode->Position.zf);
	
	if(dist>1000) 
		return PV_GetSwitchItem(swnode,2);
	else
	if(dist>900) 
		return PV_GetSwitchItem(swnode,1);
	else
	return PV_GetSwitchItem(swnode,0);		
}

///////////////////////////////////////////////////////////////////////////////
PVEasy::PVEasy()
{	
	World=NULL;
	Cam=NULL;
	Light=NULL;
}

PVEasy::~PVEasy()
{
	// Destructor
	PV_KillWorld(World);
	PV_KillCam(Cam);
	PV_KillLight(Light);
}

void PVEasy::InitPV(void)
{
    PVRGBF ambient={0.1,0.1,0.1,0};    // Ambient Light
    PVRGBF em={0,0,0,0};				 // Material's emmissive
	PVRGBF di={1,1,1,1};				 // Material's diffuse
	PVRGBF sp={0,0,0,0};				 // Material's Specular

    PVMaterial *m;

    // Render Mode Setup
    PV_SetClipLimit(0,Width-1,0,Height-1,Pitch);			// Sets rendering window   
	
	PV_SetMode(Depth!=8?PVM_RGB:PVM_PALETIZED8);			// Sets rendering mode (ZBuffer)

	if(!(PV_Mode&PVM_PALETIZED8)) 
	{
		// We are in RGB rendering, sets the RGB masks according to the current device
		PV_SetRGBIndexingMode(GetMaskSize(RedMask),GetMaskSize(GreenMask),GetMaskSize(BlueMask),GetMaskPos(RedMask),GetMaskPos(GreenMask),GetMaskPos(BlueMask),GetMaskSize(AlphaMask));
	}
	else
	{
		// We are on a paletized device, sets a grayscale palette 
		char p[768];

		for(int i=0;i<256;i++)
		{
			p[i*3]=i;
			p[i*3+1]=i;
			p[i*3+2]=i;
		}
		SetPal(p);
	}

	// World setup
	World=PV_CreateWorld();
	if(World==NULL)
	{
		Error("Unable to Create World");
		exit(1);
	}
	if(Depth==8) World->ReservedColors=10;							// the 10 first colors are for windows
	PV_WorldSetAmbientLight(World,ambient);

	// Camera Setup
	Cam=PV_CreateCam("CAMERA");
	if(Cam==NULL)
	{
		Error("Unable to create camera");
		exit(1);
	}
	PV_SetCamFieldOfView(Cam,Width/Height);
	Cam->Height=Height;
    Cam->Width=Width;
	Cam->CenterX=Width/2;
	Cam->CenterY=Height/2;
	World->Camera=Cam;
	Cam->pos.yf=-100;
	Cam->pos.zf=800;

	// Light Setup
	Light=PV_CreateLight(PVL_DIRECTIONAL,"LIGHT");
	if(Light==NULL)
	{
		Error("Unable to create light");
		exit(1);
	}
	PV_AddLight(World,Light);
	PV_SetLightDirection(Light,0,0,-1);
	Light->Color.g=0;

	// Mesh Setup
	if(LoadMeshFrom3DS("../data/cube.3ds",World)!=COOL)
	{
		Error("Unable to load mesh");
		exit(1);
	}	
	Mesh1=PV_UnlinkMesh(World->Objs); // Gets a pointer to the first mesh, and unlink it from the world
	
	if(LoadMeshFrom3DS("../data/cube.3ds",World)!=COOL)
	{
		Error("Unable to load mesh");
		exit(1);
	}
	Mesh2=PV_UnlinkMesh(World->Objs); // Gets a pointer to the first mesh, and unlink it from the world
	
	if(LoadMeshFrom3DS("../data/cube.3ds",World)!=COOL)
	{
		Error("Unable to load mesh");
		exit(1);
	}
	Mesh3=PV_UnlinkMesh(World->Objs); // Gets a pointer to the first mesh, and unlink it from the world

	// But what i'm doing here ??
	// Simple, I create 3 cubes, then I rotate them about 45deg each
	// Then I create a switchnode, add it as child of the root world node
	// Add my 3 mesh cubes as Switch Items, and set a call back for this swicth node
	// The callback will be called each time the switch node is processed with the
	// switch node as argument.
	// The callback must return the number of the switch path choosen (in our case
	// it's just one of our three cubes, but one Switch path can be a complete World tree!)
	// In this example, the callback will switch from one cube to another according
	// to the distance of the switchnode to the viewer. Replace my lovely cubes
	// by mesh LODs and it rocks.
	// Switchable node is a really cool features allowing for many special effects
	// Believe me it's fun :)

	// Rotate the cubes
	PV_MeshSetupMatrix(Mesh2,0,0,45*PI/180);
	PV_MeshSetupMatrix(Mesh3,0,0,75*PI/180);

	// Creates the switch node and add it to the world (no error check)
	// See the Callback above for comments
	Switch=PV_CreateSwitchNode(SwitchCallBack);
	PV_AddMesh(World,Switch);

	// Add switch items
	PV_AddSwitch(Switch,Mesh1);
	PV_AddSwitch(Switch,Mesh2);
	PV_AddSwitch(Switch,Mesh3);
	// PV_AddSwitch() returns an index corresponding to the slot wher the switch path has been
	// inserted, but we don't care in this sample.

	// Now here we have a world wich has a switch node as it's first node, and 3 switch paths
	// each of them corresponding to one cube

	// Let's render and move the camera :)
	
    // Material Setup
    m=PV_CreateMaterial("APE",FLAT|ZBUFFER,TEXTURE_NONE,0);             // Gets a FLAT shaded material, APE is the material of the cube (activate ZBuffer for this material)
	PV_SetMaterialLightInfo(m,em,di,sp,0);							// Sets material light props
	if(Depth==8)
	{
		PV_SetMaterialPureColorsIndex(m,10,245);					// Sets the extent of the used colors for gouraud inside the whole palette
	}
	PV_AddMaterial(World,m);

    // Prepare to render
	if(PV_CompileMeshes(World)!=COOL)
	{
		Error("Unable to compile meshes");
		exit(1);
	}
	if(PV_CompileMaterials(World,NULL,NULL)!=COOL)
	{
		Error("Unable to compile materials");
		exit(1);
	}

	az=0;
	dir=1;

}

int PVEasy::OnIdle(void)
{		
	Fill(0,0,0,Height,Width,0);

	PV_CamAhead(Cam,dir*8);
	az+=dir;

	if(az>30) dir=-1;
	else
	if(az<0) dir=1;

	// The Lock primitives gives access to the DirectDraw surface
	// The surface should be unlocked ASAP!
	PV_BeginFrame();
	PV_RenderWorld(World,Lock());
	PV_EndFrame();

	Unlock();
		
	Flip();

	return TRUE;
}

//////////////////////////////////////////////////////////////

int main(int argc,char **argv)
{
	PVEasy pve;
	DDInfo *ddi;

	InitPVision();

	printf("Panard Vision : Switchable nodes demonstration \n ALT+F4 to quit.");
	printf("\n\nPanard Vision version : %s\nBuild : %s, %s\n",PVISION_VERSION,PVISION_DATE,PVISION_TIME);
	
	// Direct X Initialization
	ddi=DoDXMenu();	
	if(ddi==NULL) return 1;	
	if(pve.SetMode(&ddi->GUID,NULL,ddi->Width,ddi->Height,ddi->Depth,!ddi->Windowed)!=0) return 1;
		
	// Panard Vision Setup
	pve.InitPV();

	// Some nice things
	pve.Run();

	return 0;
}
