// Panard Vision Sample
// (C) 1997-98, Olivier Brunet (bruneto@efrei.fr)

// Demonstrates splines surfaces

// SMKaribou/GMF

#include <stdio.h>
#include <pvision.h>
#include "DirectDrawEasy.h"
#include "DXMen.h"

static float ctrlpoints[4][4][3] = {						// erk!! A global variable in C++ :)
    {{-1.5, -1.5, 4.0}, {-0.5, -1.5, 2.0}, 
    {0.5, -1.5, -1.0}, {1.5, -1.5, 2.0}}, 
    {{-1.5, -0.5, 1.0}, {-0.5, -0.5, 3.0}, 
    {0.5, -0.5, 0.0}, {1.5, -0.5, -1.0}}, 
    {{-1.5, 0.5, 4.0}, {-0.5, 0.5, 0.0}, 
    {0.5, 0.5, 3.0}, {1.5, 0.5, 4.0}}, 
    {{-1.5, 1.5, -2.0}, {-0.5, 1.5, -2.0}, 
    {0.5, 1.5, 0.0}, {1.5, 1.5, -1.0}}
};


class PVEasy:public DDrawEasy
{
	PVCam *Cam;
	PVLight *Light;
	PVSpline2 *Spl;

public:
	PVEasy();
	~PVEasy();
	void InitPV(void);
	int OnIdle(void);
};

///////////////////////////////////////////////////////////////////////////////
PVEasy::PVEasy()
{
	Cam=NULL;
	Light=NULL;
	Spl=NULL;
}

PVEasy::~PVEasy()
{
	// Destructor
	PV_KillCam(Cam);
	PV_KillLight(Light);
	PV_KillSpline2(Spl);
}

void PVEasy::InitPV(void)
{
    PVRGBF ambient={0.1,0.1,0.1,0};    // Ambient Light
    PVRGBF em={0,0,0.3,0};			 // Material's emmissive
	PVRGBF di={1,1,1,1};				 // Material's diffuse
	PVRGBF sp={0,0,0,0};				 // Material's Specular

    PVMaterial *m;

	PVMat3x3 Id={1,0,0,0,1,0,0,0,1};
    PVPoint Pos={0,0,0};
	unsigned lHandle;

    // Render Mode Setup
    PV_SetClipLimit(0,Width-1,0,Height-1,Pitch);			// Sets rendering window   
	
	PV_SetMode((Depth!=8?PVM_RGB:PVM_PALETIZED8)|PVM_ZBUFFER);			// Sets rendering mode 

	if(!(PV_Mode&PVM_PALETIZED8)) 
	{
		// We are in RGB rendering, sets the RGB masks according to the current device
		PV_SetRGBIndexingMode(GetMaskSize(RedMask),GetMaskSize(GreenMask),GetMaskSize(BlueMask),GetMaskPos(RedMask),GetMaskPos(GreenMask),GetMaskPos(BlueMask),GetMaskSize(AlphaMask));
	}
	else
	{
		// We are on a paletized device, sets a grayscale palette 
		char p[768];

		for(int i=0;i<256;i++)
		{
			p[i*3]=i;
			p[i*3+1]=i;
			p[i*3+2]=i;
		}
		SetPal(p);
	}

	// Camera Setup
	Cam=PV_CreateCam("CAMERA");
	if(Cam==NULL)
	{
		Error("Unable to create camera");
		exit(1);
	}
	PV_SetCamFieldOfView(Cam,Width/Height);
	Cam->Height=Height;
    Cam->Width=Width;
	Cam->CenterX=Width/2;
	Cam->CenterY=Height/2;	
	Cam->pos.yf=0;
	Cam->pos.zf=150;		

	// Light Setup
	Light=PV_CreateLight(PVL_DIRECTIONAL,"LIGHT");
	if(Light==NULL)
	{
		Error("Unable to create light");
		exit(1);
	}	
	PV_SetLightDirection(Light,0,0,-1);
	Light->Color.g=0;

    // Material Setup
    m=PV_CreateMaterial("APE",GOURAUD|ZBUFFER,TEXTURE_NONE,0);		// Gets a FLAT shaded material, APE is the material of the cube
	PV_SetMaterialLightInfo(m,em,di,sp,0);							// Sets material light props
	if(Depth==8)
	{
		PV_SetMaterialPureColorsIndex(m,10,245);					// Sets the extent of the used colors for gouraud inside the whole palette
	}
    PV_CompileMaterial(m,NULL,NULL,ambient,0);						// Prepare material for use

	// Spline setup
	Spl=PV_CreateSpline2(4,4,3);									// We use a 4*4 sontrol points with 3 components in each point		
	
	// Setup Control Points
	float *p=(float*)ctrlpoints;
	for(int i=0;i<Spl->UOrder;i++,p+=-Spl->NbrComponent*(Spl->UOrder*Spl->VOrder)+Spl->NbrComponent)
		for(int j=0;j<Spl->VOrder;j++,p+=Spl->UOrder*Spl->NbrComponent)
		{
			memcpy(&Spl->Points[i*Spl->VOrder*Spl->NbrComponent+j*Spl->NbrComponent],p,Spl->NbrComponent*sizeof(float));
		}

	Spl->u1=Spl->v1=0;								// Setup spline's domain
	Spl->u2=Spl->v2=1;
	Spl->CalcNormal=Spl->AutoNormalize=1;			// Ask for surface's normals computation (to perform lighting)

    // Panard Primitive Setup
    pvSetMode(PV_3D);								// 3D drawing    
    pvSetCull(PV_CULL_NONE);						// every faces will be displayed
	pvSetLightingMode(PV_LIGHTING);					// Compute lighting
	pvAddLight(Light,&lHandle);						// But in case we need a light, set it

	pvSetCamera(Cam);
    pvSetModelMatrix(Id);
    pvSetModelPos(Pos);
    pvSetModelPivot(Pos);
	pvSetMaterial(m);
}

int PVEasy::OnIdle(void)
{		
	float du,dv,v1,v2,u;	
	float r1[3],r2[3];
	PVPoint n1,n2;
	
	Fill(0,0,0,Height,Width,0);

	// Draw the beauty
	
	// The Lock primitives gives access to the DirectDraw surface
	// The surface should be unlocked ASAP!
	PV_BeginFrame();

#define NBR_PART_U	15		// Number of partitions in U and V directions
#define NBR_PART_V	15

	du = (Spl->u2-Spl->u1)/(float) NBR_PART_U;
	dv = (Spl->v2-Spl->v1)/(float) NBR_PART_V;
	v1=Spl->v1;	
	v2=v1+dv;	
	for (int j=0;j<NBR_PART_V;j++,v1+=dv,v2+=dv) 
	{
		// I use Triangles strips instead of quads, because the generated surface
		// is not guarenteed to  be coplanar :)		
		pvBegin(PV_TRIANGLES_STRIP,Lock());		
		u=Spl->u1;
		for (int i=0;i<=NBR_PART_U;i++,u+=du) 
		{									
			
			PV_EvalSpline2(Spl,u,v1,r1,&n1);
			PV_EvalSpline2(Spl,u,v2,r2,&n2);

			pvNormal(n1.xf,n1.yf,n1.zf);
			pvVertex(r1[0]*20,r1[1]*20,r1[2]*20);
			pvNormal(n2.xf,n2.yf,n2.zf);
			pvVertex(r2[0]*20,r2[1]*20,r2[2]*20);	
		}
		pvEnd();
		Unlock();
	}
	PV_EndFrame();	
		
	Flip();

	return TRUE;
}

//////////////////////////////////////////////////////////////

int main(int argc,char **argv)
{
	PVEasy pve;
	DDInfo *ddi;

	InitPVision();

	printf("Panard Vision : Demonstrates spline surfaces\n ALT+F4 to quit.");
	printf("\n\nPanard Vision version : %s\nBuild : %s, %s\n",PVISION_VERSION,PVISION_DATE,PVISION_TIME);
	
	// Direct X Initialization
	ddi=DoDXMenu();	
	if(ddi==NULL) return 1;	
	if(pve.SetMode(&ddi->GUID,NULL,ddi->Width,ddi->Height,ddi->Depth,!ddi->Windowed)!=0) return 1;
		
	// Panard Vision Setup
	pve.InitPV();

	// Some nice things
	pve.Run();

	return 0;
}
