// Panard Vision Sample
// (C) 1997-98, Olivier Brunet (bruneto@efrei.fr)

// Demonstrates portals use (VERY simple sample, but a full featured sample is called ... a game)

// SMKaribou/GMF

#include <stdio.h>
#include <pvision.h>
#include <3dsread.h>						// The 3dstudio 4 driver
#include "DirectDrawEasy.h"
#include "DXMen.h"


class PVEasy:public DDrawEasy
{
	PVWorld *World;
	PVCam *Cam;
	PVLight *Light;

    PVMesh *Mesh1,*Mesh2,*Mesh3,*Mesh4,*Portal,*Portal2;
	float ax,ay,az;

public:
	PVEasy();
	~PVEasy();
	void InitPV(void);
	int OnIdle(void);
};

///////////////////////////////////////////////////////////////////////////////
PVEasy::PVEasy()
{
	ax=ay=az=0;
	World=NULL;
	Cam=NULL;
	Light=NULL;
}

PVEasy::~PVEasy()
{
	// Destructor
	PV_KillWorld(World);
	PV_KillCam(Cam);
	PV_KillLight(Light);
}

void PVEasy::InitPV(void)
{
    PVRGBF ambient={0.1,0.1,0.1,0};    // Ambient Light
    PVRGBF em={0,0,0,0};				 // Material's emmissive
	PVRGBF di={1,1,1,1};				 // Material's diffuse
	PVRGBF sp={0,0,0,0};				 // Material's Specular

    PVMaterial *m;

    // Render Mode Setup
    PV_SetClipLimit(0,Width-1,0,Height-1,Pitch);			// Sets rendering window

	PV_SetMode((Depth!=8?PVM_RGB:PVM_PALETIZED8));			// Sets rendering mode

	if(!(PV_Mode&PVM_PALETIZED8))
	{
		// We are in RGB rendering, sets the RGB masks according to the current device
		PV_SetRGBIndexingMode(GetMaskSize(RedMask),GetMaskSize(GreenMask),GetMaskSize(BlueMask),GetMaskPos(RedMask),GetMaskPos(GreenMask),GetMaskPos(BlueMask),GetMaskSize(AlphaMask));
	}
	else
	{
		// We are on a paletized device, sets a grayscale palette
		char p[768];

		for(int i=0;i<256;i++)
		{
			p[i*3]=i;
			p[i*3+1]=i;
			p[i*3+2]=i;
		}
		SetPal(p);
	}

	// World setup
	World=PV_CreateWorld();
	if(World==NULL)
	{
		Error("Unable to Create World");
		exit(1);
	}
	if(Depth==8) World->ReservedColors=10;							// the 10 first colors are for windows
	PV_WorldSetAmbientLight(World,ambient);

	// Camera Setup
	Cam=PV_CreateCam("CAMERA");
	if(Cam==NULL)
	{
		Error("Unable to create camera");
		exit(1);
	}
	PV_SetCamFieldOfView(Cam,Width/Height);
	Cam->Height=Height;
    Cam->Width=Width;
	Cam->CenterX=Width/2;
	Cam->CenterY=Height/2;
	World->Camera=Cam;
	Cam->pos.yf=-100;
	Cam->pos.zf=1000;

	// Light Setup
	Light=PV_CreateLight(PVL_DIRECTIONAL,"LIGHT");
	if(Light==NULL)
	{
		Error("Unable to create light");
		exit(1);
	}
	PV_AddLight(World,Light);
	PV_SetLightDirection(Light,0,0,-1);
	Light->Color.g=0;

	// Mesh Setup
	if(LoadMeshFrom3DS("../data/cube.3ds",World)!=COOL)
	{
		Error("Unable to load mesh");
		exit(1);
	}
	Mesh1=PV_UnlinkMesh(World->Objs);		// Gets a pointer to the first mesh

	if(LoadMeshFrom3DS("../data/cube.3ds",World)!=COOL)
	{
		Error("Unable to load mesh");
		exit(1);
	}
	Mesh3=PV_UnlinkMesh(World->Objs);		// Gets a pointer to the first mesh

    if(LoadMeshFrom3DS("../data/cube.3ds",World)!=COOL)
	{
		Error("Unable to load mesh");
		exit(1);
	}
    Mesh4=PV_UnlinkMesh(World->Objs);       // Gets a pointer to the first mesh

	if(LoadMeshFrom3DS("../data/cube.3ds",World)!=COOL)
	{
		Error("Unable to load mesh");
		exit(1);
	}
	Mesh2=World->Objs;							// Gets a pointer to the first mesh

    // Creates and insert portals
	Portal=PV_CreateMeshPortal();
    Portal2=PV_CreateMeshPortal();
    PV_AddChildMesh(Mesh2,Portal);
    PV_AddChildMesh(Portal,Mesh1);	
    PV_AddChildMesh(Mesh1,Portal2);
    PV_AddChildMesh(Mesh1,Mesh3);
    PV_AddChildMesh(Portal2,Mesh4);

    // Setup Portal Polygons
	Portal->Face[0].NbrVertexes=4;
    Portal->Vertex[0].xf=180;
    Portal->Vertex[0].yf=-250-100;
    Portal->Vertex[0].zf=-160;
    Portal->Vertex[1].xf=180;
    Portal->Vertex[1].yf=-250-100;
    Portal->Vertex[1].zf=+160;
    Portal->Vertex[2].xf=180;
    Portal->Vertex[2].yf=+160-100;
    Portal->Vertex[2].zf=+160;
    Portal->Vertex[3].xf=180;
    Portal->Vertex[3].yf=+160-100;
    Portal->Vertex[3].zf=-160;
    PV_SetupPortal(Portal);

    Portal2->Face[0].NbrVertexes=4;
    Portal2->Vertex[0].xf=110;
    Portal2->Vertex[0].yf=-180-300;
    Portal2->Vertex[0].zf=-140;
    Portal2->Vertex[1].xf=110;
    Portal2->Vertex[1].yf=-180-300;
    Portal2->Vertex[1].zf=+240;
    Portal2->Vertex[2].xf=110;
    Portal2->Vertex[2].yf=+180-300;
    Portal2->Vertex[2].zf=+240;
    Portal2->Vertex[3].xf=110;
    Portal2->Vertex[3].yf=+180-300;
    Portal2->Vertex[3].zf=-140;
    PV_SetupPortal(Portal2);
		
	Mesh1->Flags|=MESH_INHERIT;			// Activates hierchical inheritance	
	PV_MeshSetupPos(Mesh1,300,0,0);		// position of child	
    Mesh4->Flags|=MESH_INHERIT;         // Activates hierchical inheritance
    PV_MeshSetupPos(Mesh4,300,-150,0);	// position of child
    Mesh3->Flags|=MESH_INHERIT;         // Activates hierchical inheritance
	PV_MeshSetupPos(Mesh3,0,300,0);		// position of child    

	// No initial transformations
	PV_MeshSetupMatrix(Mesh1,0,0,0);
    PV_MeshSetupMatrix(Mesh2,0,0,0);
    PV_MeshSetupMatrix(Mesh3,0,0,0);
    PV_MeshSetupMatrix(Mesh4,0,0,0);

	// The world is as follow after these lines:
	//							   			      /-------\
	//										   P2 |       |
	//								P1			| |       |
	//					  /-------\	| /-------\	| |   M4  |
	//					  |       |	| |       |	| |       |
	//					  |       |	| |       |	  |       |
	//					  |   M2  |	| |   M1  |	  \-------/
	//					  |       |	| |       |
	//					  |       |	| |       |
	//					  \-------/ | \-------/
	//				   			      /-------\
	//							      |       |
	//								  |       |
	//								  |   M3  |
	//								  |       |
	//								  |       |
	//								  \-------/
	// What you see on screen is the reult of the clipping of the hierarchical world through
	// the 2 portals. Normally you will not use portals this way, but rather defines portals
	// as being the windows or doors or whatever holes you got in your rooms. This way
	// you can render only what is visible, with no overdraw. Fast and simple.

    // Uncomment the 2 following lines to deactivates Portals and see the world AS IS
	//Portal->UserPipeline=NULL;
    //Portal2->UserPipeline=NULL;
	
    // Material Setup
    m=PV_CreateMaterial("APE",FLAT,TEXTURE_NONE,0);             // Gets a FLAT shaded material, APE is the material of the cube
	PV_SetMaterialLightInfo(m,em,di,sp,0);							// Sets material light props
	if(Depth==8)
	{
		PV_SetMaterialPureColorsIndex(m,10,245);					// Sets the extent of the used colors for gouraud inside the whole palette
	}
	PV_AddMaterial(World,m);

    // Prepare to render
	if(PV_CompileMeshes(World)!=COOL)
	{
		Error("Unable to compile meshes");
		exit(1);
	}
	if(PV_CompileMaterials(World,NULL,NULL)!=COOL)
	{
		Error("Unable to compile materials");
		exit(1);
	}

}

int PVEasy::OnIdle(void)
{
	Fill(0,0,0,Height,Width,0);

	// Animate the beauty
	ay+=PI/500;
	az+=PI/40;
	if(ay>2*PI) ay-=2*PI;
	if(az>2*PI) az-=2*PI;

    PV_MeshSetupMatrix(Mesh1,ay,0,0);
	PV_MeshSetupMatrix(Mesh2,0,ay,0);

	// The Lock primitives gives access to the DirectDraw surface
	// The surface should be unlocked ASAP!
	PV_BeginFrame();
	PV_RenderWorld(World,Lock());
	PV_EndFrame();

	Unlock();

	Flip();

	return TRUE;
}

//////////////////////////////////////////////////////////////

int main(int argc,char **argv)
{
	PVEasy pve;
	DDInfo *ddi;

	InitPVision();

	printf("Panard Vision : Demonstrates simple portals\n ALT+F4 to quit.");
	printf("\n\nPanard Vision version : %s\nBuild : %s, %s\n",PVISION_VERSION,PVISION_DATE,PVISION_TIME);

	// Direct X Initialization
	ddi=DoDXMenu();
	if(ddi==NULL) return 1;
	if(pve.SetMode(&ddi->GUID,NULL,ddi->Width,ddi->Height,ddi->Depth,!ddi->Windowed)!=0) return 1;

	// Panard Vision Setup
	pve.InitPV();

	// Some nice things
	pve.Run();

	return 0;
}
