// Panard Vision Sample
// (C) 1997-98, Olivier Brunet (bruneto@efrei.fr)

// Gouraud shaded triangle using Panard Primitives

// SMKaribou/GMF

#include <stdio.h>
#include <pvision.h>
#include "DirectDrawEasy.h"
#include "DXMen.h"

class PVEasy:public DDrawEasy
{
public:
	void InitPV(void);
	int OnIdle(void);
};

///////////////////////////////////////////////////////////////////////////////

void PVEasy::InitPV(void)
{
    PVRGBF ambient={0.1,0.1,0.1,0};    // Ambient Light
    PVRGBF em={0,0,0,0};				 // Material's emmissive
	PVRGBF di={1,1,1,1};				 // Material's diffuse
	PVRGBF sp={0,0,0,0};				 // Material's Specular

    PVMaterial *m;

    // Render Mode Setup
    PV_SetClipLimit(0,Width-1,0,Height-1,Pitch);			// Sets rendering window   
	
	PV_SetMode(Depth!=8?PVM_RGB:PVM_PALETIZED8);			// Sets rendering mode

	if(!(PV_Mode&PVM_PALETIZED8)) 
	{
		// We are in RGB rendering, sets the RGB masks according to the current device
		PV_SetRGBIndexingMode(GetMaskSize(RedMask),GetMaskSize(GreenMask),GetMaskSize(BlueMask),GetMaskPos(RedMask),GetMaskPos(GreenMask),GetMaskPos(BlueMask),GetMaskSize(AlphaMask));
	}
	else
	{
		// We are on a paletized device, sets a grayscale palette 
		char p[768];

		for(int i=0;i<256;i++)
		{
			p[i*3]=i;
			p[i*3+1]=i;
			p[i*3+2]=i;
		}
		SetPal(p);
	}
	
    // Material Setup
    m=PV_CreateMaterial("SMOOTH MATERIAL",GOURAUD,TEXTURE_NONE,0);	// Gets a GOURAUD shaded maetrial
	PV_SetMaterialLightInfo(m,em,di,sp,0);							// Sets material light props
	if(Depth==8)
	{
		PV_SetMaterialPureColorsIndex(m,10,245);					// Sets the extent of the used colors for gouraud inside the whole palette
	}
    PV_CompileMaterial(m,NULL,NULL,ambient,0);						// Prepare material for use

    // Panard Primitive Setup
    pvSetMode(PV_2D);								// 2.5D drawing
    pvSetMaterial(m);								// Sets the current filling material
    pvSetCull(PV_CULL_NONE);						// every faces will be displayed		
	pvSetAmbientLight(0.1,0.1,0.1,0);
}

int PVEasy::OnIdle(void)
{		
	Fill(0,0,0,Height,Width,0);

	// The Lock primitives gives access to the DirectDraw surface
	// The surface should be unlocked ASAP!
	
	// Draw a triangle
	PV_BeginFrame();
	if(Depth==8)
	{
		pvBegin(PV_TRIANGLES,Lock());
			pvColorIndex(10);
			pvVertex(Width/2,0,1);

			pvColorIndex(127);
			pvVertex(Width/4,Height-1,1);

			pvColorIndex(245);
			pvVertex(Width/2+Width/4,Height-1,1);
		pvEnd();
	}
	else
	{
		pvBegin(PV_TRIANGLES,Lock());
			pvColor(1.0,0,0,0);
			pvVertex(Width/2,0,1);

			pvColor(0,0,1.0,0);
			pvVertex(Width/4,Height-1,1);

			pvColor(0,1.0,0,0);
			pvVertex(Width/2+Width/4,Height-1,1);
		pvEnd();
	}
	Unlock();
	PV_EndFrame();
		
	Flip();

	return TRUE;
}

//////////////////////////////////////////////////////////////

int main(int argc,char **argv)
{
	PVEasy pve;
	DDInfo *ddi;

	InitPVision();

	printf("Panard Vision : Gouraud Shaded triangle using 2D Panard Primitives\n ALT+F4 to quit.");
	printf("\n\nPanard Vision version : %s\nBuild : %s, %s\n",PVISION_VERSION,PVISION_DATE,PVISION_TIME);
	
	// Direct X Initialization
	ddi=DoDXMenu();	
	if(ddi==NULL) return 1;	
	if(pve.SetMode(&ddi->GUID,NULL,ddi->Width,ddi->Height,ddi->Depth,!ddi->Windowed)!=0) return 1;
		
	// Panard Vision Setup
	pve.InitPV();

	// Some nice things
	pve.Run();

	return 0;
}
