// DirectDrawEasy

// Hack to the original Win32 DirectDrawEasy class
// This class is designed to run the unmodified sample from the windows
// sdk. It's awful, and do not emulate all feature of DirectDrawEasy 
// but samples work.

// (C) 1997-98, Olivier Brunet (bruneto@efrei.fr)
//

// SMKaribou/GMF

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "DirectDrawEasy.h"
#include <pvision.h>

DDrawEasy::DDrawEasy()
{
	Pitch=0;
	RedMask=GreenMask=BlueMask=AlphaMask=0;
	Fullscreen=FALSE;
	win=0;
	Ownwindow=FALSE;
	
	display=NULL;
	Cmap=0;
}

DDrawEasy::~DDrawEasy()
{
	UnInit();
}

int DDrawEasy::GetMaskSize(unsigned x)
{ 
	int i=0;
	while((!(x&1))&&(x!=0))
	{
		x>>=1;		
	}

	while(x&1)
	{
		x>>=1;
		i++;
	}
	return i;
}

int DDrawEasy::GetMaskPos(unsigned x)
{ 
	int i=0;
	while((!(x&1))&&(x!=0))
	{
		x>>=1;		
		i++;
	}

	return i;
}

unsigned DDrawEasy::MakeRGBAColor(unsigned char r,unsigned char g,unsigned char b,unsigned char a)
{
	unsigned rs,gs,bs,rp,gp,bp,as,ap,rf,gf,bf,af;

	// Looking for the correct color mask					
	rs=GetMaskSize(RedMask);
	gs=GetMaskSize(GreenMask);
	bs=GetMaskSize(BlueMask);
	as=GetMaskSize(AlphaMask);
	rp=GetMaskPos(RedMask);
	gp=GetMaskPos(GreenMask);
	bp=GetMaskPos(BlueMask);
	ap=GetMaskSize(AlphaMask);

	// Compute colors
	rf=(unsigned)(r*(float)((1<<rs)-1));
	rf<<=rp;
	bf=(unsigned)(b*(float)((1<<bs)-1));
	bf<<=bp;
	gf=(unsigned)(g*(float)((1<<gs)-1));
	gf<<=gp;
	af=(unsigned)(a*(float)((1<<as)-1));
	af<<=ap;
			
	return (rf|gf|bf|af);
}

void DDrawEasy::SetPal(char pal[256*3])
{		
	int i;

    static XColor colors[MAX_COLORS];

    if(Depth!=8) return;

    for (i = 0; i < MAX_COLORS; i++)
    {
        colors[i].red = (((float) (pal[i*3])) / 255) * 65535;
        colors[i].green = (((float) (pal[i*3+1])) / 255) * 65535;
        colors[i].blue = (((float) (pal[i*3+2])) / 255) * 65535;
        colors[i].pixel = Pixels[i];
        colors[i].flags = DoRed | DoGreen | DoBlue;
    }

    XStoreColors(display, Cmap, colors, MAX_COLORS);
}

void DDrawEasy::Flip(void)
{	
	XEvent Event;
	
	if (Shm_Ok)
    {
        XShmPutImage(
                     display, win, gc, XImg,
                     0, 0, 0, 0, Width, Height, TRUE);

        while (1)
        {
            XNextEvent(display, &Event);
            if (Event.type == Completion_Type)
                break;
        }
    }
    else
        XPutImage(
                  display, win, gc, XImg,
                  0, 0, 0, 0, Width, Height);
}

unsigned char *DDrawEasy::Lock(void)
{
	return Bitmap[0];
}

void DDrawEasy::Unlock(void)
{
}

int DDrawEasy::OnIdle(void)
{
	return TRUE;
}

void DDrawEasy::Run(void)
{
	int pending;
	XEvent event;
	char bind[255];
		
	for(;;)
	{
	 pending = XPending(display);
	 while(pending>0)
	 {
		 XNextEvent(display,&event);
		 if(event.type==KeyPress)
		 {
			 XLookupString(&event.xkey,bind,255,NULL,NULL);
			 if(bind[0]==27) return;
		 }
		 pending--;
	 }
	 if(!OnIdle()) return;
	}
}

void DDrawEasy::Error(char *str)
{
	UnInit();
	fprintf(stderr,"Fatal error : %s\n",str);
	exit(1);
}

void DDrawEasy::Allocate_XImage(int Resx,int Resy,int depth)
{
    int i;
    XImg = NULL;
    Bitmap = (PIXEL **) malloc(Resy * sizeof(PIXEL *));

    if (Bitmap == NULL)
    {
        XImg = NULL;
        return;
    }

    Bitmap[0] = (PIXEL *) malloc(Resy * Resx * (depth/8)*sizeof(PIXEL));
    if (Bitmap[0] == NULL)
    {
        free(Bitmap);
        Bitmap = NULL;
        return;
    }

    for (i = 1; i < Resy; ++i)
        Bitmap[i] = Bitmap[i - 1] + Resx*(depth/8);

    XImg = XCreateImage(
                        display,
                        DefaultVisual(display, screen),
                        depth, ZPixmap, 0,
                        &(Bitmap[0][0]),
                        Resx, Resy,
                        32, 0);

    if (XImg == NULL)
    {
        free(Bitmap[0]);
        free(Bitmap);
        Bitmap = NULL;
        return;
    }

    return;
}

int DDrawEasy::Allocate_Shm_XImage(int Resx,int Resy,int depth)
{
    int i;
    XImg = NULL;

    ShmInfo.shmid = shmget(
                           IPC_PRIVATE,
                           Resx * Resy*(depth/8),
                           IPC_CREAT | 0x1ff);

    if (ShmInfo.shmid < 0)
    {
        fprintf(stderr, "Error with shared memory ID...");
        return (FALSE);
    }

    ShmInfo.shmaddr = (char *) shmat(ShmInfo.shmid, NULL, 0);
    if (ShmInfo.shmaddr == (void *) (-1))
    {
        fprintf(stderr, "Error with shared memory segment allocation...");
        return (FALSE);
    }

    Bitmap = (PIXEL **) malloc(Resy * sizeof(PIXEL *));

    if (Bitmap == NULL)
        return (FALSE);

    Bitmap[0] = (PIXEL *) (ShmInfo.shmaddr);

    for (i = 1; i < Resy; ++i)
        Bitmap[i] = Bitmap[i - 1] + Resx*(depth/8);

    XImg = XShmCreateImage(
                           display,
                           DefaultVisual(display, screen),
                           depth, ZPixmap, (unsigned char *) &(Bitmap[0][0]),
                           &(ShmInfo), Resx, Resy);

    if (XImg == NULL)
    {
        free(Bitmap[0]);
        free(Bitmap);
        Bitmap = NULL;
        return (FALSE);
    }

    if (XImg->xoffset != 0)
    {
        fprintf(stderr, "Error with XImage xoffset...");
        goto Failed;
    }

    if (XImg->bytes_per_line != (Resx*(depth/8)))
    {
        fprintf(stderr, "Error with XImg->bytes_per_line");
        goto Failed;
    }

    ShmInfo.readOnly = FALSE;
    if (!XShmAttach(display, &(ShmInfo)))
    {
        fprintf(stderr, "Error with XShmAttach...");
        goto Failed;
    }

    return (TRUE);

Failed:

    XDestroyImage(XImg);
    XImg = NULL;
    free(Bitmap);
    Bitmap = NULL;

    return (FALSE);
}

int DDrawEasy::SetMode(int *lpguid,int *_win,unsigned xres,unsigned yres,unsigned depth,BOOL fullscreen)
{
    char *Name;
    char Me[256];
    XSizeHints Size_Hints;
    XWindowAttributes attrib;
    static XSetWindowAttributes W_Attribs;    // MUST be static
    XGCValues Values;
    
    if (display != NULL) return DDE_ALREADYINITIALIZED;

    if (gethostname(Me, 256) == -1)
    {
      	perror("gethostname");
        return DDE_DDCREATEFAILED;
    }

    Name = XDisplayName(NULL);

    display = XOpenDisplay(Name);
    if (display == NULL)
    {
        fprintf(stderr, "Can't open X connection ( DISPLAY: '%s' ).\n", Name);
        return (TRUE);
    }

    Shm_Ok = TRUE;                               /* A priori guess... */
    if (XShmQueryExtension(display) != TRUE)
    {
        fprintf(stderr, " Shared memory extension not available...\n");
        Shm_Ok = FALSE;
    }
    else if (Name[0] != ':')
        if (strncmp(Me, Name, strlen(Me)) != 0)
        {
            fprintf(stderr, " Can't use shared memory when DISPLAY is redirected...\n");
            Shm_Ok = FALSE;
        }

    if (Shm_Ok)
        fprintf(stderr, "Using shared memory with DISPLAY '%s'...\n", Name);

    screen = DefaultScreen(display);

	win=XCreateWindow(display, RootWindow( display, screen ),
         0, 0, xres,yres, 0, CopyFromParent, InputOutput, CopyFromParent,
         CWBackingStore, &W_Attribs );

    gc = XCreateGC(display, win, 0, &(Values));

                                                /* No resize */

    Size_Hints.width = xres;
    Size_Hints.height = yres;
    Size_Hints.min_width = Size_Hints.width;
    Size_Hints.max_width = Size_Hints.width;
    Size_Hints.min_height = Size_Hints.height;
    Size_Hints.max_height = Size_Hints.height;
    Size_Hints.flags = PSize | PMinSize | PMaxSize;
    XSetWMNormalHints(display, win, &Size_Hints);
    
    W_Attribs.backing_store = Always;
    XChangeWindowAttributes(display, win,
                            CWBackingStore, &W_Attribs);

    XGetWindowAttributes( display, win, &attrib );
    Depth=attrib.depth;
	
    /* Colors */

    /* Try with default CMap */
   if(Depth==8)
   {
      Cmap = DefaultColormap(display, screen);

      if (!XAllocColorCells(display, Cmap,
                        	FALSE, NULL, 0, Pixels, MAX_COLORS))
      {
          // It failed ->Private CMap 

          Cmap = XCreateColormap(
                            	 display,
                            	 RootWindow(display, screen),
                            	 DefaultVisual(display, screen),
                            	 AllocNone);
          XAllocColorCells(display, Cmap,
                           FALSE, NULL, 0, Pixels, MAX_COLORS);
      }

      XSetWindowColormap(display, win, Cmap);
    }

    XStoreName(display, win, "Panard Vision Sample");

    XSelectInput(display, win, MASKS);

    XMapWindow(display, win);
    XFlush(display);


    /* Main bitmap setup */

    if (Shm_Ok)                                  /* Try to allocate segment */
        Shm_Ok = Allocate_Shm_XImage(xres,yres,Depth);

    if (Shm_Ok)                                  /* It worked ... */
        Completion_Type = XShmGetEventBase(display) + ShmCompletion;
    else
        Allocate_XImage(xres,yres,Depth);                       /* Usual fashion... */

    if (XImg == NULL || Bitmap == NULL)
        return (TRUE);
    
    Pitch=xres*(Depth/8);
    Width=xres;
    Height=yres;
    
    // IS it the right way ?
    Visual *vsl=DefaultVisual(display,0);
    
    if(Depth==16) 
    {
    	RedMask=vsl->red_mask;
    	GreenMask=vsl->green_mask;    	
    	BlueMask=vsl->blue_mask;
    	AlphaMask=0;
    }
    if(Depth==24) 
    {
	    RedMask=vsl->red_mask;
    	GreenMask=vsl->green_mask;    	
    	BlueMask=vsl->blue_mask;
    	AlphaMask=0;    
    }
    if(Depth==32) 
    {
	    RedMask=vsl->red_mask;
    	GreenMask=vsl->green_mask;    	
    	BlueMask=vsl->blue_mask;
    	AlphaMask=0xFF000000;
    }

	return 0;
}

void DDrawEasy::Fill(unsigned bufnum,unsigned top,unsigned left,unsigned bottom,unsigned right,unsigned color)
{
	memset (Bitmap[0], 0, Width * Height*(Depth/8));
}

void DDrawEasy::UnInit(void)
{
	XEvent Event;
	
    //PV_EndAccelSupport();
    if (display != NULL)
    {
        while (XPending(display) > 0)
            XNextEvent(display, &Event);

        if (XImg != NULL)
        {
            if (Shm_Ok)
            {
                XShmDetach(display, &(ShmInfo));
                XDestroyImage(XImg);
                shmdt(ShmInfo.shmaddr);
                shmctl(ShmInfo.shmid, IPC_RMID, 0);
            }
            else
                XDestroyImage(XImg);
        }

        XImg = NULL;

        /* Destroy window */

        if (win != (Window) NULL)
        {
            XUnmapWindow(display, win);
            XDestroyWindow(display, win);
            if(Cmap!=0)XFreeColormap(display, Cmap);
            XFreeGC(display, gc);
        }
        win = (Window) NULL;

        XCloseDisplay(display);
    }

    display = NULL;
}

void DDrawEasy::Print(unsigned x,unsigned y,char *str,unsigned r,unsigned g,unsigned b)
{
}
