// Quake I bsp driver for Panard Vision Realtime 3D Engine
// This driver demonstrates user definable pipeline

// This is a sample, many things are not complete especially memory management

// It's definitively not a full featured quake level viewer, take it just as a tutorial

// The BSP traversal code is directly taken from the great and clean Quake Level Viewer:
// QMAP (C) 1997 Sean Barrett

// I've just modified bbox_inside_frustum()&render_node_faces() to better fit with PV


#include "bspfile.h"
#include "pvision.h"
#include "qkread.h"

#define NBR_CLIP_VERTEX     4000			// maybe *a little* overestimated :)

////////////////////////////////////////////////////////////////////////////

static char vis_leaf[MAX_MAP_LEAFS/8+1];
static char vis_node[MAX_MAP_NODES];
static char vis_face[MAX_MAP_FACES/8+1];

static PVTexBasis* BasIndex[MAX_MAP_TEXINFO];
static PVMaterial *MatIndex[MAX_MAP_MIPTEX];

static PVMesh *CurrentMesh;

/////////////////////////////////////////////////////// BSP Pipeline is here

#define is_marked(x)     (vis_face[(x) >> 3] &   (1 << ((x) & 7)))
#define mark_face(x)     (vis_face[(x) >> 3] |=  (1 << ((x) & 7)))
#define unmark_face(x)   (vis_face[(x) >> 3] &= ~(1 << ((x) & 7)))

static int bbox_inside_frustum(short *mins, short *maxs)
{
   unsigned i=0xFFFFFFFF;
   PVPoint a;

   a.xf=mins[0];
   a.yf=-mins[2];
   a.zf=-mins[1];
   i&=PV_GetFrustumFlags(&a);

   a.xf=maxs[0];
   a.yf=-mins[2];
   a.zf=-mins[1];
   i&=PV_GetFrustumFlags(&a);

   a.xf=maxs[0];
   a.yf=-maxs[2];
   a.zf=-mins[1];
   i&=PV_GetFrustumFlags(&a);

   a.xf=mins[0];
   a.yf=-maxs[2];
   a.zf=-mins[1];
   i&=PV_GetFrustumFlags(&a);

   a.xf=mins[0];
   a.yf=-mins[2];
   a.zf=-maxs[1];
   i&=PV_GetFrustumFlags(&a);

   a.xf=maxs[0];
   a.yf=-mins[2];
   a.zf=-maxs[1];
   i&=PV_GetFrustumFlags(&a);

   a.xf=maxs[0];
   a.yf=-maxs[2];
   a.zf=-maxs[1];
   i&=PV_GetFrustumFlags(&a);

   a.xf=mins[0];
   a.yf=-maxs[2];
   a.zf=-maxs[1];
   i&=PV_GetFrustumFlags(&a);

   if(i) return 0; else return 1;
}

static int node_in_frustrum(dnode_t *node)
{
    return bbox_inside_frustum(node->mins, node->maxs);
}

static int leaf_in_frustrum(dleaf_t *node)
{
   return bbox_inside_frustum(node->mins, node->maxs);
}

static int point_plane_test(PVPoint *loc, dplane_t *plane)
{
   return plane->normal[0] * loc->xf + -plane->normal[2] * loc->yf
        + -plane->normal[1]*loc->zf < plane->dist;
}

static int find_leaf(PVPoint *loc)
{
   int n = dmodels[0].headnode[0];
   while (n >= 0) {
      dnode_t *node = &dnodes[n];

      n = node->children[point_plane_test(loc, &dplanes[node->planenum])];
   }
   return ~n;
}

static void mark_leaf_faces(int leaf)
{
   int n = dleafs[leaf].nummarksurfaces;
   int ms = dleafs[leaf].firstmarksurface;
   int i;

   for (i=0; i < n; ++i) {
      int s = dmarksurfaces[ms+i];
      if (!is_marked(s)) {
         mark_face(s);
      }
   }
}

static int visit_visible_leaves(PVPoint *cam_loc)
{
   int n, v, i;

   memset(vis_leaf, 0, sizeof(vis_leaf));

   n = find_leaf(cam_loc);

   if (n == 0 || dleafs[n].visofs < 0)
      return 0;

   v = dleafs[n].visofs;
   for (i = 1; i < numleafs; ) {
      if (dvisdata[v] == 0) {
         i += 8 * dvisdata[v+1];    // skip some leaves
         v+=2;
      } else {
         int j;
         for (j = 0; j <8; j++, i++)
            if (dvisdata[v] & (1<<j) )
               vis_leaf[i>>3] |= (1 << (i & 7));
         ++v;
      }
   }
   return 1;
}

static void render_node_faces(int node, int side)
{
   int i,n,f;
   n = dnodes[node].numfaces;
   f = dnodes[node].firstface;
   for (i=0; i < n; ++i) {
      if (is_marked(f)) {
         if (dfaces[f].side == side)
         {
            // Emitting face to Panard Vision
            if(PV_ClipFaceToFrustum(&CurrentMesh->Face[f]))
            {
                CurrentMesh->Visible[CurrentMesh->NbrVisibles++]=&CurrentMesh->Face[f];
            }

         }
         unmark_face(f);
      }
      ++f;
   }
}

// recursively determine which nodes need exploring (so we
// don't look for polygons on _every_ node in the level)
static int bsp_find_visible_nodes(int node)
{
   if (node >= 0) {
      vis_node[node] = !!(bsp_find_visible_nodes(dnodes[node].children[0])
                       | bsp_find_visible_nodes(dnodes[node].children[1]));
      return vis_node[node];
   }
   else {
      node = ~node;
      return (vis_leaf[node >> 3] & (1 << (node & 7)));
   }
}

static void bsp_explore_node(int node)
{
   if (node < 0) {
      node = ~node;
      if (vis_leaf[node >> 3] & (1 << (node & 7)))
         if (leaf_in_frustrum(&dleafs[node]))
            mark_leaf_faces(node);
      return;
   }

   if (vis_node[node]) {
      if (!node_in_frustrum(&dnodes[node]))
         vis_node[node] = 0;
      else {
         bsp_explore_node(dnodes[node].children[0]);
         bsp_explore_node(dnodes[node].children[1]);
      }
   }
}

static void bsp_visit_visible_leaves(PVPoint *cam_loc)
{
   bsp_find_visible_nodes((int) dmodels[0].headnode[0]);
   bsp_explore_node((int) dmodels[0].headnode[0]);
}

static void bsp_render_node(int node,PVPoint *loc)
{
    if (node >= 0 && vis_node[node]) {
       if (point_plane_test(loc, &dplanes[dnodes[node].planenum])) {
          bsp_render_node(dnodes[node].children[0],loc);
          render_node_faces(node, 1);
          bsp_render_node(dnodes[node].children[1],loc);
       } else {
          bsp_render_node(dnodes[node].children[1],loc);
          render_node_faces(node, 0);
          bsp_render_node(dnodes[node].children[0],loc);
       }
   }
}

static void bsp_render_world(PVPoint *cam_loc)
{
   bsp_render_node((int) dmodels[0].headnode[0],cam_loc);
}

static int PVAPI BSPPipe(PVMesh *m)
{
   PVWorld *w=m->Owner;
	
   CurrentMesh=m;

   if (!visit_visible_leaves(&w->Camera->pos)) {
      memset(vis_leaf, 255, sizeof(vis_leaf));
   }

   bsp_visit_visible_leaves(&w->Camera->pos);
   bsp_render_world(&w->Camera->pos);
   return MESH_FRUSTUM_CLIPPED;								// Tells PV to finsih clipping
}

////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////  Here is the driver code
////////////////////////////////////////////////////////////////////////////

static int CreateBigMeshWithPolys(PVWorld *w)
{
    unsigned i,j,cf;
    int edge;
    PVMesh *m;
    unsigned Poly[32]; // up to 32 vertices per poly

	m=PV_SimpleCreateMesh(numfaces,numvertexes,2000,NBR_CLIP_VERTEX);
    if(m==NULL) return NO_MEMORY;
    m->Flags|=MESH_NOSORT;

    m->Name=strdup("Quake world");    

    // Init Vertex Array
    for(i=0;i<numvertexes;i++)
    {
        m->Vertex[i].xf=dvertexes[i].point[0];
        m->Vertex[i].yf=-dvertexes[i].point[2];
        m->Vertex[i].zf=-dvertexes[i].point[1];
        m->Vertex[i].Flags=0;
		m->Pivot.xf+=dvertexes[i].point[0];
        m->Pivot.yf+=-dvertexes[i].point[2];
        m->Pivot.zf+=-dvertexes[i].point[1];
    }
	m->Pivot.xf/=numvertexes;
	m->Pivot.yf/=numvertexes;
	m->Pivot.zf/=numvertexes;

    // Fill Face array
    for(i=0;i<numfaces;i++)
    {
        cf=0;
        for(j=dfaces[i].firstedge;j<dfaces[i].firstedge+dfaces[i].numedges;j++)
        {
            edge=dsurfedges[j];
            if (edge<0)
            {
                Poly[cf++]=dedges[-edge].v[1];
		    }
            else
            {
                Poly[cf++]=dedges[edge].v[0];
			}
            if(cf==MAX_VERTICES_PER_POLY) break;

        }

        // Invert normal
        for(j=0;j<cf;j++) m->Face[i].V[cf-j-1]=Poly[j];

		m->Face[i].NbrVertexes=dfaces[i].numedges;
        m->Face[i].Flags|=TEXTURE_BASIS;
        m->Face[i].Material=NULL;
        m->Face[i].MaterialInfo=MatIndex[texinfo[dfaces[i].texinfo].miptex];
        PV_AttachTextureBasis(&m->Face[i],BasIndex[dfaces[i].texinfo]);
        m->Face[i].Father=m;

		// Resize texture basis if needed
		if(m->Face[i].MaterialInfo!=NULL)
		if(m->Face[i].MaterialInfo->UserData)
		{
			float f;
			miptex_t *mip;
			dmiptexlump_t *mtl = (dmiptexlump_t *) dtexdata;
			unsigned h;

			mip = (miptex_t *) (dtexdata + mtl->dataofs[texinfo[dfaces[i].texinfo].miptex]);
			f=(float)m->Face[i].MaterialInfo->Tex[0].Width/(float)mip->width;
			for(h=0;h<4;h++) m->Face[i].TexBasis->SBasis[h]*=f;

			f=(float)m->Face[i].MaterialInfo->Tex[0].Height/(float)mip->height;
			for(h=0;h<4;h++) m->Face[i].TexBasis->TBasis[h]*=f;
		}

		// Lightmaps stuff
        PV_AttachLightMap(&m->Face[i],PV_CreateLightMapInfo());
        if(m->Face[i].LightMap!=NULL)
        {
            m->Face[i].LightMap->Sampling=4;        // Quake's lightmaps are 16 times undersampled
            m->Face[i].LightMap->NbrLightMaps=1;
            m->Face[i].LightMap->CurrentLightMap=0;
            m->Face[i].LightMap->Maps[0]=&dlightdata[dfaces[i].lightofs];
            m->Face[i].LightMap->Flags|=LIGHTMAP_MONO;
        }

        // Here we got a face that as two many edges
		// We should split it into two or more faces
		// But that's pretty rare, and I'm lazzy :)
        if(m->Face[i].NbrVertexes>MAX_VERTICES_PER_POLY)
        {
            printf("WARNING: Too many edges, %u for face %u, forgetting some...\n",m->Face[i].NbrVertexes,i);
        	m->Face[i].NbrVertexes=MAX_VERTICES_PER_POLY;		// Keep number of edges acceptable
        }
    }

    m->UserPipeline=BSPPipe;			// Disable default PV's render pipe, hence there is no need to compute normals or bounding boxes
    m->Flags|=MESH_NOLIGHTING;          // Forget the lighting stage

	PV_AddMesh(w,m);

    return COOL;
}

static PVRGB *ZePal;
static UPVD8 ColorMap[256*256];
static void LoadPalette(char *name)
{
    FILE *f;
    unsigned i;

    ZePal=(PVRGB*)malloc(256*sizeof(PVRGB));
	if(ZePal==NULL) 
	{
		printf("Out of memory to load palette\n");
		exit(1);
	}
	
	if((f=fopen(name,"rb"))==NULL) return;

    fread(ZePal,1,768,f);
    fclose(f);

    for(i=0;i<256;i++)
    {
        ZePal[i].r>>=2;
        ZePal[i].g>>=2;
        ZePal[i].b>>=2;
    }
}

static void MakeColorMap(void)
{
    unsigned i,j;
    PVRGB col;
    float ratio;

    if (PV_Mode&PVM_RGB) return;
    printf("Generating colormap (for 256 colors rendering)...\n");
    for(j=0;j<256;j++)
    {
        ratio=(float)j*4/255.0;
        for(i=0;i<256;i++)
        {
            col.r=(float)ZePal[i].r*ratio;
            col.g=(float)ZePal[i].g*ratio;
            col.b=(float)ZePal[i].b*ratio;

            ColorMap[i*256+j]=PV_LookClosestColor(ZePal,col,0);
        }
    }
}

static void InitMatIndex(void)
{
    unsigned i;
    float bass[4],bast[4],t;

    memset(BasIndex,0,sizeof(BasIndex));

    for(i=0;i<numtexinfo;i++)
    {
        memcpy(bass,texinfo[i].vecs[0],sizeof(bass));
        memcpy(bast,texinfo[i].vecs[1],sizeof(bast));
        t=bass[2];
        bass[2]=-bass[1];
        bass[1]=-t;
        t=bast[2];
        bast[2]=-bast[1];
        bast[1]=-t;

        BasIndex[i]=PV_CreateTextureBasis(bass,bast);
    }
}

static int CreateMaterials(PVWorld *w)
{
    unsigned i,j;
    PVMaterial *m;
    dmiptexlump_t *mtl = (dmiptexlump_t *) dtexdata;
    miptex_t *mip;
	PVTexture *nmip;

	printf("Setting up textures ...\n");
    for(i=0;i<mtl->nummiptex;i++)
    {
        mip = (miptex_t *) (dtexdata + mtl->dataofs[i]);

        // Some materials should not have lightmaps
        if((mip->name[0]=='*')||((mip->name[0]=='s')&&(mip->name[1]=='k')&&(mip->name[2]=='y')))
            m=PV_CreateMaterial("",NOTHING|MAPPING|PERSPECTIVE|AUTOMATIC_BILINEAR,TEXTURE_PALETIZED8|TEXTURE_MIPMAP|TEXTURE_BILINEAR|TEXTURE_MANUALMIPMAPS,4);
        else
            m=PV_CreateMaterial("",LIGHTMAP|MAPPING|PERSPECTIVE|AUTOMATIC_BILINEAR,TEXTURE_PALETIZED8|TEXTURE_MIPMAP|TEXTURE_BILINEAR|TEXTURE_MANUALMIPMAPS,4);

		if(m==NULL) return NO_MEMORY;

		for(j=0;j<4;j++)
		{
			// Make all textures with size power of 2 (by reducing them if needed)
			nmip=PV_MipResample((UPVD8*)mip+mip->offsets[j],mip->width>>j,mip->height>>j, 0,TEXTURE_PALETIZED8,ZePal,0);
			if(nmip==NULL) return NO_MEMORY;

			// Setup memory managment
			m->TextureFlags|=TEXTURE_TEX_DONT_FREE;

			// Set some form of resize flag for resizing texture basis vectors	
			if((mip->width!=nmip->Width)||(mip->height!=nmip->Height)) m->UserData=1;

			if(j==0)
				PV_SetMaterialTexture(m,nmip->Width,nmip->Height,nmip->Texture,ZePal);
			else
				PV_SetMaterialMipMap(m,j,nmip->Texture);		
		}

		// Setup the colormap table in case of paletized rendering or RGB16 rendering
		m->Type|=COLORTABLE_DONT_FREE;
		m->PaletteTranscodeTable=ColorMap;			

		// Hint for hardware
//		m->Hint.Quality=PHQ_LOW;    // Quake 1 texture are ugly :)

        MatIndex[i]=m;
               
        PV_AddMaterial(w,m);
    }

    return COOL;
}

int PVAPI LoadMeshesFromQuake(char *name,PVWorld *Wor)
{
    int hr;
	char *l,*stopstring;
	
	LoadBSPFile1(name);
	LoadPalette("palette.lmp");
	PV_GammaCorrectPal(ZePal,1.9);
    MakeColorMap();

    printf("\nQuake level MiniStats:\n");
    printf("=====================\n");
    printf("Nbr Faces %u.\n",numfaces);
    printf("Nbr Vertexes %u.\n",numvertexes);
    printf("Nbr SurfEdge %u.\n",numsurfedges);
    printf("Nbr textures %u.\n",((dmiptexlump_t *) dtexdata)->nummiptex);
    printf("Texture size %u.\n",texdatasize);
    printf("Lightmap size %u.\n",lightdatasize);
    printf("VIS size %u.\n",visdatasize);
    printf("\n");

    InitMatIndex();
    if((hr=CreateMaterials(Wor))!=COOL) return hr;

    PV_SetPerspectiveMipBias(2.0); // Agressive MipMapping !

    Wor->Global256Palette=ZePal;

	// Setup camera at player starting PVPoint
	l=strstr(dentdata,"info_player_start");
	l+=29;
	Wor->Camera->pos.xf=strtod(l,&stopstring);
	l=++stopstring;
	Wor->Camera->pos.zf=strtod(l,&stopstring);
	l=++stopstring;
	Wor->Camera->pos.yf=strtod(l,&stopstring);
	Wor->Camera->pos.zf=-Wor->Camera->pos.zf;
	Wor->Camera->pos.yf=-Wor->Camera->pos.yf;

    return CreateBigMeshWithPolys(Wor);
}
