// Panard-Vision
// 3D real time engine
// (C) 1997-98, Olivier Brunet
//
// Utilities library
//
// Before using this library consult the LICENSE file


#ifndef __PVUT_H__
#define __PVUT_H__

#include "pvision.h"

// This will turn verbose mode on (console apps only)
#define __PVUT_VERBOSE__

// Additional infos read by LoadMaterialsDefinitions()
typedef struct _pvuMatInfo
{
	float SPEED;
	float STEP;
	unsigned CACHESIZE;
} pvuMatInfo;

#ifdef __cplusplus
extern "C" {
#endif

PVEXPORT int PVAPI pvuLoadJpeg(char * filename,PVMaterial *m);
PVEXPORT int PVAPI pvuLoadRaw(char *na,PVMaterial *mat);
PVEXPORT int PVAPI pvuLoadBump(char *na,PVMaterial *mat);
PVEXPORT int PVAPI pvuLoadMaterialsDefinitions(PVWorld *zeworld,char *s,pvuMatInfo *matinfo);

PVEXPORT int PVAPI pvuSaveCompiledMaterial(PVWorld *Wor,char *matname,char *filename);
PVEXPORT int PVAPI pvuLoadCompiledMaterial(PVWorld *w,char *matname,char *filename);

PVEXPORT char *PVAPI pvuTranslateError(int e);

#ifdef __cplusplus
}
#endif

// pvut specific error codes
#define BAD_FILE_FORMAT		1000

#endif
