// Panard-Vision
// 3D real time engine
// (C) 1997-98, Olivier Brunet
//
// Helpers macros
//
// Before using this library consult the LICENSE file

///////////////////////////////////////////////////////// Vector helpers macros
// Addition : a=b+c
#define VpV(a,b,c) \
	(a)->xf=(b)->xf+(c)->xf; \
	(a)->yf=(b)->yf+(c)->yf; \
	(a)->zf=(b)->zf+(c)->zf; 

// Substraction : a=b-c
#define VmV(a,b,c) \
	(a)->xf=(b)->xf-(c)->xf; \
	(a)->yf=(b)->yf-(c)->yf; \
	(a)->zf=(b)->zf-(c)->zf; 

// Cross product : a=bxc
#define VxV(a,b,c) \
	(a)->xf=(b)->yf*(c)->zf-(b)->zf*(c)->yf; \
	(a)->yf=(b)->zf*(c)->xf-(b)->xf*(c)->zf; \
	(a)->zf=(b)->xf*(c)->yf-(b)->yf*(c)->xf; 

// Vector dot product : =a.b
#define VdotV(a,b) \
	 ((a)->xf*(b)->xf + (a)->yf*(b)->yf + (a)->zf*(b)->zf)

// Euclidian length
#define Vlen(a) \
	(sqrt((a)->xf*(a)->xf+(a)->yf*(a)->yf+(a)->zf*(a)->zf))

// Scale a vector
#define Vscale(a,s) \
	(a)->xf*=s; \
	(a)->yf*=s; \
	(a)->zf*=s; 

// Normalize a vector
#define Vnorm(a) \
	{ \
	double l=1/Vlen(a); \
	(a)->xf*=l;	\
	(a)->yf*=l;	\
	(a)->zf*=l;	\
	}

////////////////////////////////////////////////////////// Matrix helpers macros
// Matrix mul : a=b*c
#define MxM(a,b,c) \
  a[0][0] = (b[0][0] * c[0][0] + b[0][1] * c[1][0] +b[0][2] * c[2][0]); \
  a[1][0] = (b[1][0] * c[0][0] + b[1][1] * c[1][0] +b[1][2] * c[2][0]); \
  a[2][0] = (b[2][0] * c[0][0] + b[2][1] * c[1][0] +b[2][2] * c[2][0]); \
  a[0][1] = (b[0][0] * c[0][1] + b[0][1] * c[1][1] +b[0][2] * c[2][1]); \
  a[1][1] = (b[1][0] * c[0][1] + b[1][1] * c[1][1] +b[1][2] * c[2][1]); \
  a[2][1] = (b[2][0] * c[0][1] + b[2][1] * c[1][1] +b[2][2] * c[2][1]); \
  a[0][2] = (b[0][0] * c[0][2] + b[0][1] * c[1][2] +b[0][2] * c[2][2]); \
  a[1][2] = (b[1][0] * c[0][2] + b[1][1] * c[1][2] +b[1][2] * c[2][2]); \
  a[2][2] = (b[2][0] * c[0][2] + b[2][1] * c[1][2] +b[2][2] * c[2][2]); 

// TMatrix mul : a=bT*c
#define MTxM(a,b,c) \
  a[0][0] = (b[0][0] * c[0][0] + b[1][0] * c[1][0] +b[2][0] * c[2][0]); \
  a[1][0] = (b[0][1] * c[0][0] + b[1][1] * c[1][0] +b[2][1] * c[2][0]); \
  a[2][0] = (b[0][2] * c[0][0] + b[1][2] * c[1][0] +b[2][2] * c[2][0]); \
  a[0][1] = (b[0][0] * c[0][1] + b[1][0] * c[1][1] +b[2][0] * c[2][1]); \
  a[1][1] = (b[0][1] * c[0][1] + b[1][1] * c[1][1] +b[2][1] * c[2][1]); \
  a[2][1] = (b[0][2] * c[0][1] + b[1][2] * c[1][1] +b[2][2] * c[2][1]); \
  a[0][2] = (b[0][0] * c[0][2] + b[1][0] * c[1][2] +b[2][0] * c[2][2]); \
  a[1][2] = (b[0][1] * c[0][2] + b[1][1] * c[1][2] +b[2][1] * c[2][2]); \
  a[2][2] = (b[0][2] * c[0][2] + b[1][2] * c[1][2] +b[2][2] * c[2][2]); 

// Matrix mul : a=b*cT
#define MxMT(a,b,c) \
  a[0][0] = (b[0][0] * c[0][0] + b[0][1] * c[0][1] +b[0][2] * c[0][2]); \
  a[1][0] = (b[1][0] * c[0][0] + b[1][1] * c[0][1] +b[1][2] * c[0][2]); \
  a[2][0] = (b[2][0] * c[0][0] + b[2][1] * c[0][1] +b[2][2] * c[0][2]); \
  a[0][1] = (b[0][0] * c[1][0] + b[0][1] * c[1][1] +b[0][2] * c[1][2]); \
  a[1][1] = (b[1][0] * c[1][0] + b[1][1] * c[1][1] +b[1][2] * c[1][2]); \
  a[2][1] = (b[2][0] * c[1][0] + b[2][1] * c[1][1] +b[2][2] * c[1][2]); \
  a[0][2] = (b[0][0] * c[2][0] + b[0][1] * c[2][1] +b[0][2] * c[2][2]); \
  a[1][2] = (b[1][0] * c[2][0] + b[1][1] * c[2][1] +b[1][2] * c[2][2]); \
  a[2][2] = (b[2][0] * c[2][0] + b[2][1] * c[2][1] +b[2][2] * c[2][2]); 

// Sets matrix to identity
#define Mid(a) \
	memset(a,0,sizeof(Mat3x3)); \
	a[0][0]=a[1][1]=a[2][2]=1.0;

///////////////////////////////////////////////////////// Vector/Matrix helpers macros
// Matrix/Point multiplication : a=bT*c
#define MxV(a,b,c) \
	(a)->xf = ((b)[0][0] * (c)->xf +  (b)[0][1] * (c)->yf +   (b)[0][2] * (c)->zf); \
	(a)->yf = ((b)[1][0] * (c)->xf +  (b)[1][1] * (c)->yf +   (b)[1][2] * (c)->zf); \
	(a)->zf = ((b)[2][0] * (c)->xf +  (b)[2][1] * (c)->yf +   (b)[2][2] * (c)->zf); 

// TMatrix/Point multiplication : a=bT*c
#define MTxV(a,b,c) \
	(a)->xf = ((b)[0][0] * (c)->xf +  (b)[1][0] * (c)->yf +   (b)[2][0] * (c)->zf); \
	(a)->yf = ((b)[0][1] * (c)->xf +  (b)[1][1] * (c)->yf +   (b)[2][1] * (c)->zf); \
	(a)->zf = ((b)[0][2] * (c)->xf +  (b)[1][2] * (c)->yf +   (b)[2][2] * (c)->zf); 



