// Panard-Vision
// 3D real time engine
// (C) 1997-98, Olivier Brunet
//
// Panard-Motion
// Simple Hierarchical Animation library for Panard Vision
//
// Before using this library consult the LICENSE file

#ifndef __PMOTION_H__
#define __PMOTION_H__
#include "pvision.h"

#ifdef __cplusplus
extern "C" {
#endif

PVEXPORT char *PMOTION_DATE;
PVEXPORT char *PMOTION_TIME;
PVEXPORT char *PMOTION_VERSION;

typedef enum _PMOBJTYPE {UNKNOW=0,LIGHT_POS,LIGHT_TARGET,CAM_POS,CAM_TARGET,MESH} PMObjType;

#define TRACK_REPEAT    1
#define TRACK_LOOP      2

typedef struct _PMSpline
{
    float easeto,easefrom;
    float bias,cont,tens;
    PVQuat ds,dd;
    PVQuat angleaxis;
} PMSpline;

typedef struct _PMRKey
{
    float Time;
    PVQuat q;
    PMSpline SplineParms;
}PMRKey;

typedef struct _PMPKey
{
    float Time;
    PVPoint Pos;
    PMSpline SplineParms;
}PMPKey;

typedef struct _PMRollKey
{
    float Time;
    float Roll;
    PMSpline SplineParms;
}PMRollKey;

typedef struct _PMHideKey
{
    float Time;
    char Visible;
}PMHideKey;

typedef struct _PosKeys
{
    unsigned NbKeys;
    PVFLAGS Flags;
    PMPKey *Keys;
}PosKeys;

typedef struct _RotKeys
{
    unsigned NbKeys;
    PVFLAGS Flags;
    PMRKey *Keys;
}RotKeys;

typedef struct _RollKeys
{
    unsigned NbKeys;
    PVFLAGS Flags;
    PMRollKey *Keys;
}RollKeys;

typedef struct _HideKeys
{
    unsigned NbKeys;
    PVFLAGS Flags;
    PMHideKey *Keys;
}HideKeys;

typedef struct _PMNode
{
    PVFLAGS Flags;
    PMObjType Type;
    int ID;
    void *Object;

    PVPoint   Pivot;
    PosKeys Pos;
    RotKeys Rot;
    PosKeys Scale;
    RollKeys Roll;
    HideKeys Hide;

    struct _PMNode *Child,*Next,*Father;
} PMNode;

typedef struct _PMotion
{
    float CurrentTime,MaxTime;
    PMNode *RootObj;
} PMotion;


PVEXPORT PMotion * PVAPI PM_CreateTree(void);
PVEXPORT void PVAPI PM_KillTree(PMotion *m);
PVEXPORT void PVAPI PM_SetCurrentTime(PMotion *m,float t);

/////////////////////////////////////////////////

PVEXPORT PMNode *  PVAPI PM_CreateNode(int ID);
PVEXPORT void PVAPI PM_KillNode(PMNode *o);
PVEXPORT void PVAPI PM_AddChild(PMNode *father,PMNode *newnode);
PVEXPORT PMNode * PVAPI PM_GetNodePtrByID(PMNode *m,int id);

PVEXPORT void PVAPI PM_ComputeCurrentTime(PMotion *m);

#ifdef __cplusplus
}
#endif

///////////////////////////// Error codes
#define OBJ_ID_NOT_FOUND        50

#endif
