
// 3DS2DEF

// Def Skeleton generator for the Panard Vision 3D Engine

// May be handy for generating a first pass .def


#define debug(x) //x

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <malloc.h>
#include <ctype.h>
#include "indian.inc"

typedef unsigned char  byte;
typedef unsigned short word;
typedef unsigned long  dword;

FILE *deffile;
int Mapped=0,BumpMapped=0;

typedef struct {
    word    id;
    dword   len;
} TChunkHeader, *PChunkHeader;

enum {
    CHUNK_M3D_VERSION = 0x0002,
    CHUNK_MESH_VERSION = 0x3D3E,
    CHUNK_RGBF      = 0x0010,
    CHUNK_RGBB      = 0x0011,
//    CHUNK_RBGB2     = 0x0012,       // ?? NOT HLS.

    CHUNK_MAIN      = 0x4D4D,
        CHUNK_OBJMESH   = 0x3D3D,
            CHUNK_BKGCOLOR  = 0x1200,
            CHUNK_AMBCOLOR  = 0x2100,
            CHUNK_OBJBLOCK  = 0x4000,
            CHUNK_OBJHIDDEN = 0x4010,
                CHUNK_TRIMESH   = 0x4100,
                    CHUNK_VERTLIST  = 0x4110,
                    CHUNK_FACELIST  = 0x4120,
                    CHUNK_FACEMAT   = 0x4130,
                    CHUNK_MAPLIST   = 0x4140,
                    CHUNK_SMOOLIST  = 0x4150,
                    CHUNK_TRMATRIX  = 0x4160,
                CHUNK_LIGHT     = 0x4600,
                    CHUNK_SPOTLIGHT = 0x4610,
                CHUNK_CAMERA    = 0x4700,
        CHUNK_MATERIAL  = 0xAFFF,
            CHUNK_MATNAME   = 0xA000,
            CHUNK_AMBIENT   = 0xA010,
            CHUNK_DIFFUSE   = 0xA020,
            CHUNK_SPECULAR  = 0xA030,
            CHUNK_TEXTURE   = 0xA200,
            CHUNK_BUMPMAP   = 0xA230,
            CHUNK_MAPFILE   = 0xA300,
        CHUNK_KEYFRAMER = 0xB000,
            CHUNK_ambient_TAG = 0xB001,
            CHUNK_OBJECT_TAG  = 0xB002,
            CHUNK_CAMERA_TAG = 0xB003,
            CHUNK_TARGET_TAG  = 0xB004,
            CHUNK_LIGHT_TAG   = 0xB005,
            CHUNK_L_TARGET_TAG = 0xB006,
            CHUNK_SPOTLIGHT_TAG=0xB007,
            CHUNK_FRAMES    = 0xB008,
            CHUNK_KFCURTIME = 0xB009,
            CHUNK_KFHDR     = 0xB00A,
            CHUNK_NODE_HDR  = 0xB010,
            CHUNK_INSTANCE_NAME = 0xB011,
            CHUNK_PRESCALE = 0xB012,
            CHUNK_PIVOT =0xB013,
            CHUNK_BOUNDBOX = 0xB014,
            CHUNK_MORPH_SMOOTH = 0xB015,
            CHUNK_POS_TRACK_TAG = 0xB020,
            CHUNK_ROT_TRACK_TAG = 0xB021,
            CHUNK_SCL_TRACK_TAG = 0xB022,
            CHUNK_FOV_TRACK_TAG = 0xB023,
            CHUNK_ROLL_TRACK_TAG = 0xB024,
            CHUNK_NODE_ID   = 0xB030,

};

/////////////////////////////////////////////////////////////////////////
// Lecture 3ds
/////////////////////////////////////////////////////////////////////////

static void FinishMat(void)
{
    static init=0;

    if(!init)
    {
        init=1;
        return;
    }

    if(!Mapped)
    {
        fprintf(deffile,"\tTEXTURE_NONE\n\tnull\n");
    }

    if(!BumpMapped)
    {
        fprintf(deffile,"\tnull\n");
    }
    Mapped=0;
    BumpMapped=0;
}

// Util pour tout le monde
static void ReadASCIIZ(FILE *f,char name[255])
{
   char c[2];

   c[1]='\0';
   name[0]='\0';

     // Read ASCIIZ object name
   while ( (c[0] = fgetc(f)) != EOF && c[0] != '\0')
   {
       c[0]=toupper(c[0]);
       strcat(name,c);
   }
}

// Forward declaration.
static int ChunkReader(FILE *f, long p);

static int SkipReader(FILE *f, long p) {
    return 0;
}

static int RGBFReader (FILE *f, long p) {
    float c[3];
    int i;

    if (fread(&c, sizeof(c), 1, f) != 1) return 1;
    for(i=0;i<3;i++) c[i]=Indianf(c[i]);

    debug(printf("    Red: %f, Green: %f, Blue: %f\n", c[0], c[1], c[2]););

    return 0;
}

static int RGBBReader (FILE *f, long p) {
    byte c[3];
    if (fread(&c, sizeof(c), 1, f) != 1) return 1;
    debug(printf("    Red: %d, Green: %d, Blue: %d\n", c[0], c[1], c[2]););

    fprintf(deffile,"\t%f %f %f\n",c[0]/255.0,c[1]/255.0,c[2]/255.0);

    return 0;
}

static int MatNameReader (FILE *f, long p) {
    int c;
    char tmp[255];
    int i;

    FinishMat();

    ReadASCIIZ(f,tmp);
    debug(printf("Material name %s\n ",tmp););

    for(i=0;i<strlen(tmp);i++) if(tmp[i]==' ') tmp[i]='$';

    fprintf(deffile,"\nMATERIAL %s\n",tmp);
    fprintf(deffile,"\tGOURAUD|NOTHING\n\n");

    return 0;
}

static int MapFileReader(FILE *f, long p) {
    int c;
    char tmp[255];

    ReadASCIIZ(f, tmp);
    debug(printf("Map filename %s\n",tmp););

    fprintf(deffile,"\tTEXTURE_RGB|TEXTURE_BILINEAR\n");
    fprintf(deffile,"\t%s\n",tmp);

    Mapped=1;

    return 0;
}

static int BumpFileReader(FILE *f, long p) {
    int c;
    char tmp[255];

    ReadASCIIZ(f, tmp);
    debug(printf("Map filename %s\n",tmp););

    fprintf(deffile,"\t%s\n",tmp);

    BumpMapped=1;

    return 0;
}

static int DifReader(FILE *f, long p) {
    debug(printf("Diffuse\n"););
    return ChunkReader(f,p);
}

static int EmmReader(FILE *f, long p) {
    debug(printf("Emmisive\n"););
    return ChunkReader(f,p);
}

static int SpeReader(FILE *f, long p) {
    debug(printf("Specular\n"););
    ChunkReader(f,p);

    fprintf(deffile,"\t40\n\n");   // Dummy specular power
    return 0;
}


// ------------------------------------

static struct {
    word id;
    int (*func)(FILE *f, long p);
} ChunkNames[] = {
    {CHUNK_RGBF,        RGBFReader},
    {CHUNK_RGBB,        RGBBReader},

    {CHUNK_MAIN,           NULL},
    {CHUNK_OBJMESH,        NULL},

    {CHUNK_AMBCOLOR,  NULL},

    {CHUNK_OBJBLOCK,  NULL},
    {CHUNK_OBJHIDDEN, NULL},
    {CHUNK_TRIMESH,   NULL},
    {CHUNK_VERTLIST,  NULL},
    {CHUNK_FACELIST,  NULL},
    {CHUNK_FACEMAT,   NULL},
    {CHUNK_MAPLIST,   NULL},
    {CHUNK_TRMATRIX,  NULL},
    {CHUNK_LIGHT,     NULL},
    {CHUNK_SPOTLIGHT, NULL},

    {CHUNK_MATERIAL,  NULL},
    {CHUNK_MATNAME,   MatNameReader},
    {CHUNK_AMBIENT,   EmmReader},
    {CHUNK_DIFFUSE,   DifReader},
    {CHUNK_SPECULAR,  SpeReader},
    {CHUNK_TEXTURE,   NULL},
    {CHUNK_BUMPMAP,   BumpFileReader},
    {CHUNK_MAPFILE,   MapFileReader}
};

static int FindChunk(word id) {
    int i;
    for (i = 0; i < sizeof(ChunkNames)/sizeof(ChunkNames[0]); i++)
        if (id == ChunkNames[i].id)
            return i;
    return -1;
}

// ------------------------------------

static int ChunkReader(FILE *f, long p) {
    TChunkHeader h;
    int n,b;
    long pc;

    while ((pc=ftell(f)) < p) {

        if(fread(&h.id,sizeof(h.id),1,f)!=1) break;
        if(fread(&h.len,sizeof(h.len),1,f)!=1) break;
        h.id=Indians(h.id);
        h.len=Indiani(h.len);

        n = FindChunk(h.id);
        if (n < 0)
        {
                // Chunk inconnu, Hop on saute
                fseek(f, pc + h.len, SEEK_SET);
        } else
        {
            pc = pc + h.len;

            if (ChunkNames[n].func != NULL)
            {
                if((b=ChunkNames[n].func(f, pc))!=0) return b;
            }
            else if((b=ChunkReader(f, pc))!=0) return b;

            fseek(f, pc, SEEK_SET);
        }
        if (ferror(f)) return 1;
    }
    return 0;
}

int main(int argc,char **argv)
{
    FILE *_3ds;
    unsigned long fsize;
    int h;
    char *name;
    char *name2;


    printf("3DS2DEF - Panard Vision DEF file generator (c) 1998, Olivier Brunet\n");

    if(argc!=3)
    {
        printf("Invalid args\n");
        printf("You must specify the .3ds file and the .def file to be generated\n");
        printf("ex: 3ds2def file.3ds file.def\n");
        exit(1);
    }

    name=argv[1];
    name2=argv[2];

    if ((_3ds=fopen(name,"rb"))==NULL)
    {
        printf("Error opening %s\n",name);
        exit(1);
    }

    if ((deffile=fopen(name2,"wt"))==NULL)
    {
        printf("Error opening %s\n",name2);
        exit(1);
    }

    fseek(_3ds, 0, SEEK_END);
    fsize = ftell(_3ds);
    fseek(_3ds, 0, SEEK_SET);

    fprintf(deffile,"AMBIENT 0.1 0.1 0.1\n");

    h=ChunkReader(_3ds,fsize);

    FinishMat();

    fprintf(deffile,"\nEND");

    fclose(_3ds);
    fclose(deffile);

    return 0;
}
