

#include "timer.h"
#include "matrix.h"


/* *********************************************************
********************************************************* */
void timer_type::init() {

   TIME_STRUCT t;

   pause_flag = 0;
   GETTIME(&t);
   oldtime = (float)TIME2FLOAT(t);
   backscale = speedscale = 0;
}


/* *********************************************************
********************************************************* */
int timer_type::tick() {

   TIME_STRUCT t;

   float newtime, temp;

   if (pause_flag)
      return 0;

   GETTIME(&t);
   newtime = (float)TIME2FLOAT(t);

   temp = newtime - oldtime;

   if (temp < -CORRECT) {
      oldtime = newtime;
      return 0;
   }

   if (temp < CORRECT)
      return 0;

   backscale = speedscale;
   speedscale = temp;
   oldtime = newtime;
   return 1;
}

/* *********************************************************
********************************************************* */
int timer_type::manual_tick(float increment) {

   if (pause_flag)
      return 0;

   backscale = speedscale = increment;
   oldtime += increment;
   return 1;
}


/* *********************************************************
********************************************************* */
void timer_type::pause(int state) {

   TIME_STRUCT t;

   if (state) {
      pause_flag = 1;
      return;
   }

   pause_flag = 0;
   GETTIME(&t);
   oldtime = (float)TIME2FLOAT(t);
}

