

#include <string.h>

#include "pstring.h"
#include "basic_dt.h"


/* **********************************************************
********************************************************** */
string_type::string_type() {

   string = new char[size = 16];
   string[0] = 0;
   length = 0;
}


/* **********************************************************
********************************************************** */
string_type::string_type(char* src) {

   length = strlen(src);
   string = new char[size = (length+4) & 0xfffffffc];
   memcpy(string, src, length+1);
}

/* **********************************************************
********************************************************** */
string_type::~string_type() {

   if (string)
      delete [] string;
}


/* **********************************************************
********************************************************** */
void string_type::reset() {

   string[0] = 0;
   length = 0;
}


/* **********************************************************
********************************************************** */
char *string_type::stringcpy(char *src) {

   if (!src) {
      length = 0;
      string[0] = 0;
      return string;
   }
   
   length = strlen(src);
   
   if (length+1 > size) {
      delete [] string;
      string = new char[size = (length+4) & 0xfffffffc];
   }
   
   return (char *)memcpy(string, src, length+1);
}


/* **********************************************************
********************************************************** */
char *string_type::stringncpy(char *src, int len) {

   length = 0;  // undefined really

   if (!src) {
      string[0] = 0;
      return string;
   }
   
   if (len > size) {
      delete [] string;
      string = new char[size = (len+4) & 0xfffffffc];
   }
   
   return strncpy(string, src, len);
}


/* **********************************************************
********************************************************** */
char *string_type::stringcpy(string_type *src) {

   length = src->length;
   
   if (length+1 > size) {
      delete [] string;
      string = new char[size = (length+4) & 0xfffffffc];
   }
   
   return (char *)memcpy(string, src->string, length+1);
}


/* **********************************************************
********************************************************** */
char *string_type::stringcat(char *src) {

   char *oldstring;
   int i, j;
   
   if (!src)
      return string;
   
   i = length;
   length += (j = strlen(src));
   
   if (length+1 > size) {
      oldstring = string;
   
      string = new char[size = (length+4) & 0xfffffffc];
      if (oldstring[0])
         memcpy(string, oldstring, i+1);
      else
         string[0] = 0;
	 
      delete [] oldstring;
   }
   
   return (char *)memcpy(&string[i], src, j+1);
}


/* **********************************************************
********************************************************** */
char *string_type::stringcat(string_type *src) {

   char *oldstring;
   int i;
   
   if (!src)
      return string;
      
   i = length;
   length += src->length;
   
   if (length+1 > size) {
      oldstring = string;
   
      string = new char[size = (length+4) & 0xfffffffc];
      if (oldstring[0])
         memcpy(string, oldstring, i+1);
      else
         string[0] = 0;
	 
      delete [] oldstring;
   }
   
   return (char *)memcpy(&string[i], src->string, src->length+1);
}


/* **********************************************************
********************************************************** */
int string_type::stringcmp(char *str) {

   return str ? strcmp(string, str) : 1;
}


/* **********************************************************
********************************************************** */
int string_type::stringcmp(string_type *str) {

   return str ? strcmp(string, str->string) : 1;
}


/* **********************************************************
********************************************************** */
int string_type::recalc() {

   int i;
   
   for (i=0; i<size; i++)
      if (!string[i])
         return length = i;

   return length = 0;
}


/* **********************************************************
********************************************************** */
void string_type::stringsize(int len) {

   if (len < size)
      return;
      
   delete [] string;
   string = new char[size = (len+3) & 0xfffffffc];
   string[0] = 0;
}


/* **********************************************************
********************************************************** */
int string_binary_data::compare(binary_data *x) {

   return string.stringcmp(&((string_binary_data *)x)->string);
}


/* **********************************************************
********************************************************** */
buffer_type::buffer_type() {

   data = new char[size = 16];
   data[0] = 0;
   length = 0;
}


/* **********************************************************
********************************************************** */
buffer_type::~buffer_type() {

   if (data)
      delete [] data;
}


/* **********************************************************
********************************************************** */
char *buffer_type::buffercpy(char *src, int len) {

   if (!src) {
      length = 0;
      data[0] = 0;
      return data;
   }
   
   if (len > size) {
      delete [] data;
      data = new char[size = (len+3) & 0xfffffffc];
   }
   
   return (char *)memcpy(data, src, length = len);
}


/* **********************************************************
********************************************************** */
char *buffer_type::buffercpy(buffer_type *buff) {

   if (!buff || !buff->bufferlen()) {
      length = 0;
      data[0] = 0;
      return data;
   }
   
   return buffercpy(buff->data, buff->bufferlen());
}


/* **********************************************************
********************************************************** */
void buffer_type::bufferlen(int len) {

   if (len > size) {
      delete [] data;
      data = new char[size = (len+3) & 0xfffffffc];
      data[0] = 0;
   }
   
   length = len;
}


/* **********************************************************
********************************************************** */
void buffer_type::buffersize(int len) {

   if (len <= size)
      return;
      
   delete [] data;
   data = new char[size = (len+3) & 0xfffffffc];
   data[0] = 0;
   length = 0;
}

