

#include <stdio.h>
#include <string.h>
#include "pstring.h"

static char char_diff = 'A' - 'a';


/* **************************************************
Note:  strips out \" pairs for strings...
************************************************** */
int string_parser::get_token(char *x, int len) {

   int found = 0;
   int work;
   char *buffer = x;
   
   if (!string || !string[current])
      return 0;

   while (!found) {

      work = string[current];

      switch (work) {
         case 0:
            return 0;
	    
         case ' ':
         case '\t':
         case '\n':
            current++;
            break;

         case 13:  // DOS/Windoze EOLN
            current++;
            if (string[current] == '\n')
               current++;
            break;

         case '\\':
            current++;
            work = string[current];

            if (!work)
               return 0;

            buffer[0] = work;
            found = 1;
            buffer++;
            current++;
            break;
	 
         case '/':
            current++;
            work = string[current];

            if (!work)
               return 0;

            if (work == '/') {
               for (current++; string[current]; current++)
                  if (string[current] == '\n') {
                     current++;
                     break;
                  }

                  else if (string[current] == 13) {  // DOS/Windoze EOLN
                     current++;
                     if (string[current] == '\n')
                        current++;
                     break;
                  }

               break;	       
            }

            if (work == '*') {
               current++;
               work = string[current];
               while (!found) {

                  if (work == '*')
                     do {
                        current++;
                        work = string[current];
                        if (!work)
                           return 0;

                        if (work == '/') {
                           current++;
                           found = 1;
                           break;
                        }

                     } while (work == '*');

                  else {
                     current++;
                     work = string[current];
                     if (!work)
                        return 0;
                  }

               }

               found = 0;
               break;
            }

            current++;
            buffer[0] = '/';

            if (work == ' ' || work == '\t' || work == '\n') {
               buffer[1] = 0;
               return 1;
            }

            if (work == 13) {  // DOS/Windoze EOLN
               buffer[1] = 0;
               if (string[current] == '\n')
                  current++;
               return 1;
            }

            buffer[1] = work;
            found = 1;
            buffer += 2;
            break;
	    
         case '\"':
            current++;
            found = 1;
            break;
	    
         default:
            buffer[0] = work;
            found = 1;
            current++;
            buffer++;
            break;
      }

   }
   
   // "found" must contain something ...

   // is it a string?
   if (buffer == x) {

      while (1) {
         work = string[current];
      
         switch (work) {
            case 0:
               return 0;

            case '\\':
               current++;
               work = string[current];

               if (!work)
                  return 0;

               current++;

               if (work == '\n')
                  break;

               if (work == 13) {  // DOS/Windoze EOLN
                  if (string[current] == '\n')
                     current++;
                  break;
               }

               if (work == 't') {
                  *buffer = '\t';
                  buffer++;
                  break;
               }

               if (work == 'n') {
                  *buffer = '\n';
                  break;
               }

               *buffer = work;
               buffer++;
               break;

            case '\"':
               *buffer = 0;
               current++;
               return 1;

            default:
               *buffer = work;
               current++;
               buffer++;
               break;
         }
      
      }

   }

   // search until whitespace
   // dont stop at '//' or '/ * * /' because of second char.... *sigh*
   // leave trailing whitespace for next read to process
   while (1) {
      work = string[current];
      
      switch (work) {
         case 0:
            *buffer = 0;
            return 1;

         case ' ':
         case '\t':
         case '\n':
//            current++;
            *buffer = 0;
            return 1;

         case 13:  // DOS/Windoze EOLN
//            current++;
            *buffer = 0;
//            if (string[current] == '\n')
//               current++;
            return 1;

         default:
            *buffer = work;
            buffer++;
            current++;

            // reached limit of output buffer...
            if (buffer == x+len-1) {
               *buffer = 0;
               return 1;
            }

            break;
      }
      
   }

   // should never get here!
   return 1;
}


/* **************************************************
************************************************** */
int string_parser::query_token(char *x, int len) {

   int qcurrent = current;
   int ret;

   ret = get_token(x, len);
   current = qcurrent;
   return ret;
}


/* **************************************************
************************************************** */
void lower_case(char *x) {

   char *c;

   for (c = x; *c; c++)
      if (*c >= 'A' && *c <= 'Z')
         *c -= char_diff;
}


/* **************************************************
************************************************** */
void upper_case(char *x) {

   char *c;

   for (c = x; *c; c++)
      if (*c >= 'a' && *c <= 'z')
         *c += char_diff;
}


/* **************************************************
************************************************** */
void replace(char *x, char s, char r) {

   char *c;

   for (c = x; *c; c++)
      if (*c == s)
         *c = r;
}


/* **************************************************
Note:  strips out \" pairs for strings...
************************************************** */
int get_token(FILE *infile, char *x) {

/*
   int errorflag;
   int commentflag;
      
   do {
      if (fscanf(infile, "%255s", x) == EOF)
         return 0;

      // "//"
      commentflag = (x[0] == '/' && x[1] == '/');

      if (commentflag) {
         while ((errorflag=fgetc(infile)) != '\n')
            if (errorflag == EOF)
               return 0;

         continue;
      }
      
      // "/ * .. * /"
      commentflag = (x[0] == '/' && x[1] == '*');
   
      if (commentflag) {   

         errorflag=fgetc(infile);

         while (1) {
            if (errorflag == EOF)
               return 0;

            if (errorflag == '*') {
               errorflag=fgetc(infile);

               if (errorflag == '/')
	          break;
		  
               continue;
            }
	    
            errorflag=fgetc(infile);
         }
	 
      }

   } while (commentflag);
    
   return 1;
   
*/


   int found = 0;
   int work;
   char *buffer = x;
   
   while (!found) {

      work = fgetc(infile);

      switch (work) {
         case EOF:
            return 0;
	    
         case ' ':
         case '\t':
         case '\n':
            break;

         case '\\':
            work = fgetc(infile);
            if (work == EOF)
               return 0;
	       
            buffer[0] = work;
            found = 1;
            buffer++;
            break;
	 
         case '/':
            work = fgetc(infile);
	 
            if (work == '/') {
	    
               do {
                  work = fgetc(infile);
               } while (work != EOF && work != '\n');

               break;	       
            }

            if (work == '*') {
               while ((work = fgetc(infile)) != EOF && !found)
                  while (work == '*' && work != EOF) {
                     work = fgetc(infile);
                     if (work == '/') {
                        found = 1;
                        break;
                     }
		     
                  }			

               found = 0;
               break;
            }

            buffer[0] = '/';
            if (work == ' ' || work == '\t' || work == '\n') {
               buffer[1] = 0;
               return 1;
            }

            buffer[1] = work;
            found = 1;
            buffer += 2;
            break;
	    
         case '\"':
            found = 1;
            break;
	    
         default:
            buffer[0] = work;
            found = 1;
            buffer++;
            break;
      }

   }
   

   // is it a string?
   if (buffer == x) {

      while (1) {
         work = fgetc(infile);
      
         switch (work) {
            case EOF:
               return 0;

            case '\\':
               work = fgetc(infile);
               if (work == EOF)
                  return 0;

               if (work == '\n')
                  break;

               if (work == 't') {
                  *buffer = '\t';
                  buffer++;
                  break;
               }

               if (work == 'n') {
                  *buffer = '\n';
                  break;
               }

               *buffer = work;
               buffer++;
               break;

            case '\"':
               *buffer = 0;
               return 1;

            default:
               *buffer = work;
               buffer++;
               break;
         }
      
      }

   }

   // search until whitespace
   // dont stop at '//' or '/ * * /' because of second char.... *sigh*
   while (1) {
      work = fgetc(infile);
      
      switch (work) {
         case EOF:
         case ' ':
         case '\t':
         case '\n':
            *buffer = 0;
            return 1;

         default:
            *buffer = work;
            buffer++;
            break;
      }
      
   }

   // should never get here!
   return 1;
}


/* **************************************************
************************************************** */
void float2char(float in, char *out) {

   int i, j, k;

   sprintf(out, "%f", in);

   k = strlen(out);

   for (i=0; i<k; i++)
      if (out[i] == '.') {
         for (j=k-1; j > i && out[j] == '0'; j--)
            out[j] = 0;

         if (i==j)
            out[i] = 0;

         return;
      }

}

