

#include <stdio.h>
#include <string.h>
#include "map.h"


/* ****************************************************************************************
**************************************************************************************** */
mapul::mapul() {

   alloc_data = NULL;
   data = NULL;
   pdata = NULL;
}


mapul::~mapul() {

   if (alloc_data) {
      delete [] alloc_data;
      delete [] pdata;
   }

}


void mapul::flip_bytes() {

   unsigned int i, j;

   j = maxx*maxy;

   for (i=0; i<j; i++)
#ifdef WIN32
      data[i] = (data[i]>>8) | ((data[i] & 0xff)<<24);
#else
      data[i] = (data[i]>>24) | ((((data[i]>>16) & 0xff) | (((data[i]>>8) & 0xff) | ((data[i] & 0xff) << 8)) << 8) << 8);
#endif
}


void mapul::init_map(unsigned int x, unsigned int y) {

   unsigned int size;
   unsigned int i, j;

   if (!alloc_data || x != maxx || y != maxy) {
      maxx = x;
      maxy = y;
      size = x*y;

      if (alloc_data) {
         delete [] alloc_data;
         delete [] pdata;
      }

      alloc_data = data = new unsigned int[size];
      pdata = new puint[y];

      for (i=j=0; i<y; i++, j+=x)
         pdata[i] = &data[j];
   }

}


void mapul::init_map(unsigned int x, unsigned int y, int offset_index) {

   unsigned int size;
   unsigned int i, j;
   int offset = offset_index * 36;

   if (!alloc_data || x != maxx || y != maxy) {
      maxx = x;
      maxy = y;
      size = x*y;

      if (alloc_data) {
         delete [] alloc_data;
         delete [] pdata;
      }

      alloc_data = new unsigned int[size+32];   // + 128 bytes

      i = (unsigned int)alloc_data;
      if ((i & 0x7f) > (unsigned int)offset)
         data = (unsigned int *)(((i & 0xffffff80) | offset) + 0x80);
      else
         data = (unsigned int *)((i & 0xffffff80) | offset);

      pdata = new puint[y];

      for (i=j=0; i<y; i++, j+=x)
         pdata[i] = &data[j];
   }

}


void mapul::zero() {

   memset(data, 0, maxx*maxy<<2);       // int - 4 bytes
}


/* ****************************************************************************************
**************************************************************************************** */
mapf::mapf() {

   alloc_data = NULL;
   data = NULL;
   pdata = NULL;
}


mapf::~mapf() {

   if (alloc_data) {
      delete [] alloc_data;
      delete [] pdata;
   }

}

void mapf::init_map(unsigned int x, unsigned int y) {

   unsigned int size;
   unsigned int i, j;

   if (!alloc_data || x != maxx || y != maxy) {
      maxx = x;
      maxy = y;
      size = x*y;

      if (alloc_data) {
         delete [] alloc_data;
         delete [] pdata;
      }

      alloc_data = data = new float[size];
      pdata = new pfloat[y];

      for (i=j=0; i<y; i++, j+=x)
         pdata[i] = &data[j];
   }

}


void mapf::init_map(unsigned int x, unsigned int y, int offset_index) {

   unsigned int size;
   unsigned int i, j;
   int offset = offset_index * 36;

   if (!alloc_data || x != maxx || y != maxy) {
      maxx = x;
      maxy = y;
      size = x*y;

      if (alloc_data) {
         delete [] alloc_data;
         delete [] pdata;
      }

      alloc_data = new float[size+32];   // + 128 bytes

      i = (unsigned int)alloc_data;
      if ((i & 0x7f) > (unsigned int)offset)
         data = (float *)(((i & 0xffffff80) | offset) + 0x80);
      else
         data = (float *)((i & 0xffffff80) | offset);

      pdata = new pfloat[y];

      for (i=j=0; i<y; i++, j+=x)
         pdata[i] = &data[j];
   }

}


void mapf::zero() {

   memset(data, 0, maxx*maxy<<2);       // float - 4 bytes
}


/* ****************************************************************************************
**************************************************************************************** */
mapuc::mapuc() {

   alloc_data = NULL;
   data = NULL;
   pdata = NULL;
}


mapuc::~mapuc() {

   if (alloc_data) {
      delete [] alloc_data;
      delete [] pdata;
   }

}


void mapuc::init_map(unsigned int x, unsigned int y) {

   unsigned int size;
   unsigned int i, j;

   if (!alloc_data || x != maxx || y != maxy) {
      maxx = x;
      maxy = y;
      size = x*y;

      if (alloc_data) {
         delete [] alloc_data;
         delete [] pdata;
      }

      alloc_data = data = new unsigned char[size];
      pdata = new puchar[y];

      for (i=j=0; i<y; i++, j+=x)
         pdata[i] = &data[j];
   }

}


void mapuc::init_map(unsigned int x, unsigned int y, int offset_index) {

   unsigned int size;
   unsigned int i, j;
   int offset = offset_index * 36;

   if (!alloc_data || x != maxx || y != maxy) {
      maxx = x;
      maxy = y;
      size = x*y;

      if (alloc_data) {
         delete [] alloc_data;
         delete [] pdata;
      }

      alloc_data = new unsigned char[size+128];   // + 128 bytes

      i = (unsigned int)alloc_data;
      if ((i & 0x7f) > (unsigned int)offset)
         data = (unsigned char *)(((i & 0xffffff80) | offset) + 0x80);
      else
         data = (unsigned char *)((i & 0xffffff80) | offset);

      pdata = new puchar[y];

      for (i=j=0; i<y; i++, j+=x)
         pdata[i] = &data[j];
   }

}


void mapuc::zero() {

   memset(data, 0, maxx*maxy);
}


/* ****************************************************************************************
**************************************************************************************** */
maplexel::maplexel() {

   alloc_data = NULL;
   data = NULL;
   pdata = NULL;
}


maplexel::~maplexel() {

   if (alloc_data) {
      delete [] alloc_data;
      delete [] pdata;
   }

}


void maplexel::init_map(unsigned int x, unsigned int y) {

   unsigned int size;
   unsigned int i, j;

   if (!alloc_data || x != maxx || y != maxy) {
      maxx = x;
      maxy = y;
      size = x*y;

      if (alloc_data) {
         delete [] alloc_data;
         delete [] pdata;
      }

      alloc_data = data = new lexel_type[size];
      pdata = new plexel_type[y];

      for (i=j=0; i<y; i++, j+=x)
         pdata[i] = &data[j];
   }

}


void maplexel::init_map(unsigned int x, unsigned int y, int offset_index) {

   unsigned int size;
   unsigned int i, j;
   int offset = offset_index * 36;

   if (!alloc_data || x != maxx || y != maxy) {
      maxx = x;
      maxy = y;
      size = x*y;

      if (alloc_data) {
         delete [] alloc_data;
         delete [] pdata;
      }

      alloc_data = new lexel_type[size+16];   // + 128 bytes

      i = (unsigned int)alloc_data;
      if ((i & 0x7f) > (unsigned int)offset)
         data = (lexel_type *)(((i & 0xffffff80) | offset) + 0x80);
      else
         data = (lexel_type *)((i & 0xffffff80) | offset);

      pdata = new plexel_type[y];

      for (i=j=0; i<y; i++, j+=x)
         pdata[i] = &data[j];
   }

}


void maplexel::zero() {

   memset(data, 0, maxx*maxy<<3);
}

