

#include <stdlib.h>
#include <string.h>

#include "linetype.h"
#include "matrix.h"


void linelist::dest() {

   if (list) {
      delete [] list;

      count = 0;
      list = NULL;
   }

}


void linelist::build(int i) {

   dest();
   list = new dbl_llist_manager[i];
   count = i;
}


int linelist::insert(int i, line_type *x) {

   if (i >= count)
      return 0;

   list[i].insert(x, NULL);

   return 1;
}


int linelist::insert(int i, int x1, int y1, int x2, int y2) {

   line_type *ptr;

   if (i >= count)
      return 0;

   list[i].insert(ptr = new line_type, NULL);

   ptr->pt[0] = (x1<<16) | y1;
   ptr->pt[1] = (x2<<16) | y2;

   return 1;
}


/* *************************************************************
************************************************************* */
int clip_greater2D(int *v0, int *v1, int index, int plane) {

   float factor;
   int iindex = !index;

   if (v0[index] > plane) {

      if (v1[index] > plane)		// line clipped out of oblivion
         return 0;

      factor = (plane - v0[index]) / (float)(v1[index] - v0[index]);
      v0[index] = plane;

      factor = v0[iindex] + factor * (v1[iindex] - v0[iindex]);
      v0[iindex] = round(factor);
      return 1;
   }

   if (v1[index] <= plane)
      return 1;

   factor = (plane - v1[index]) / (float)(v0[index] - v1[index]);
   v1[index] = plane;

   factor = v1[iindex] + factor * (v0[iindex] - v1[iindex]);
   v1[iindex] = round(factor);
   return 1;
}


/* *************************************************************
************************************************************* */
int clip_lesser2D(int *v0, int *v1, int index, int plane) {

   float factor;
   int iindex = !index;

   if (v0[index] < plane) {

      if (v1[index] < plane)		// line clipped out of oblivion
         return 0;

      factor = (plane - v0[index]) / (float)(v1[index] - v0[index]);
      v0[index] = plane;

      factor = v0[iindex] + factor * (v1[iindex] - v0[iindex]);
      v0[iindex] = round(factor);
      return 1;
   }

   if (v1[index] >= plane)
      return 1;

   factor = (plane - v1[index]) / (float)(v0[index] - v1[index]);
   v1[index] = plane;

   factor = v1[iindex] + factor * (v0[iindex] - v1[iindex]);
   v1[iindex] = round(factor);
   return 1;
}


/* ***************************************************************
                          bressem line
*************************************************************** */
void lineblt(int *pt0, int *pt1, unsigned int color, void *buffer, int maxx, int maxy) {

   int temp[2];
   int i, j, k;
   int absdeltax, absdeltay;
   int deltax, deltay;
   int yinc;
   int run_length, rlplus, rlinc, rlflag;
   int v0[2], v1[2];

   unsigned int *start, *end;
   unsigned int *data = (unsigned int *)buffer;

   copyarray2(v0, pt0);
   copyarray2(v1, pt1);

   if (!clip_lesser2D(v0, v1, 0, 0) || !clip_greater2D(v0, v1, 0, maxx-1) ||
       !clip_lesser2D(v0, v1, 1, 0) || !clip_greater2D(v0, v1, 1, maxy-1))
       return;

   if (v0[1] == v1[1]) {                      // horizontal
      if (v0[0] > v1[0]) {
         j  = v0[0];
         v0[0] = v1[0];
         v1[0] = j;
      }

      start = data + v0[1]*maxx;
      end = start + v1[0];
      start += v0[0];

      for (; start<end; start++)
         *start = color;

      return;
   }

   if (v0[0] == v1[0]) {                      // vertical
      if (v0[1] > v1[1]) {
         j  = v0[1];
         v0[1] = v1[1];
         v1[1] = j;
      }

      start = data + v0[1]*maxx + v0[0];
      end   = data + v1[1]*maxx + v0[0];

      for (; start<end; start+=maxx)
         *start = color;

      return;
   }

   deltax = v1[0] - v0[0];
   absdeltax = abs(deltax);
   deltay = v1[1] - v0[1];
   absdeltay = abs(deltay);

   if (deltax < 0) {                    // deltax is pos
      copyarray2(temp, v0);
      copyarray2(v0, v1);
      copyarray2(v1, temp);

      yinc = (deltay > 0) ? -maxx : maxx;
   }

   else
      yinc = (deltay < 0) ? -maxx : maxx;

   start = data + v0[1]*maxx + v0[0];

   i = 0;
   if (absdeltax > absdeltay) {         // mostly horizontal

      run_length = absdeltax / absdeltay;
      rlinc = absdeltax % absdeltay;

      if (run_length < 3) {             // bresseham's

         for (j=0; j < absdeltax; j++, start++) {
            *start = color;

            i += absdeltay;

            if (i > absdeltax) {
               i -= absdeltax;
               start += yinc;
            }

         }

         return;
      }
                                // bresseham's run length
      rlflag = 0;
      rlplus = run_length + 1;

      for (j=run_length; j <= absdeltax;) {

         for (end=start+run_length; start<end; start++)
            *start = color;

         start += yinc;
         i += rlinc;

         if (rlflag) {
            *start = color;
            start++;
            rlflag = 0;
         }

         if (i > absdeltax) {
            j += rlplus;
            i -= absdeltax;
            rlflag = 1;
         }

         else
            j += run_length;
      }

      for (end=start+absdeltax-j+(rlflag ? rlplus : run_length); start<end; start++)
         *start = color;

      return;
   }
                                // mostly vertical
   run_length = absdeltay / absdeltax;
   rlinc = absdeltay % absdeltax;

   if (run_length < 3) {                // bresseham's

      for (j=0; j<absdeltay; j++) {     // down to up
         *start = color;

         start += yinc;
         i += absdeltax;

         if (i > absdeltay) {
            i -= absdeltay;
            start++;
         }

      }

       return;
   }
                                        // bresseham's run length
   rlflag = 0;
   rlplus = run_length + 1;

   for (j=run_length; j <= absdeltay;) {

      for (k=0; k<run_length; k++, start+=yinc)
         *start = color;

      start++;
      i += rlinc;

      if (rlflag) {
         *start = color;
         start += yinc;
         rlflag = 0;
      }

      if (i > absdeltay) {
         j += rlplus;
         i -= absdeltay;
         rlflag = 1;
      }

      else
         j += run_length;
   }

   for (j -= (rlflag ? rlplus : run_length); j < absdeltay; j++, start+=yinc)
      *start = color;
}


/* ***************************************************************
                          bressem line
*************************************************************** */
void pointblt(int *pt, unsigned int color, void *buffer, int maxx, int maxy) {

   unsigned int *data = (unsigned int *)buffer;

   if (pt[0] > -1 && pt[0] < maxx && pt[1] > -1 && pt[1] < maxy)
      data[pt[1]*maxx + pt[0]] = color;
}

