

#include "basic_dt.h"


/* *******************************************************
******************************************************* */
void dbl_llist::insert(dbl_llist *x) {

   x->next = this;
   x->back = back;

   if (back)
      back->next = x;
      
   back = x;
}


/* *******************************************************
******************************************************* */
void dbl_llist::append(dbl_llist *x) {

   x->next = next;
   x->back = this;
   
   if (next)
      next->back = x;

   next = x;
}


/* *******************************************************
******************************************************* */
void dbl_llist::remove() {

   if (next)
      next->back = back;
   
   if (back)
      back->next = next;

   next = back = NULL;  
}


/* *******************************************************
******************************************************* */
void dbl_llist_manager::dest() {
   
   dbl_llist *ptr;

   while (head) {
      ptr = head;
      head = head->next;
      ptr->next = NULL;
      delete ptr;
   }

   head = tail = NULL;
   count = 0;
}


/* *******************************************************
******************************************************* */
dbl_llist *dbl_llist_manager::insert(dbl_llist *x, dbl_llist *target) {

   count++;
   
   if (!target) {
      if (!head) {
         head = tail = x;
         x->next = x->back = NULL;
         return x;
      }

      head->insert(x);
      return head = x;
   }
   
   target->insert(x);
   if (head == target)
      head = x;
      
   return x;
}


/* *******************************************************
******************************************************* */
dbl_llist *dbl_llist_manager::append(dbl_llist *x, dbl_llist *target) {

   count++;

   if (!target) {
      if (!head) {
         head = tail = x;
         x->next = x->back = NULL;
         return x;
      }

      tail->append(x);
      return tail = x;
   }
   
   target->append(x);

   if (!x->next)
      tail = x;

   return x;
}


/* *******************************************************
******************************************************* */
int dbl_llist_manager::remove(dbl_llist *x) {

   count--;

   if (x == tail)
      tail = tail->back;
   if (x == head)
      head = head->next;
      
   x->remove();
   return 1;
}


