

#include <stdlib.h>
#include <string.h>

#include "pstring.h"
#include "dataio.h"
#include "global.h"

#define BUFFERSIZE 65536 // 64Kb


/* ***********************************************************************
*********************************************************************** */
float getfloat(FILE *infile) {

   unsigned char buf[4];
   float y;

   fread(buf,4,1,infile);
   *((unsigned int *)(&y)) =  (((((buf[0]<<8) | buf[1])<<8) | buf[2])<<8) | buf[3];

   return y;
}


/* ***********************************************************************
*********************************************************************** */
unsigned char getuchar(FILE *infile) {

   unsigned char buf;

   fread(&buf,1,1,infile);
   return buf;
}


/* ***********************************************************************
*********************************************************************** */
unsigned short getushort(FILE *infile) {

   unsigned char buf[2];

   fread(buf,2,1,infile);
   return (buf[0]<<8) | buf[1];
}


/* ***********************************************************************
*********************************************************************** */
unsigned short getrushort(FILE *infile) {

   unsigned char buf[2];

   fread(buf,2,1,infile);
   return (buf[1]<<8) | buf[0];
}


/* ***********************************************************************
*********************************************************************** */
unsigned int getuint(FILE *infile) {

   unsigned char buf[4];

   fread(buf,4,1,infile);
   return (((((buf[0]<<8) | buf[1])<<8) | buf[2])<<8) | buf[3];
}


/* ***********************************************************************
*********************************************************************** */
unsigned int getruint(FILE *infile) {

   unsigned char buf[4];

   fread(buf,4,1,infile);
   return (((((buf[3]<<8) | buf[2])<<8) | buf[1])<<8) | buf[0];
}


/* ***********************************************************************
*********************************************************************** */
double getdouble(FILE *infile) {

   union {
      double buf;
      unsigned char ret[8];
   };

#ifdef SGI
   fread(&buf, 1, 8, infile);
#else
   unsigned char ptr[8];

   fread(&ptr, 1, 8, infile);

   ret[0] = ptr[7];
   ret[1] = ptr[6];
   ret[2] = ptr[5];
   ret[3] = ptr[4];
   ret[4] = ptr[3];
   ret[5] = ptr[2];
   ret[6] = ptr[1];
   ret[7] = ptr[0];
#endif

   return buf;
}


/* ***********************************************************************
*********************************************************************** */
int getstring(FILE *infile, char *buffer, int maxlen) {

   int len = 0;
   int status;

   do {
      buffer[len] = status = fgetc(infile);

      if (status == EOF)
         return 0;

      len++;
   } while (len <= maxlen-1 && buffer[len-1]);

   return (buffer[len-1]) ? -len : len; // if not eoln and buffer full, negate len...
}


/* ***********************************************************************
*********************************************************************** */
void putuchar(FILE *outfile, unsigned char val) {

   fwrite(&val,1,1,outfile);
}


/* ***********************************************************************
*********************************************************************** */
void putushort(FILE *outfile, unsigned short val) {

   unsigned char buf[2];

   buf[0] = (val>>8);
   buf[1] = val & 0xff;
   fwrite(buf,2,1,outfile);
}


/* ***********************************************************************
*********************************************************************** */
void putrushort(FILE *outfile, unsigned short val) {

   unsigned char buf[2];

   buf[1] = (val>>8);
   buf[0] = val & 0xff;
   fwrite(buf,2,1,outfile);
}


/* ***********************************************************************
*********************************************************************** */
void putuint(FILE *outfile, unsigned int val) {

   unsigned char buf[4];

   buf[0] = (unsigned char)(val>>24);
   buf[1] = (unsigned char)(val>>16) & 0xff;
   buf[2] = (unsigned char)(val>>8)  & 0xff;
   buf[3] = (unsigned char)val       & 0xff;
   fwrite(buf,4,1,outfile);
}


/* ***********************************************************************
*********************************************************************** */
void putruint(FILE *outfile, unsigned int val) {

   unsigned char buf[4];

   buf[3] = (unsigned char)(val>>24);
   buf[2] = (unsigned char)(val>>16) & 0xff;
   buf[1] = (unsigned char)(val>>8)  & 0xff;
   buf[0] = (unsigned char)val       & 0xff;
   fwrite(buf,4,1,outfile);
}


/* ***********************************************************************
*********************************************************************** */
void sfile::init() {

   size = vsize = 0;
   ptr = data = NULL;
   filename.reset();
}


/* ***********************************************************************
*********************************************************************** */
void sfile::dest() {

   if (data)
      delete [] data;

   init();
}


/* ***********************************************************************
*********************************************************************** */
int sfile::scan_data(char *fname, char *envstr, char slash) {

   FILE *infile;
   unsigned int tsize;
   
   if (!find_file(fname, "rb", envstr, slash, NULL, &infile)) {
      sprintf(perror_buffer, "Error: Cannot access %s...\n", fname);
      pprintf(perror_buffer);
      return 0;
   }

   filename.stringcpy(fname);

   fseek(infile, 0, SEEK_END);
   tsize = ftell(infile);
   fseek(infile, 0, SEEK_SET);

   if (!data || tsize != size) {

      if (data)
         delete [] data;
	 
      size = tsize;
      data = new unsigned char[size];
   }

   fread(data, size, 1, infile);

   ptr = data;

   fclose(infile);
   return 1;
}


/* ***********************************************************************
*********************************************************************** */
int sfile::scan_data(buffer_type *buffer) {

   filename.reset();

   if (!data || buffer->bufferlen() != (int)size) {

      if (data)
         delete [] data;
	 
      data = new unsigned char[size = buffer->bufferlen()];
   }

   memcpy(data, buffer->data, size);
   ptr = data;
   return 1;
}


/* ***********************************************************************
*********************************************************************** */
char sfile::scan_char() {

   unsigned char ret;

   ret = ptr[0];
   ptr++;

   return (char)ret;
}


/* ***********************************************************************
*********************************************************************** */
unsigned char sfile::scan_uchar() {

   unsigned char ret;

   ret = ptr[0];
   ptr++;

   return ret;
}


/* ***********************************************************************
*********************************************************************** */
short sfile::scan_short() {

   unsigned short ret;

   ret = (ptr[0]<<8) | ptr[1];
   ptr += 2;

   return (short)ret;
}


/* ***********************************************************************
*********************************************************************** */
short sfile::scan_rshort() {

   unsigned short ret;

   ret = (ptr[1]<<8) | ptr[0];
   ptr += 2;

   return (short)ret;
}


/* ***********************************************************************
*********************************************************************** */
unsigned short sfile::scan_ushort() {

   unsigned short ret;

   ret = (ptr[0]<<8) | ptr[1];
   ptr += 2;

   return ret;
}


/* ***********************************************************************
*********************************************************************** */
unsigned short sfile::scan_rushort() {

   unsigned short ret;

   ret = (ptr[1]<<8) | ptr[0];
   ptr += 2;

   return ret;
}


/* ***********************************************************************
*********************************************************************** */
int sfile::scan_int() {

   unsigned int ret;

   ret = (((((ptr[0]<<8) | ptr[1])<<8) | ptr[2])<<8) | ptr[3];
   ptr += 4;

   return (int)ret;
}


/* ***********************************************************************
*********************************************************************** */
int sfile::scan_rint() {

   unsigned int ret;

   ret = (((((ptr[3]<<8) | ptr[2])<<8) | ptr[1])<<8) | ptr[0];
   ptr += 4;

   return (int)ret;
}


/* ***********************************************************************
*********************************************************************** */
unsigned int sfile::scan_uint() {

   unsigned int ret;

   ret = (((((ptr[0]<<8) | ptr[1])<<8) | ptr[2])<<8) | ptr[3];
   ptr += 4;

   return ret;
}


/* ***********************************************************************
*********************************************************************** */
unsigned int sfile::scan_ruint() {

   unsigned int ret;

   ret = (((((ptr[3]<<8) | ptr[2])<<8) | ptr[1])<<8) | ptr[0];
   ptr += 4;

   return ret;
}


/* ***********************************************************************
*********************************************************************** */
float sfile::scan_float() {

   float ret;

   *((unsigned int *)(&ret)) =  (((((ptr[0]<<8) | ptr[1])<<8) | ptr[2])<<8) | ptr[3];
   ptr += 4;
   
   return ret;
}



/* ***********************************************************************
*********************************************************************** */
float sfile::scan_rfloat() {

   float ret;

   *((unsigned int *)(&ret)) =  (((((ptr[3]<<8) | ptr[2])<<8) | ptr[1])<<8) | ptr[0];
   ptr += 4;
   
   return ret;
}



/* ***********************************************************************
*********************************************************************** */
double sfile::scan_double() {

   union {
      double d;
      unsigned char c[8];
   };

#ifdef SGI
   c[0] = ptr[0];
   c[1] = ptr[1];
   c[2] = ptr[2];
   c[3] = ptr[3];
   c[4] = ptr[4];
   c[5] = ptr[5];
   c[6] = ptr[6];
   c[7] = ptr[7];
#else
   c[0] = ptr[7];
   c[1] = ptr[6];
   c[2] = ptr[5];
   c[3] = ptr[4];
   c[4] = ptr[3];
   c[5] = ptr[2];
   c[6] = ptr[1];
   c[7] = ptr[0];
#endif

   ptr += 8;
   return d;
}


/* ***********************************************************************
*********************************************************************** */
double sfile::scan_rdouble() {

   union {
      double d;
      unsigned char c[8];
   };

#ifdef SGI
   c[0] = ptr[7];
   c[1] = ptr[6];
   c[2] = ptr[5];
   c[3] = ptr[4];
   c[4] = ptr[3];
   c[5] = ptr[2];
   c[6] = ptr[1];
   c[7] = ptr[0];
#else
   c[0] = ptr[0];
   c[1] = ptr[1];
   c[2] = ptr[2];
   c[3] = ptr[3];
   c[4] = ptr[4];
   c[5] = ptr[5];
   c[6] = ptr[6];
   c[7] = ptr[7];
#endif

   ptr += 8;
   return d;
}


/* ***********************************************************************
*********************************************************************** */
void sfile::skip(int x) {

   ptr += x;
}


/* ***********************************************************************
*********************************************************************** */
int sfile::sread(char *buffer, unsigned int len) {

   unsigned char *end = ptr + len;
   
   if (end > data + size) {
      ptr = end;
      return -1;
   }
      
   memcpy(buffer, ptr, len);
   ptr = end;

   return len;
}


/* ***********************************************************************
*********************************************************************** */
void sfile::sseek(unsigned int x) {

   ptr = data + x;
}


/* ***********************************************************************
*********************************************************************** */
int sfile::seof() {

   return ptr >= data + size;
}


/* *******************************************************************
******************************************************************* */
void sfile::increment() {

   unsigned char *buffer;
   unsigned int offset;
     
   buffer = new unsigned char[size + BUFFERSIZE];
   
   if (!buffer) {
      sprintf(perror_buffer, "ERROR: Memory leak encountered.\n\tUnable to allocate a buffer of size %d.\n\tAborting...\n", size+BUFFERSIZE);
      pprintf(perror_buffer);
      exit(0);
   }
      
   offset = ptr - data;
   
   if (data) {
      memcpy(buffer, data, size);
      delete [] data;
   }
   
   data = buffer;
   ptr = data + offset;
   size += BUFFERSIZE;
}


/* *******************************************************************
******************************************************************* */
int sfile::dump_data(char *fname) {

   FILE *outfile;
      
   outfile = fopen(fname, "wb");
   
   if (!outfile)
      return 0;

   fwrite(data, vsize, 1, outfile);
   fclose(outfile);
   return 1;
}


/* *******************************************************************
******************************************************************* */
void sfile::sput_uchar(unsigned char val) {

   while (ptr+1 > data+size)
      increment();

   *ptr = (char)val;
   ptr++;

   if (ptr > data + vsize)
      vsize = ptr - data;
}


/* *******************************************************************
******************************************************************* */
void sfile::sput_char(char val) {

   while (ptr+1 > data+size)
      increment();

   *ptr = val;
   ptr++;

   if (ptr > data + vsize)
      vsize = ptr - data;
}


/* *******************************************************************
******************************************************************* */
void sfile::sput_short(short val) {

   while (ptr+2 > data+size)
      increment();
      
   ptr[1] = val & 0xff; val = val>>8;
   ptr[0] = val & 0xff;
   
   ptr += 2;
   if (ptr > data + vsize)
      vsize = ptr - data;
}


/* *******************************************************************
******************************************************************* */
void sfile::sput_rshort(short val) {

   while (ptr+2 > data+size)
      increment();
      
   ptr[0] = val & 0xff; val = val>>8;
   ptr[1] = val & 0xff;
   
   ptr += 2;
   if (ptr > data + vsize)
      vsize = ptr - data;
}


/* *******************************************************************
******************************************************************* */
void sfile::sput_ushort(unsigned short val) {

   while (ptr+2 > data+size)
      increment();
      
   ptr[1] = val & 0xff; val = val>>8;
   ptr[0] = val & 0xff;
   
   ptr += 2;
   if (ptr > data + vsize)
      vsize = ptr - data;
}


/* *******************************************************************
******************************************************************* */
void sfile::sput_rushort(unsigned short val) {

   while (ptr+2 > data+size)
      increment();
      
   ptr[0] = val & 0xff; val = val>>8;
   ptr[1] = val & 0xff;
   
   ptr += 2;
   if (ptr > data + vsize)
      vsize = ptr - data;
}


/* *******************************************************************
******************************************************************* */
void sfile::sput_int(int val) {

   unsigned int reg = (unsigned int)val;
   
   while (ptr+4 > data+size)
      increment();
      
   ptr[3] = reg & 0xff; reg = reg>>8;
   ptr[2] = reg & 0xff; reg = reg>>8;
   ptr[1] = reg & 0xff; reg = reg>>8;
   ptr[0] = reg & 0xff;
   
   ptr += 4;
   if (ptr > data + vsize)
      vsize = ptr - data;
}


/* *******************************************************************
******************************************************************* */
void sfile::sput_rint(int val) {

   unsigned int reg = (unsigned int)val;
   
   while (ptr+4 > data+size)
      increment();
      
   ptr[0] = reg & 0xff; reg = reg>>8;
   ptr[1] = reg & 0xff; reg = reg>>8;
   ptr[2] = reg & 0xff; reg = reg>>8;
   ptr[3] = reg & 0xff;
   
   ptr += 4;
   if (ptr > data + vsize)
      vsize = ptr - data;
}


/* *******************************************************************
******************************************************************* */
void sfile::sput_uint(unsigned int val) {

   while (ptr+4 > data+size)
      increment();
      
   ptr[3] = val & 0xff; val = val>>8;
   ptr[2] = val & 0xff; val = val>>8;
   ptr[1] = val & 0xff; val = val>>8;
   ptr[0] = val & 0xff;
   
   ptr += 4;
   if (ptr > data + vsize)
      vsize = ptr - data;
}


/* *******************************************************************
******************************************************************* */
void sfile::sput_ruint(unsigned int val) {

   while (ptr+4 > data+size)
      increment();
      
   ptr[0] = val & 0xff; val = val>>8;
   ptr[1] = val & 0xff; val = val>>8;
   ptr[2] = val & 0xff; val = val>>8;
   ptr[3] = val & 0xff;
   
   ptr += 4;
   if (ptr > data + vsize)
      vsize = ptr - data;
}


/* *******************************************************************
******************************************************************* */
void sfile::sput_float(float val) {

   unsigned int reg = *(unsigned int *)&val;
   
   while (ptr+4 > data+size)
      increment();
      
   ptr[3] = reg & 0xff; reg = reg>>8;
   ptr[2] = reg & 0xff; reg = reg>>8;
   ptr[1] = reg & 0xff; reg = reg>>8;
   ptr[0] = reg & 0xff;
   
   ptr += 4;
   if (ptr > data + vsize)
      vsize = ptr - data;
}


/* *******************************************************************
******************************************************************* */
void sfile::sput_rfloat(float val) {

   unsigned int reg = *(unsigned int *)&val;
   
   while (ptr+4 > data+size)
      increment();
      
   ptr[0] = reg & 0xff; reg = reg>>8;
   ptr[1] = reg & 0xff; reg = reg>>8;
   ptr[2] = reg & 0xff; reg = reg>>8;
   ptr[3] = reg & 0xff;
   
   ptr += 4;
   if (ptr > data + vsize)
      vsize = ptr - data;
}


/* *******************************************************************
******************************************************************* */
void sfile::sput_double(double val) {

   unsigned char *c = (unsigned char *)&val;
   
   while (ptr+8 > data+size)
      increment();
 
#ifdef SGI
   ptr[0] = c[0];
   ptr[1] = c[1];
   ptr[2] = c[2];
   ptr[3] = c[3];
   ptr[4] = c[4];
   ptr[5] = c[5];
   ptr[6] = c[6];
   ptr[7] = c[7];
#else
   ptr[0] = c[7];
   ptr[1] = c[6];
   ptr[2] = c[5];
   ptr[3] = c[4];
   ptr[4] = c[3];
   ptr[5] = c[2];
   ptr[6] = c[1];
   ptr[7] = c[0];
#endif
   
   ptr += 8;
   if (ptr > data + vsize)
      vsize = ptr - data;
}


/* *******************************************************************
******************************************************************* */
void sfile::sput_rdouble(double val) {

   unsigned char *c = (unsigned char *)&val;
   
   while (ptr+8 > data+size)
      increment();
 
#ifdef SGI
   ptr[0] = c[7];
   ptr[1] = c[6];
   ptr[2] = c[5];
   ptr[3] = c[4];
   ptr[4] = c[3];
   ptr[5] = c[2];
   ptr[6] = c[1];
   ptr[7] = c[0];
#else
   ptr[0] = c[0];
   ptr[1] = c[1];
   ptr[2] = c[2];
   ptr[3] = c[3];
   ptr[4] = c[4];
   ptr[5] = c[5];
   ptr[6] = c[6];
   ptr[7] = c[7];
#endif
   
   ptr += 8;
   if (ptr > data + vsize)
      vsize = ptr - data;
}


/* *******************************************************************
******************************************************************* */
void sfile::swrite(char *buffer, unsigned int len) {

   while (ptr+len > data+size)
      increment();

   memcpy(ptr, buffer, len);

   ptr += len;     
   if (ptr > data + vsize)
      vsize = ptr - data;
}


/* *******************************************************************
******************************************************************* */
char *sfile::sgets(char *buffer, unsigned int len) {

   int i, j;

   len--;
   
   for (i=j=0; i<(int)len && ptr+i < data+size && ptr[i] != '\n'; i++)
      if (ptr[i] != 13) {
         buffer[j] = ptr[i];
         j++;
      }

   if (!j)
      return NULL;

   ptr += i+1;
   buffer[j] = 0;
   return buffer;
}


/* *******************************************************************
******************************************************************* */
int sfile::sgetc() {

   int ret;
   
   if (ptr >= data+size)
      return EOF;
      
   ret = *ptr;
   ptr++;
   return ret;
}


/* *******************************************************************
******************************************************************* */
int sfile::scan_token(char *buffer, int len) {

   string_parser parser;
   int ret;
   
   parser.set_string((char *)ptr);
   ret = parser.get_token(buffer, len);
   skip(parser.current);
   return ret;
}


/* ***********************************************************************
*********************************************************************** */
int sfile::scanstring(char *buffer, int maxlen) {

   int len = 0;
   unsigned char *end = data+size;
   
   do {
      if (ptr >= end)
         return 0;
	 
      buffer[len] = *ptr;
      ptr++;
      len++;
   } while (len <= maxlen-1 && buffer[len-1]);

   return (buffer[len-1]) ? -len : len; // if not eoln and buffer full, negate len...
}


/* *******************************************************************
******************************************************************* */
int sfile::speek() {

   return (ptr >= data+size) ? EOF : *ptr;
}


/* *******************************************************************
   Note: the way this works, '\' and '/' cannot be part of a filename or
      path...  *shrug*
   Note: may improve performance to use access() instead of fopen() for
      initial search for file.  Not sure how this affects creating a new
      file
   Note: using stat() can get info on file - directory ?,
      read/write status, etc
******************************************************************* */
int find_file(char *filename, char *oflags, char *envstr, char slash, char *out, FILE **infile) {

   FILE *ifile;
   char token[MAXSTRLEN];
   string_type basestr;
   int i, j;
   char *ptr;
   char altslash, altseparator, separator;
   string_type path;
   
   if (!filename || !filename[0])
      return 0;

   if (slash == '\\') {
      altslash = '/';
      altseparator = ':';
      separator = ';';
   }
   
   else {
      altslash = '\\';
      altseparator = ';';
      separator = ':';
   }
   
   strcpy(token, filename);

   for (ptr=token; *ptr; ptr++)
      if (*ptr == altslash)
         *ptr = slash;
      else if (*ptr == altseparator)
         *ptr = separator;

   ifile = fopen(token, oflags);

   if (ifile) {

      if (out)
         strcpy(out, token);

      if (infile)
         *infile = ifile;
      else
         fclose(ifile);
	 
      return 1;
   }
   
   if (!envstr || !envstr[0] || !slash)
      return 0;

   // extract path list            
   ptr = getenv(envstr);

   if (!ptr)
      return 0;

   path.stringcpy(ptr);
   for (ptr=path.string; *ptr; ptr++)
      if (*ptr == altslash)
         *ptr = slash;
      else if (*ptr == altseparator)
         *ptr = separator;
	 
   // extract base filename
   for (i=strlen(token)-1; i; i--)
      if (token[i] == slash || token[i] == separator) {
         i++;
         break;
      }

   basestr.stringcpy(&token[i]);

   // check each combination
   i=0;
    
   while (path.string[i]) {

      for (j=0; path.string[i] && path.string[i] != separator; j++, i++)
         token[j] = path.string[i];
	 
      if (path.string[i] == separator)
         i++;
	  
      if (j && token[j-1] != slash) {
         token[j] = slash;
         j++;
      }

      token[j] = 0;   

      strcat(token, basestr.string);

      ifile = fopen(token, oflags);
   
      if (ifile) {

         if (out)
            strcpy(out, token);
	    
         if (infile)
            *infile = ifile;
         else
            fclose(ifile);

         return 1;
      }
  
   }

   return 0;         
}


