

#include "basic_dt.h"


/* *******************************************************
******************************************************* */
void circular_dbl_llist::insert(dbl_llist *x) {

   x->next = this;
   x->back = back;

   back->next = x;
   back = x;
}


/* *******************************************************
******************************************************* */
void circular_dbl_llist::append(dbl_llist *x) {

   x->next = next;
   x->back = this;

   next->back = x;
   next = x;
}


/* *******************************************************
******************************************************* */
void circular_dbl_llist::remove() {

   back->next = next;
   next->back = back;

   next = back = NULL;
}


/* *******************************************************
******************************************************* */
void circular_dbl_llist_manager::dest() {
   
   dbl_llist *ptr;

   if (head) {
      head->back->next = NULL;

      while (head) {
         ptr = head;
         head = (circular_dbl_llist *)head->next;
         ptr->next = NULL;
         delete ptr;
      }

   }

   head = NULL;
   count = 0;
}


/* *******************************************************
******************************************************* */
circular_dbl_llist *circular_dbl_llist_manager::insert(circular_dbl_llist *x, circular_dbl_llist *target) {

   count++;
   
   if (!target) {
      if (!head) {
         head = x;
         x->next = x->back = x;
         return x;
      }

      head->insert(x);
      return x;
   }

   target->insert(x);
   return x;
}

	
/* *******************************************************
******************************************************* */
circular_dbl_llist *circular_dbl_llist_manager::append(circular_dbl_llist *x, circular_dbl_llist *target) {

   count++;
   
   if (!target) {
      if (!head) {
         head = x;
         x->next = x->back = x;
         return x;
      }

      head->insert(x);
      return x;
   }

   target->append(x);
   return x;
}


/* *******************************************************
******************************************************* */
int circular_dbl_llist_manager::remove(circular_dbl_llist *x) {

   count--;
   
   if (head == x) {
      if (head->next == head)	{
         head = NULL;
         x->next = x->back = NULL;
         return 1;
      }

      head = (circular_dbl_llist *)head->next;
   }

   x->remove();
   return 1;
}


