

#include "basic_dt.h"


/* **************************************************************
************************************************************** */
binary_node::~binary_node() {

   if (key)
      delete key;
      
   if (next)
      delete next;
      
   if (back)
      delete back;
}


/* **************************************************************
   Assumes "x" is a single node - no children
************************************************************** */
binary_node *binary_node::insert(binary_node *x) {

   binary_node *ptr;
   int i;
   
   i = key->compare(x->key);
   
   if (i < 0)
      return next ? next->insert(x) : next = x;
   
   if (i > 0)
      return back ? back->insert(x) : back = x;
   
   if (x->next) {
      x->remove(ptr = x->next);
      insert(ptr);
   }
	 
   if (x->back) {
      x->remove(ptr = x->back);
      insert(ptr);
   }

   delete x;
   return this;
}


/* **************************************************************
************************************************************** */
int binary_node::remove(binary_node *x) {

   int i;
   
   i = key->compare(x->key);

   if (i < 0) { 
      if (!next)
         return 0;

      if (next != x)
         return next->remove(x);

      if (x->back) {
         next = x->back;
         x->back = NULL;

         if (x->next) {
            next->insert(x->next);
            x->next = NULL;
         }
	 
         return 1;
      }

      next = x->next;
      x->next = NULL;
      return 1;
   }
      
   if (i > 0) {   
      if (!back)
         return 0;

      if (back != x)
         return back->remove(x);

      if (x->back) {
         back = x->back;
         x->back = NULL;

         if (x->next) {
            back->insert(x->next);
            x->next = NULL;
         }
	 
         return 1;
      }

      back = x->next;
      x->next = NULL;
      return 1;
   }
	 
   return 0;  // shouldnt be here... equals - handled by parent
}


/* **************************************************************
************************************************************** */
binary_node *binary_node::find(binary_data *x) {

   int i;
   
   i = key->compare(x);

   if (i < 0)
      return next ? next->find(x) : NULL;

   if (i > 0)
      return back ? back->find(x) : NULL;

   return this;
}


/* **************************************************************
************************************************************** */
binary_node *binary_tree::insert(binary_node *x) {

   return head ? head->insert(x) : head = x;
}


/* **************************************************************
************************************************************** */
int binary_tree::remove(binary_node *x) {

   if (!head)
      return 0;
      
   if (x != head)
      return head->remove(x);

   if (x->back) {
      head = x->back;
      x->back = NULL;

      if (x->next) {
         head->insert(x->next);
         x->next = NULL;
      }
	 
      return 1;
   }

   head = x->next;
   x->next = NULL;
   return 1;
}


/* **************************************************************
************************************************************** */
binary_node *binary_tree::find(binary_data *x) {

   return head ? head->find(x) : NULL;
}
