
#include "sbfast.h"
#include "shaders.h"


/* *************************************************************
  calculate level of detail, based on distance from eye
                run, chase, sbfast pics

        pt[0] - distance
        in - pos;
        octaves - octave_scalar
        out[0] - height

#define SBSCALE 0.0063596645
#define SCALESB 157.241

************************************************************* */
int default_alt(void *x) {

   shaderparamtype *data = (shaderparamtype *)x;
   float octaves;

//      octaves truncated from 0-3

   octaves = data->params.octaves;

   if (data->pt[0] < 1)
      data->params.octaves = -data->params.octaves + 0.5f;
   else
      data->params.octaves = (float)(-(data->params.octaves + LOG2(data->pt[0])) + 0.5);

                                                // use any fBm function
   data->out[0] = RidgedMultifractal2(data->in, &data->params, 1.0, 2.0) -1;  // altitude - mountains

   data->params.octaves = octaves;
   return 1;
}


/* *************************************************************
  calculate level of detail, based on distance from eye
                run, chase, sbfast pics

        pt[0] - distance
        in - pos;
        octaves - octave_scalar
        out[0] - height

#define SBSCALE 0.0063596645
#define SCALESB 157.241
        same shader as default_alt, but no restriction on octaves
************************************************************* */
int x_alt(void *x) {

   shaderparamtype *data = (shaderparamtype *)x;
   float octaves;
   float dist;

   octaves = data->params.octaves;

   dist = data->pt[0];
   octaves = (float)(-(data->params.octaves + LOG2(dist))+0.5);

   if (octaves < 0)
      octaves = 0;
                                                // use any fBm function
   data->out[0] = RidgedMultifractal2(data->in, &data->params, 1.0, 2.0) -1;  // altitude - mountains

   data->params.octaves = octaves;
   return 1;
}


/* *************************************************************
************************************************************* */
int bound_mnb_alt(void *x) {

   float octaves;

   shaderparamtype *data = (shaderparamtype *)x;

   octaves = data->params.octaves;

   data->params.octaves = -data->params.octaves + 0.5f;

   bound_RidgedMultifractal2(&data->params, 1.0, &data->min, &data->max);
   data->min -= 1.0;
   data->max -= 1.0;

   data->params.octaves = octaves;
   return 1;
}


/* *************************************************************
  calculate level of detail, based on distance from eye
                "dip" for road

#define SBSCALE 0.0063596645
#define SCALESB 157.241

************************************************************* */
int mnb_alt(void *x) {

   shaderparamtype *data = (shaderparamtype *)x;
   float octaves;
   float dist;

   float road;
   float edge;

   road = 0.31798322f;           // sbscale * 50
   edge = (float)fabs(data->in[0]);

   if (edge < road) {           // road 50+ units wide
      data->out[0] = 0;
      return 1;
   }

   // octaves truncated to range 0..3
   dist = ((data->pt[0] < 1) ? 1 : data->pt[0]);

   octaves = data->params.octaves;

   data->params.octaves = (float)(-(data->params.octaves + LOG2(dist))+0.5);

   if (data->params.octaves < 0)
      data->params.octaves = 0;

   if (edge < road+road)
      dist = edge/road - 1.0f;
   else
      dist = 1;
                                                // use any fBm function
   data->out[0] = dist*(RidgedMultifractal2(data->in, &data->params, 1.0, 2.0)-1);  // altitude - mountains

   data->params.octaves = octaves;
   return 1;
}


/* *************************************************************

        suggested params:

                H = 0.2765
                lacunarity = 2.0
                octaves = 6

************************************************************* */
int barfland_alt(void *x) {

   shaderparamtype *data = (shaderparamtype *)x;
   vector3f p;
   float octaves;
   sbfast *ob;

   octaves = data->params.octaves;

   ob = (sbfast *)data->ob;
   data->params.octaves = ob->query_octaves();

   p[0] = data->in[1] * 0.002f;
   p[1] = data->in[0] * 0.002f;

   p[2] = 0;
                                        // use any fBm function
   p[2] = fBm(p, &data->params);        // altitude - mountains

   data->out[0] = (float)(20 + fabs(p[2]) * p[2] * (300 - (data->in[0] + data->in[1] + 1000.0)*0.099009901));

   data->params.octaves = octaves;
   return 1;
}

