
#include "shader.h"
#include "shaders.h"


// -------------------------- ATMOSPHERE ---------------------------


/***************************************************************************
        note: this is an alpha blending shader - should be the last
                shader called...
****************************************************************************/
int fog_mus(void *x) {

   vector3f ray_dir;
   float t_e;                           // distance to object (i think)
   vector3f alpha;
   float beta;
   float bsqrt;
   float b = 1;                         // fallout w/ altitude
   float a = 0.5;                       // average fog density
   float near_val, far_val;
   vector3f origin = {0, 0, -100};
   float rc_square;
   vector3f tau;

   shaderparamtype *data;

   data = (shaderparamtype *)x;

                // compute distance from fog origin to rays closest approach
   alpha[0] = -origin[0];
   alpha[1] = -origin[1];
   alpha[2] = -origin[2];

   copyarray3(ray_dir, data->pt);

   t_e = normalize3(ray_dir);

   beta = dotproduct3(ray_dir, alpha);    // calc fallout w/ altitude
   beta = (float)fabs(beta);

   bsqrt = (float)sqrt(b);
   near_val = (float)erf(bsqrt*beta);
   far_val = (float)erf(bsqrt*(beta+t_e));

                // comput dist from fog origin to rays closest approach

   rc_square = dotproduct3(alpha, alpha) - beta*beta;

   tau[0] = (float)((a*exp(-b*rc_square)*(far_val-near_val))/bsqrt);
   tau[1] = tau[0]*2.25f;
   tau[2] = tau[0]*21.0f;

   tau[0] = (float)exp(-tau[0]);
   tau[1] = (float)exp(-tau[1]);
   tau[2] = (float)exp(-tau[2]);

   data->out[0] = data->out[0]*tau[0] + (1-tau[0]);     // alpha blend color with white
   data->out[1] = data->out[1]*tau[1] + (1-tau[1]);     // alpha blend color with white
   data->out[2] = data->out[2]*tau[2] + (1-tau[2]);     // alpha blend color with white

   return 1;
}


/***************************************************************************
        note: this is an alpha blending shader - should be the last
                shader called...
                based on height
****************************************************************************/
int fog(void *x) {

   float b = 0.007f;                      // fallout w/ altitude
   float a = 0.0004f;                     // average fog density
   float tau, taui;
   float distance;
   float height;

   shaderparamtype *data;

   data = (shaderparamtype *)x;

   height = (float)fabs(data->pt[1]);

   distance = (float)magnitude3(data->pt);

   tau = (float)(a*distance*exp(-b*height));
   if (tau > 1.0)
      tau = 1.0;

   taui = 1.0f - tau;

   saddarray3(data->add, tau);

   data->out[0] = data->out[0]*taui;     // alpha blend color with white
   data->out[1] = data->out[1]*taui;     // alpha blend color with white
   data->out[2] = data->out[2]*taui;     // alpha blend color with white

   return 1;
}


/***************************************************************************
        note: this is an alpha blending shader - should be the last
                shader called...

        based on distance
****************************************************************************/
int fog2(void *x) {

   float a = 0.0004f;                     // average fog density
   float tau, taui;
   float distance;

   shaderparamtype *data;

   data = (shaderparamtype *)x;

   distance = (float)magnitude3(data->pt);

   tau = (float)exp(-a*distance);

   if (tau > 1.0)
      tau = 1.0;

   taui = 1.0f - tau;

   saddarray3(data->add, taui);

   smultarray3(data->out, tau);	// alpha blend color w/ white

   return 1;
}

/***************************************************************************
        note: this is an alpha blending shader - should be the last
                shader called...

        based on distance
****************************************************************************/
int nightfog2(void *x) {

   float a = 0.0004f;                     // average fog density
   float tau;
   float distance;

   shaderparamtype *data;

   data = (shaderparamtype *)x;

   distance = (float)magnitude3(data->pt);

   tau = (float)exp(-a*distance);

   if (tau > 1.0)
      tau = 1.0;

   smultarray3(data->out, tau);	// alpha blend color w/ white

   return 1;
}
