

#include "polyops.h"


/* **************************************************************
************************************************************** */
void vertex_type::copy(vertex_type *x) {

   vertex_index = x->vertex_index;
   copyarray3(normal, x->normal);
   copyarray2(uv, x->uv);
   concaveflag = x->concaveflag;
}


/* **************************************************************
************************************************************** */
int vertex_type::vsimilar(vertex_type *x, int texflag) {

   return (vertex_index == x->vertex_index && (!texflag || (fabs(uv[0]-x->uv[0]) < CORRECT && fabs(uv[1]-x->uv[1]) < CORRECT)));
}


/* **************************************************************
************************************************************** */
int vertex_type::query_between(int i, vector3f *verts) {

   vector3f v1, v2;
   float c, s, l;

   if (i == vertex_index || i == ((vertex_type *)next)->vertex_index)
      return 1;
      
   subeqarray3(v1, verts[i], verts[vertex_index]);
   subeqarray3(v2, verts[((vertex_type *)next)->vertex_index], verts[i]);

   l = dotproduct3(v1, v1)*dotproduct3(v2, v2);

   c = (float)(dotproduct3(v1, v2)/sqrt(l));
   s = 1 - c*c;
   if (s < 0)
      s = 0;
      
   return (c > COS_FIVE_DEG && 0.25*s*l < MIN_POLY_AREA*MIN_POLY_AREA);
}


/* **************************************************************
************************************************************** */
void vertex_manager::clone_list(vertex_manager *vman) {

   vertex_type *ptr, *qtr;
	
   vman->dest();

   if (!head)
      return;

   vman->insert(ptr = new vertex_type, NULL);
   ptr->copy((vertex_type *)head);

   for (ptr=((vertex_type *)head->next); ptr!=head; ptr=((vertex_type *)ptr->next)) {
      vman->insert(qtr = new vertex_type, NULL);
      qtr->copy(ptr);
   }

}


/* **************************************************************
************************************************************** */
vertex_type *vertex_manager::find(int x) {

   vertex_type *ptr;

   if (!head)
      return NULL;

   if (((vertex_type *)head)->vertex_index == x)
      return (vertex_type *)head;

   for (ptr = ((vertex_type *)head->next); ptr != head; ptr=((vertex_type *)ptr->next))
      if (ptr->vertex_index == x)
         return ptr;
	
   return NULL;
}


/* **************************************************************
************************************************************** */
int vertex_manager::find(vertex_type *x) {

   vertex_type *ptr;

   if (!head)
      return 0;

   if ((vertex_type *)head == x)
      return 1;

   for (ptr = ((vertex_type *)head->next); ptr != head; ptr=((vertex_type *)ptr->next))
      if (ptr == x)
         return 1;
	
   return 0;
}


/* **************************************************************
************************************************************** */
circular_dbl_llist * vertex_manager::append(circular_dbl_llist *x, circular_dbl_llist *target) {

   if (find((vertex_type *)x) || (target && !find((vertex_type *)target)))
      return NULL;

   return circular_dbl_llist_manager::append(x, target);
}


/* **************************************************************
************************************************************** */
circular_dbl_llist * vertex_manager::insert(circular_dbl_llist *x, circular_dbl_llist *target) {

   if (find((vertex_type *)x) || (target && !find((vertex_type *)target)))
      return NULL;

   return circular_dbl_llist_manager::insert(x, target);
}


/* ******************************************************************************************
****************************************************************************************** */
void vertex_manager::affinemap(vector2f *uv, vector3f *verts) {

   vector3f v1, mxu, mxv;
   vertex_type *vtr;

   ((vertex_type *)head)->uv[0] = uv[0][0];
   ((vertex_type *)head)->uv[1] = uv[0][1];

   ((vertex_type *)head->next)->uv[0] = uv[1][0];
   ((vertex_type *)head->next)->uv[1] = uv[1][1];

   ((vertex_type *)head->next->next)->uv[0] = uv[2][0];
   ((vertex_type *)head->next->next)->uv[1] = uv[2][1];

   map_3D_2D(verts[((vertex_type *)head)->vertex_index], verts[((vertex_type *)head->next)->vertex_index],
             verts[((vertex_type *)head->next->next)->vertex_index], ((vertex_type *)head)->uv, ((vertex_type *)head->next)->uv, ((vertex_type *)head->next->next)->uv, mxu, mxv);

   for (vtr=(vertex_type *)head->next->next->next; vtr != (vertex_type *)head; vtr=(vertex_type *)vtr->next) {
      subeqarray3(v1, verts[vtr->vertex_index], verts[((vertex_type *)head)->vertex_index]);

      vtr->uv[0] = dotproduct3(v1, mxu) + ((vertex_type *)head)->uv[0];
      vtr->uv[1] = dotproduct3(v1, mxv) + ((vertex_type *)head)->uv[1];
   }

}


/* ******************************************************************************************
****************************************************************************************** */
void vertex_manager::calc_uv(vector3f *verts) {

   vector3f u, v, v1, v2;
   float *xy0, *p1, *p2;

   vertex_type *vtr;
   float a, s, t;

   vector3f ov1, ov2;
   vector3f q;
   vector3f mxu, mxv;

   if (count < 4)
      return;

   subeqarray2(u, ((vertex_type *)head->back->back)->uv, ((vertex_type *)head->back)->uv);
   subeqarray2(v, ((vertex_type *)head->back->back->back)->uv, ((vertex_type *)head->back->back)->uv);

   xy0 = verts[((vertex_type *)head->back)->vertex_index];
   p1 = verts[((vertex_type *)head->back->back)->vertex_index];
   p2 = verts[((vertex_type *)head->back->back->back)->vertex_index];

   subeqarray3(v2, p2, p1);
   subeqarray3(v1, p1, xy0);

								// orthonormal basis for xyz space
   a = 1.0f/dotproduct3(v1, v1);
   t = dotproduct3(v1, v2)*a;

   ov1[0] = v2[0] - t*v1[0];
   ov1[1] = v2[1] - t*v1[1];
   ov1[2] = v2[2] - t*v1[2];

   s = 1.0f/dotproduct3(ov1, ov1);

   ov1[1] = (v[0] - t*u[0])*s;
   ov2[1] = (v[1] - t*u[1])*s;

   ov1[0] = u[0]*a - ov1[1]*t;
   ov2[0] = u[1]*a - ov2[1]*t;

   mxu[0] = ov1[0]*v1[0] + ov1[1]*v2[0];
   mxu[1] = ov1[0]*v1[1] + ov1[1]*v2[1];
   mxu[2] = ov1[0]*v1[2] + ov1[1]*v2[2];

   mxv[0] = ov2[0]*v1[0] + ov2[1]*v2[0];
   mxv[1] = ov2[0]*v1[1] + ov2[1]*v2[1];
   mxv[2] = ov2[0]*v1[2] + ov2[1]*v2[2];

   for (vtr=(vertex_type *)head->back->back->back->back; vtr != (vertex_type *)head->back; vtr=(vertex_type *)vtr->back) {
      subeqarray3(q, verts[vtr->vertex_index], xy0);

      vtr->uv[0] = dotproduct3(q, mxu) + ((vertex_type *)head->back)->uv[0];
      vtr->uv[1] = dotproduct3(q, mxv) + ((vertex_type *)head->back)->uv[1];
   }

}


/* ******************************************************************************************
****************************************************************************************** */
int vertex_manager::calc_vnormal(vector3f *verts) {

   vertex_type *vtr;

   if (count < 3)
      return 0;

   vtr = (vertex_type *)head;

   do {
      calculate_normal(verts[((vertex_type *)vtr->next)->vertex_index], verts[vtr->vertex_index], verts[((vertex_type *)vtr->back)->vertex_index], vtr->normal);
      vtr = (vertex_type *)vtr->next;
   } while (vtr != (vertex_type *)head);

   return 1;
}


/* ******************************************************************************************
****************************************************************************************** */
int vertex_manager::validate(vector3f *verts) {

   if (count >= 3)
      return 1;

   dest();
   return 0;
}


/* ******************************************************************************************
****************************************************************************************** */
void vertex_manager::triangle(vertex_type *btr, vertex_type *ptr, vertex_type *ntr) {

   vertex_type *vtr;

   dest();

   insert(vtr = new vertex_type, NULL);
   vtr->copy(btr);

   insert(vtr = new vertex_type, NULL);
   vtr->copy(ptr);

   insert(vtr = new vertex_type, NULL);
   vtr->copy(ntr);
}


