

#ifdef WIN32
#include "WIN_W32.h"
#else
#include <string.h>

#include "WIN_X.h"
#endif

#define VERTEXSHIFT 4

#include "global.h"
#include "pstring.h"

#include "polyops.h"


int QUADLEVEL = 3;


/* *****************************************************************************
***************************************************************************** */
void virtual_object::init() {

   if (optimize)
      delete optimize;

   optimize = new optimizer;
};


/* *****************************************************************************
***************************************************************************** */
int virtual_object::build_triangle_list(dbl_llist_manager *faceman) {

   face_work_type *ptr, *qtr;
   vertex_type *vtr;
   float *p1, *p2, *p3;
   vector3f v1, v2;
   int flag;
   float work;
   dbl_llist_manager man;

   for (ptr = (face_work_type *)optimize->final_face_data.head; ptr; ptr = (face_work_type *)ptr->next) {

      if (ptr->vlist.count <3)
         continue;

      flag = 0;
      vtr = (vertex_type *)ptr->vlist.head;

      do {
         p1 = optimize->vertex_data[vtr->vertex_index];
         p2 = optimize->vertex_data[((vertex_type *)vtr->next)->vertex_index];
         p3 = optimize->vertex_data[((vertex_type *)vtr->next->next)->vertex_index];

         subeqarray3(v1, p2, p1);
         subeqarray3(v2, p3, p2);

         work = dotproduct3(v1, v2);
         if (work*work < 0.999*dotproduct3(v1, v1)*dotproduct3(v2, v2)) {
            flag = 1;
            break;
         }

         vtr = (vertex_type *)vtr->next;
      } while (vtr != (vertex_type *)ptr->vlist.head);

      if (flag) {
         calculate_normal(p3, p2, p1, ptr->face_normal);
         ptr->triangulate(optimize->vertex_data, &man);

         while (man.head) {
            man.remove(qtr = (face_work_type *)man.head);
            faceman->insert(qtr, NULL);
         }

      }

      else
         pprintf("Warning: Unable to calculate a face normal - REMOVED\n");
   }

   optimize->final_face_data.dest();

   return faceman->count;
}


/* *****************************************************************************
***************************************************************************** */
int SPXobject::build_texture_list() {

   int i, j;
   int texflag = 0;
   char *buffer;

   texture_count = shade_count;

   if (texture_list)
      delete [] texture_list;

   texture_list = new texture[texture_count];

   for (i=0; i < texture_count; i++)
      if (shade[i].texname.string[0]) {
         texflag = 1;
         buffer = shade[i].texname.string;
    
         for (j=strlen(buffer)-1; j > -1; j--)
            if (buffer[j] == '\\' || buffer[j] == ':' || buffer[j] == '/')
               break;

         texture_list[i].dataname.stringcpy(&buffer[j+1]);
      }
      

   if (!texflag) {
      delete [] texture_list;
      texture_list = NULL;
      return 0;
   }
   
   return 1;
}


/* *****************************************************************************
***************************************************************************** */
int SPXobject::postprocess_uv() {

   return build_texture_list();
}


/* *****************************************************************************
***************************************************************************** */
SPXobject::SPXobject() {

   shade = NULL;
   texture_list = NULL;
}


/* *****************************************************************************
***************************************************************************** */
void SPXobject::init() {

   virtual_object::init();

   if (shade) {
      delete [] shade;
      shade = NULL;
   }

   if (texture_list) {
      delete [] texture_list;
      texture_list = NULL;
   }

}


/* *****************************************************************************
***************************************************************************** */
SPXobject::~SPXobject() {

   if (shade)
      delete [] shade;
      
   if (texture_list)
      delete [] texture_list;
}


/* *****************************************************************************
***************************************************************************** */
spheretype *SPXobject::Build_COL(polytype *ob) {

   spheretype *sob;
   int i, count;
   sphere_block *sblock;

   ob->calc_normal();
   sob = build_quadspheres(ob, QUADLEVEL);

   if (!sob) {
      pprintf("Error building collision data...\n");
      return NULL;
   }

   sblock = (sphere_block *)sob->query_data();

   for (i=count=0; i<sblock->countsphere; i++)
      if (!sblock->slist[i].level)
         count += sblock->slist[i].count;

   sprintf(perror_buffer, "%d spheres %d face indicies %d faces", sblock->countsphere, count, ob->countobject);
   mbprintf(perror_buffer);

   return sob;
}


/* *****************************************************************************
***************************************************************************** */
polytype *SPXobject::Build_SPG() {

   polytype *ob;
   polygon_object_type *pot;
   face_work_type *ftr;
   int *iptr;
   int i, j;
   vertex_type *vtr;

   for (i=0, ftr=(face_work_type *)optimize->final_face_data.head; ftr; ftr=(face_work_type *)ftr->next)
      i += ftr->vlist.count;

   if (!i)
      return NULL;

   ob = new polytype;
   ob->build(optimize->vertexcount, optimize->final_face_data.count, i);
   pot = (polygon_object_type *)ob->query_data();

   for (i=0; i<ob->countvertex; i++) {
      copyarray3(pot->vlist[i], optimize->vertex_data[i]);
      pot->vlist[i][3] = 1.0f;
   }

   for (i=0, iptr=pot->vindex, ftr=(face_work_type *)optimize->final_face_data.head; ftr; i++, ftr=(face_work_type *)ftr->next) {
      pot->flist[i].polynum = ftr->vlist.count;
      pot->flist[i].edgeptr = iptr;
      iptr += pot->flist[i].polynum;

      // list is counterclock - want clock
      for (j=0, vtr=(vertex_type *)ftr->vlist.head; j < pot->flist[i].polynum; j++, vtr=(vertex_type *)vtr->back)
         pot->flist[i].edgeptr[j] = vtr->vertex_index;
   }

   return ob;
}


/* *****************************************************************************
***************************************************************************** */
shadelist *SPXobject::Build_ILM() {

   shadelist *current;
   int *index;
   shade_block *sblock;
   int *itr;
   int i, j;
   face_work_type *ftr;
   int base;
   shadetype **pindex;
   int pcount;

   if (!shade_count)
      return NULL;
   
   // build index;
   index = new int[shade_count];

   pcount = 0;
   pindex = new shadetype *[shade_count];

   for (i=0; i<shade_count; i++) {
      for (j=0; j<pcount; j++)
         if (!shade[i].ilm.matcmp(pindex[j])) {
            index[i] = j;
            break;
         }
       
      if (j < pcount)
         continue;
 
      index[i] = pcount;
      pindex[pcount] = &shade[i].ilm;
      pcount++;
   }

   // find most common used material
   itr = new int[pcount];

   memset(itr, 0, pcount*sizeof(int));

   for (ftr=(face_work_type *)optimize->final_face_data.head; ftr; ftr=(face_work_type *)ftr->next)
      itr[index[ftr->material_index]]++;

   for (i=pcount-2, base=pcount-1; i > -1; i--)
      if (itr[i] > itr[base])
         base = i;

   delete [] itr;

   current = new shadelist;

   current->replace_data(sblock = new shade_block);

   sblock->shade_palette = new shadetype[sblock->shade_count = pcount];

   memcpy(&sblock->shade_palette[0], pindex[base], sizeof(shadetype));
   memcpy(&current->base, &sblock->shade_palette[0], sizeof(shadetype));

   // write others
   for (i=0,j=1; i<pcount; i++)
      if (i!=base) {
         memcpy(&sblock->shade_palette[j], pindex[i], sizeof(shadetype));
         j++;
      }

   sblock->index_palette = new int[sblock->index_count = optimize->final_face_data.count];

   for (ftr=(face_work_type *)optimize->final_face_data.head, i=0; ftr; ftr=(face_work_type *)ftr->next, i++)
      if (index[ftr->material_index] == base)
         sblock->index_palette[i] = 0;
      else if (index[ftr->material_index] < base)
         sblock->index_palette[i] = index[ftr->material_index]+1;
      else
         sblock->index_palette[i] = index[ftr->material_index];

   delete [] index;
   delete [] pindex;
   return current;
}


/* *****************************************************************************
***************************************************************************** */
texpolygon *SPXobject::Build_TEX(polytype *ob) {
   
   texpolygon *tob;
   int i, j;
   face_work_type *ftr;
   vector2f uv[3];

   // build texture object
   tob = new texpolygon;
   tob->setup(optimize->final_face_data.count);
      
   for (ftr=(face_work_type *)optimize->final_face_data.head, i=0; ftr; ftr=(face_work_type *)ftr->next, i++) {
      if (!ftr->textureflag)
         continue;

      j = texture_count ? ftr->material_index : 0;

      if (!texture_list[j].dataname.string[0])
         continue;

      copyarray2(uv[0], ((vertex_type *)ftr->vlist.head)->uv);
      copyarray2(uv[1], ((vertex_type *)ftr->vlist.head->back)->uv);
      copyarray2(uv[2], ((vertex_type *)ftr->vlist.head->back->back)->uv);
      
      tob->affinemap(i, uv, &texture_list[j], ob, 0);
   }      

   return tob;
}


/* *****************************************************************************
***************************************************************************** */
int SPXobject::Import_SPG(polytype *ob) {

   int i, j;
   face_work_type *ftr;
   vertex_type *vtr;
   string_type buffer;
   polygon_object_type *pot;

   if (!ob->countvertex || !ob->countobject || !ob->countedge) {
      buffer.stringcpy(&ob->dataname);
      buffer.stringcat("is an invalid .spg file");
      mbprintf(buffer.string);
      return 0;
   }

   optimize->vertexcount = ob->countvertex;

   optimize->vertex_data = new vector3f[optimize->vertexcount << VERTEXSHIFT];
   pot = (polygon_object_type *)ob->query_data();
   
   for (i=0; i<optimize->vertexcount; i++)
      copyarray3(optimize->vertex_data[i], pot->vlist[i]);

   for (i=0; i<ob->countobject; i++) {

      optimize->final_face_data.append(ftr = new face_work_type, NULL);

      for (j = pot->flist[i].polynum-1; j > -1; j--) {
         ftr->vlist.insert(vtr = new vertex_type, NULL);
         vtr->vertex_index = pot->flist[i].edgeptr[j];
      }

   }

   return 1;
}


/* *****************************************************************************
***************************************************************************** */
int SPXobject::Import_ILM(shadelist *lob, int countobject) {

   shade_block *sblock;
   int i;

   sblock = (shade_block *)lob->query_data();

   for (i=0; i<sblock->index_count; i++)
      memcpy(&shade[i].ilm, &sblock->shade_palette[sblock->index_palette[i]], sizeof(shadetype));

   for (; i<countobject; i++)
      memcpy(&shade[i].ilm, &sblock->shade_palette[0], sizeof(shadetype));

   return 1;
}


/* *****************************************************************************
***************************************************************************** */
int SPXobject::Import_TEX(texpolygon *tob) {

   int i;
   face_work_type *ftr;
   vector2f uv[3];
   texface *tblock = (texface *)tob->query_data();

   if (!tblock)
      return 0;

   for (i=0, ftr=(face_work_type *)optimize->final_face_data.head; ftr; i++, ftr=(face_work_type *)ftr->next) {
      if (!tblock[i].ob)
         continue;

      tob->query_uvmap(i, ftr->vlist.count-1, uv[0]);
      tob->query_uvmap(i, ftr->vlist.count-2, uv[1]);
      tob->query_uvmap(i, ftr->vlist.count-3, uv[2]);

      ftr->affinemap(uv, optimize->vertex_data);

      shade[i].texname.stringcpy(&tblock[i].ob->dataname);
   }

   return 1;
}
