

#ifdef WIN32
#include "WIN_W32.h"
#else
#include "WIN_X.h"
#endif

#include "global.h"
#include "pstring.h"
#include "spb_load.h"

#include "polyops.h"


/* *****************************************************************************
***************************************************************************** */
int write_spg(char *basename, SPXobject *spxob) {

   string_type spgname, uvname, colname, ilmname;
   polytype *ob;
   texpolygon *uv = NULL;
   spheretype *sob = NULL;
   shadelist *lob = NULL;
   int ret;
   spg2_loader loader;

   ob = spxob->Build_SPG();
   
   if (!ob)
      return 0;

   spgname.stringcpy(basename);
   spgname.stringcat(".spg");      
 
   if (gilm) {
      lob = spxob->Build_ILM();
      if (lob) {
         ilmname.stringcpy(basename);
         ilmname.stringcat(".ilm");      
      }

   }

   if (gtex && spxob->postprocess_uv()) {
      uv = spxob->Build_TEX(ob);
      if (uv) {
         uvname.stringcpy(basename);
         uvname.stringcat(".tex");      
      }

   }

   if (gcol) {
      sob = spxob->Build_COL(ob);
      if (sob) {
         colname.stringcpy(basename);
         colname.stringcat(".col");      
      }

   }

   ret = loader.write_data(spgname.string, ob, ilmname.string, lob, uvname.string, uv, NULL, NULL, colname.string, sob);

   delete ob;
   
   if (lob)
      delete lob;
      
   if (uv)
      delete uv;
      
   if (sob)
      delete sob;
      
   return ret;
}


/* *****************************************************************************
***************************************************************************** */
int read_spg(char *basename, SPXobject *spxob) {

   string_type buffer;
   char buffer2[MAXSTRLEN];
   face_work_type *ftr;
   int i;
   spg_loader loader;
   polytype *ob;
   shadelist *lob;
   texpolygon *tob;
   sfile sinfile;

   global_resource_manager->reset();

   buffer.stringcpy(basename);
   buffer.stringcat(".spg");

   if (!sinfile.scan_data(buffer.string, OBJECT_PATH.string,(char)PLATFORM_SLASH)) {
      sprintf(perror_buffer, "Warning: \"%s\" not found...\n", buffer.string);
      pprintf(perror_buffer);
      return 0;
   }

   if (!loader.find_loader(&sinfile) || !loader.read_data()) {
      sprintf(buffer2, "Invalid .spg file: \"%s\"", buffer.string);
      mbprintf(buffer2);
      return 0;
   }
   
   ob = (polytype *)loader.extract(FILETYPE_SPG, buffer.string);

   if (!ob) {
      sprintf(buffer2, "Invalid .spg file: \"%s\"", buffer.string);
      mbprintf(buffer2);
      return 0;
   }

   spxob->init();

   spxob->shade = new mtllist[spxob->shade_count = ob->countobject];

   buffer.stringcpy(basename);
   buffer.stringcat(".ilm");

   lob = (shadelist *)loader.extract(FILETYPE_ILM, buffer.string);
   if (!lob) {
      sprintf(buffer2, "Warning: Invalid .ilm file: \"%s\"", buffer.string);
      mbprintf(buffer2);
   }

   buffer.stringcpy(basename);
   buffer.stringcat(".tex");

   tob = (texpolygon *)loader.extract(FILETYPE_TEX, buffer.string);

   loader.cleanup();

   if (!spxob->Import_SPG(ob))
      return 0;

   if (lob)
      spxob->Import_ILM(lob, ob->countobject);
      
   if (tob)
      spxob->Import_TEX(tob);

   for (ftr = (face_work_type *)spxob->optimize->final_face_data.head->next, i = 1; ftr; ftr=(face_work_type *)ftr->next, i++)
      ftr->material_index = spxob->shade[0].insert(&spxob->shade[i]);

   return 1;
}


/* *****************************************************************************
***************************************************************************** */
int write_spb(char *basename, SPXobject *spxob) {

   string_type filename;
   spb_loader loader;

   polytype *ob;
   texpolygon *uv;
   spheretype *sob;
   shadelist *lob;
   int ret;

   ob = spxob->Build_SPG();

   if (!ob)
      return 0;
      
   lob = gilm ? spxob->Build_ILM() : (shadelist *)NULL;
   uv  = (gtex && spxob->postprocess_uv()) ? spxob->Build_TEX(ob) : (texpolygon *)NULL;
   sob = gcol ? spxob->Build_COL(ob) : (spheretype *)NULL;

   filename.stringcpy(basename);
   filename.stringcat(".spb");
   ret = loader.write_data(filename.string, ob, lob, uv, NULL, sob);

   delete ob;
   
   if (lob)
      delete lob;
      
   if (uv)
      delete uv;
      
   if (sob)
      delete sob;
      
   return ret;
}


/* *****************************************************************************
***************************************************************************** */
int read_spb(char *basename, SPXobject *spxob) {

   string_type buffer;
   char buffer2[MAXSTRLEN];
   face_work_type *ftr;
   int i;
   spb_loader loader;
   polytype *ob;
   shadelist *lob;
   texpolygon *tob;
   sfile sinfile;

   global_resource_manager->reset();

   spxob->init();

   buffer.stringcpy(basename);
   buffer.stringcat(".spb");

   if (!sinfile.scan_data(buffer.string, OBJECT_PATH.string,(char)PLATFORM_SLASH)) {
      sprintf(perror_buffer, "Warning: \"%s\" not found...\n", buffer.string);
      pprintf(perror_buffer);
      return 0;
   }

   if (!loader.find_loader(&sinfile) || !loader.read_data()) {
      sprintf(buffer2, "Invalid .spb file: \"%s\"", buffer.string);
      mbprintf(buffer2);
      return 0;
   }
   
   ob = (polytype *)loader.extract(FILETYPE_SPG, "");

   if (!ob) {
      sprintf(buffer2, "Invalid .spb file: \"%s\"", buffer.string);
      mbprintf(buffer2);
      return 0;
   }

   spxob->shade = new mtllist[spxob->shade_count = ob->countobject];
	
   lob = (shadelist *)loader.extract(FILETYPE_ILM, "");
   tob = (texpolygon *)loader.extract(FILETYPE_TEX, "");

   loader.cleanup();

   if (!spxob->Import_SPG(ob))
      return 0;

   if (lob)
      spxob->Import_ILM(lob, ob->countobject);
      
   if (tob)
      spxob->Import_TEX(tob);

   for (ftr = (face_work_type *)spxob->optimize->final_face_data.head->next, i = 1; ftr; ftr=(face_work_type *)ftr->next, i++)
      ftr->material_index = spxob->shade[0].insert(&spxob->shade[i]);

   return 1;
}
