

#include <string.h>

#include "polyops.h"


float COS_FIVE_DEG = 0.998f;
float MIN_POLY_AREA = 500.0f;

int	gilm = 1;
int	gtex = 1;
int	gcol = 1;


/* ******************************************************
****************************************************** */
edge_match_list::edge_match_list(dbl_llist_manager *match, face_work_type *face) {

   dbl_llist *ptr;
   
   candidate = face;

   while (match->head) {
      match->remove(ptr = match->head);
      stats.append(ptr, NULL);
   }

}

   
/* ******************************************************
****************************************************** */
int mtllist::insert(mtllist *x) {

   if (texname.stringcmp(&x->texname) || ilm.matcmp(&x->ilm)) {
      if (next)
         return next->insert(x);

      next = x;
      return x->id = id+1;
   }

   return id;
}


/* *****************************************************************************
***************************************************************************** */
int mtllist::find(int x, mtllist **y) {

   if (id != x) {
      if (next)
         return next->find(x, y);
		
      return -1;
   }

   if (y)
      *y = this;

   return id;
}


/* *****************************************************************************
***************************************************************************** */
int mtllist::mtlcmp(mtllist *x) {

   int i;
   
   if (id == x->id)
      return 0;
      
   i = texname.stringcmp(&x->texname);
   
   if (i)
      return i;
      
   return ilm.matcmp(&x->ilm);
}


/* **************************************************************
************************************************************** */
void group_type::mega_insert_btree(vector3f *verts, face_work_type *x) {

   vector3f v1, mxu, mxv;
   vector2f uv;
   vertex_type *vtr;
   float *v0, *uv0;
   float temp;
   int i;
   group_type *gtr;

   if (textureflag > x->textureflag)
      i = 1;
   else if (textureflag < x->textureflag)
      i = -1;
   else if (material_index > x->material_index)
      i = 1;
   else if (material_index < x->material_index)
      i = -1;
   // plane "levels" are close
   else {
      temp = dotproduct3(group_normal, x->face_normal);
      
      if (temp < 0)
         i = -1;
      else if (temp < COS_FIVE_DEG)
         i = 1;
      else {
         temp = group_normal[3] - x->face_normal[3];
	 if (temp > CORRECT)
	    i = 1;
	 else if (temp < -CORRECT)
	    i = -1;
	 else
	    i = 0;
      }
      
   }
	 	  
   // check to see if about the same...   
   if (!i) {
      if (!textureflag) {
         flist.insert(x, NULL);
         return;
      }

      // double check that texture coords are co-planar

      vtr = (vertex_type *)((face_work_type *)flist.head)->vlist.head;
      v0 = verts[vtr->vertex_index];
      uv0 = vtr->uv;

      map_3D_2D(v0, verts[((vertex_type *)vtr->next)->vertex_index], verts[((vertex_type *)vtr->next->next)->vertex_index],
                uv0, ((vertex_type *)vtr->next)->uv, ((vertex_type *)vtr->next->next)->uv, mxu, mxv);

      for (i=0, vtr=(vertex_type *)x->vlist.head; i<x->vlist.count; i++, vtr=(vertex_type *)vtr->next) {
         subeqarray3(v1, verts[vtr->vertex_index], v0);
         uv[0] = dotproduct3(v1, mxu) + uv0[0] - vtr->uv[0];
         uv[1] = dotproduct3(v1, mxv) + uv0[1] - vtr->uv[1];

         if (dotproduct2(uv, uv) > CORRECT)
            break;
      }

      if (i == x->vlist.count) {
         flist.insert(x, NULL);
         return;
      }

      i = 1;  // arbitrary
   }

   // x does not belong to this group...

   if (i == 1) {
      if (!next) {
         next = gtr = new group_type;
         copyarray4(gtr->group_normal, x->face_normal);
         gtr->material_index = x->material_index;
         gtr->textureflag = x->textureflag;

         gtr->flist.insert(x, NULL);
         return;
      }
	
      ((group_type *)next)->mega_insert_btree(verts, x);
      return;
   }
   
   if (!back) {
      back = gtr = new group_type;
      copyarray4(gtr->group_normal, x->face_normal);
      gtr->material_index = x->material_index;
      gtr->textureflag = x->textureflag;

      gtr->flist.insert(x, NULL);
      return;
   }
	
   ((group_type *)back)->mega_insert_btree(verts, x);   
}


/* **************************************************************
************************************************************** */
void group_type::material_insert_btree(mtllist *mtl, face_work_type *x) {

   int i;
   group_type *gtr;

   i = mtl[material_index].mtlcmp(&mtl[x->material_index]);

   if (!i) {
      flist.insert(x, NULL);
      return;
   }

   if (i == 1) {
      if (!next) {
         next = gtr = new group_type;
         gtr->material_index = x->material_index;

         gtr->flist.insert(x, NULL);
         return;
      }
	
      ((group_type *)next)->material_insert_btree(mtl, x);
      return;
   }
   
   if (!back) {
      back = gtr = new group_type;
      gtr->material_index = x->material_index;

      gtr->flist.insert(x, NULL);
      return;
   }
	
   ((group_type *)back)->material_insert_btree(mtl, x);   
}


/* **************************************************************
   Note: "list" is not in order - doesnt have to be
************************************************************** */
void group_type::build_list(dbl_llist_manager *head) {

   if (next) {
      ((group_type *)next)->build_list(head);
      next = NULL;
   }
   
   if (back) {
      ((group_type *)back)->build_list(head);
      back = NULL;
   }
   
   head->insert(this, NULL);
}


/* **************************************************************
************************************************************** */
int vbdata::compare(binary_data *x) {

   float temp;
   int i;

   for (i=0; i<3; i++) {
      temp = ((vbdata *)x)->v[i] - v[i];

      // greater
      if (temp > CORRECT)
         return 1;

      // less
      if (temp < -CORRECT)
         return -1;
   }
   	 
   // equivalent, so just return
   return 0;
}


/* **************************************************************
************************************************************** */
void vbdata::build(vector3f *x) {

   copyarray3(x[id], v);
};


/* **************************************************************
************************************************************** */
void vbnode::build(vector3f *x) {

   if (back)
      ((vbnode *)back)->build(x);

   ((vbdata *)key)->build(x);

   if (next)
      ((vbnode *)next)->build(x);
};


/* **************************************************************
************************************************************** */
void vbtree::build(vector3f *x) {

   if (head)
      ((vbnode *)head)->build(x);
}

      
/* ******************************************************************************************
		order of verticies in counter-clockwise order...
****************************************************************************************** */
int query_calc_normal(float *a, float *b, float *c) {

   vector3f v1, v2;
   float m1, m2;
   float ans;

   subeqarray3(v1, a, b);
   subeqarray3(v2, b, c);

   m1 = dotproduct3(v1, v1);
   if (m1 < CORRECT)
      return 0;
      
   m2 = dotproduct3(v2, v2);
   if (m2 < CORRECT)
      return 0;

   ans = dotproduct3(v1, v2);
   return (ans*ans < COS_FIVE_DEG*COS_FIVE_DEG*m1*m2);
}


/* ******************************************************************************************
****************************************************************************************** */
int query_spike(vector3f *verts, vertex_type *v1, vertex_type *v2, vertex_type *v3, int texflag, float angle) {

   vector3f e1, e2, e3;
   
   // check angle
   subeqarray3(e1, verts[v2->vertex_index], verts[v1->vertex_index]);
   subeqarray3(e2, verts[v3->vertex_index], verts[v2->vertex_index]);
		
   // check for nan/inf normals
   if (dotproduct3(e1, e2) > angle*angle*dotproduct3(e1, e1) * dotproduct3(e2, e2))
      return 1;

   // calc a normal
   xproduct(e3, e1, e2);

   return (dotproduct3(e3, e3) < CORRECT);
}
