
#ifdef WIN32
#include "WIN_W32.h"
#else
#include "WIN_X.h"
#endif

#include "polyops.h"


/* ******************************************************************************************
****************************************************************************************** */
int face_work_type::edge_intersect_edge(float *start, float *end, float *pt1, float *pt2, float *intersect) {

   vector3f v, ray, ray2;
   float lv, lray, lray2;

   subeqarray3(ray, end, start);
   lray  = normalize3(ray);

   subeqarray3(ray2, pt2, pt1);
   lray2 = normalize3(ray2);

   if (line3d_line3d_intersect(start, ray, pt1, ray2, intersect)) {
      subeqarray3(v, intersect, pt1);
      lv = (float)magnitude3(v);

      // want only  1 intersection...
      if (fabs(dotproduct3(v, ray)) < COS_FIVE_DEG*lv && (lv  <= CORRECT || (lv  <= lray2 && dotproduct3(v, ray2) > COS_FIVE_DEG*lv))) {
         subeqarray3(v, intersect, start);
         lv = (float)magnitude3(v);
         return (lv <= CORRECT || (lv <= lray && dotproduct3(v, ray) > COS_FIVE_DEG*lv));
      }

   }

   return 0;
}


/* ******************************************************************************************
****************************************************************************************** */
int face_work_type::query_combine_line(vector3f *verts, vertex_type *v1, vertex_type *v2, vertex_type *v3, int texflag, float angle) {

   vector3f e1, e2;
   float l;
   vector2f duv;
   float c, s;

   subeqarray3(e1, verts[v2->vertex_index], verts[v1->vertex_index]);
   subeqarray3(e2, verts[v3->vertex_index], verts[v2->vertex_index]);
		
   l = dotproduct3(e1, e1)*dotproduct3(e2, e2);

   c = (float)(dotproduct3(e1, e2)/sqrt(l));
   s = 1 - c*c;
   if (s < 0.0f)
      s = 0;

   if (c > angle && 0.25*s*l < MIN_POLY_AREA*MIN_POLY_AREA) {

      if (!texflag)
         return 1;

      subeqarray2(e1, v2->uv, v1->uv);
      subeqarray2(e2, v3->uv, v2->uv);
		
      l = (float)magnitude2(e1);

      subeqarray2(duv, v3->uv, v1->uv);
      normalize2(duv);

      if (dotproduct2(e1, e2) > angle*l*magnitude2(e2)) {
         duv[0] = v1->uv[0] + l*duv[0] - v2->uv[0];
         duv[1] = v1->uv[1] + l*duv[1] - v2->uv[1];

         if (dotproduct2(duv, duv) < CORRECT)
            return 1;
      }

   }

   return 0;
}


/* ******************************************************************************************
****************************************************************************************** */
int face_work_type::calc_concave() {

   vertex_type *vtr;
   int i = 0;

   if (vlist.count < 3)
      return 1;

   vtr = (vertex_type *)vlist.head;

   do {
      i += (vtr->concaveflag = (dotproduct3(vtr->normal, face_normal) < -CORRECT));
      vtr = (vertex_type *)vtr->next;
   } while (vtr != (vertex_type *)vlist.head);

   return i;
}


/* ******************************************************************************************
****************************************************************************************** */
int face_work_type::remove_backtrack(vector3f *verts, float angle) {

   int gflag = 0;
   vertex_type *ptr, *qtr, *rtr;

   ptr = (vertex_type *)vlist.head;
   qtr = (vertex_type *)ptr->next;
   rtr = (vertex_type *)qtr->next;

   while (qtr != (vertex_type *)vlist.head) {
      if (query_combine_line(verts, ptr, qtr, rtr, textureflag, angle)) {
         gflag = 1;
         vlist.remove(qtr);
         delete qtr;

         if (ptr->vsimilar(rtr, textureflag)) {							// only if just removed a spike
            vlist.remove(rtr);
            delete rtr;
         }

         if (!vlist.validate(verts))			
            return 1;
      }

      else
         ptr = qtr;

      qtr = (vertex_type *)ptr->next;
      rtr = (vertex_type *)qtr->next;
   }

   // ptr -> last on list, qtr = first on list
   while (rtr != ptr && query_combine_line(verts, ptr, qtr, rtr, textureflag, angle)) {
      gflag = 1;
      vlist.remove(qtr);
      delete qtr;

      if (ptr->vsimilar(rtr, textureflag)) {								// only if just removed a spike
         vlist.remove(rtr);
         delete rtr;
      }

      if (!vlist.validate(verts))			
         return 1;

      qtr = (vertex_type *)ptr->next;
      rtr = (vertex_type *)qtr->next;
   }

   return gflag;
}


/* ******************************************************************************************
****************************************************************************************** */
void face_work_type::post_smash(vector3f *verts, int btflag) {

   vertex_type *ptr, *qtr;
   int flag, gflag;
   vector3f v1, v2;
   float *p1, *p2, *p3;
   float t;
   float c, s, l1, l2, l12;
	
   if (!vlist.validate(verts))
      return;

   gflag = 0;
   ptr = (vertex_type *)vlist.head;

   // remove similar verticies
   do {
      while (ptr->vsimilar((vertex_type *)ptr->next, textureflag)) {
         gflag = 1;
         qtr = (vertex_type *)ptr->next;
         vlist.remove(qtr);
         delete qtr;

         if (!vlist.validate(verts))
            return;
      }

      ptr = (vertex_type *)ptr->next;
   } while (ptr != vlist.head);

   // remove "folds"
   if (btflag)
      do {
         flag = 0;
         ptr = (vertex_type *)vlist.head;

         do {
            p1 = verts[ptr->vertex_index];
            p2 = verts[((vertex_type *)ptr->next)->vertex_index];
            p3 = verts[((vertex_type *)ptr->next->next)->vertex_index];

            subeqarray3(v1,p2, p1);
            l1 = dotproduct3(v1, v1);

            subeqarray3(v2, p3, p2);
            l2 = dotproduct3(v2, v2);

            l12 = l1*l2;

            c = (float)(dotproduct3(v1, v2)/sqrt(l12));
            s = 1 - c*c;

            if (s < 0)
               s = 0;

            if (c < -COS_FIVE_DEG && 0.25*s*l12 < MIN_POLY_AREA*MIN_POLY_AREA) {
               if (!textureflag) {						
                  gflag = flag = 1;
                  qtr = (vertex_type *)ptr->next;
                  vlist.remove(qtr);
                  delete qtr;

                  if (ptr->vsimilar((vertex_type *)ptr->next, 0)) {
                     qtr = (vertex_type *)ptr->next;
                     vlist.remove(qtr);
                     delete qtr;
                  }

                  if (!vlist.validate(verts))
                     return;

                  break;
               }

               t = l2/l1;

               p1 = ptr->uv;
               p2 = ((vertex_type *)ptr->next)->uv;
               p3 = ((vertex_type *)ptr->next->next)->uv;

               subeqarray2(v1, p2, p1);
               l1 = dotproduct2(v1, v1);

               subeqarray2(v2, p3, p2);
               l2 = dotproduct2(v2, v2);

               l12 = l1*l2;

               c = (float)(dotproduct3(v1, v2)/sqrt(l12));
               s = 1 - c*c;
	       
               if (s < 0)
                  s = 0;
		  
               if (fabs(t - (l2 / l1)) < CORRECT && c < -COS_FIVE_DEG && 0.25*s*l12 < MIN_POLY_AREA*MIN_POLY_AREA) {
                  gflag = flag = 1;
                  qtr = (vertex_type *)ptr->next;
                  vlist.remove(qtr);
                  delete qtr;

                  if (ptr->vsimilar((vertex_type *)ptr->next, textureflag)) {
                     qtr = (vertex_type *)ptr->next;
                     vlist.remove(qtr);
                     delete qtr;
                  }

                  if (!vlist.validate(verts))
                     return;

                  break;
               }

            }

            ptr = (vertex_type *)ptr->next;
				 
         } while (ptr != (vertex_type *)vlist.head);

   } while(flag);


   // remove linear edge pairs
   gflag += remove_backtrack(verts, COS_FIVE_DEG);

   if (!vlist.validate(verts))
      return;

   if (gflag) {
      vlist.calc_vnormal(verts);
      calc_concave();
   }

}


/* ******************************************************************************************
****************************************************************************************** */
int face_work_type::query_pt_in_polygon(float *pt, vector3f *verts) {

   double angle, work;
   vector3f v0, v1, v2, vn;
   vertex_type *vtr;
   float l0, l1, l2;

   subeqarray3(v2, verts[((vertex_type *)vlist.head)->vertex_index], pt);
   l2 = dotproduct3(v2, v2);
   copyarray3(v0, v2);
   l0 = l2;

   for (vtr = (vertex_type *)vlist.head->next, angle=0.0f; vtr != (vertex_type *)vlist.head; vtr = (vertex_type *)vtr->next) {
      copyarray3(v1, v2);
      l1 = l2;

      subeqarray3(v2, verts[vtr->vertex_index], pt);
      l2 = dotproduct3(v2, v2);

      calculate_normal(pt, verts[vtr->vertex_index], verts[((vertex_type *)vtr->back)->vertex_index], vn);

      work = dotproduct3(v1, v2)/sqrt(l1*l2);

      if (work <= -1)
         work = PI;
      else if (work >= 1)
         work = 0;
      else
         work = acos(work);

      if (dotproduct3(face_normal, vn) > 0)
         angle += work;
      else
         angle -= work;
   }

   calculate_normal(pt, verts[vtr->vertex_index], verts[((vertex_type *)vtr->back)->vertex_index], vn);

   work = dotproduct3(v0, v2)/sqrt(l0*l2);

   if (work <= -1)
      work = PI;
   else if (work >= 1)
      work = 0;
   else
      work = acos(work);

   if (dotproduct3(face_normal, vn) > 0)
      angle += work;
   else
      angle -= work;

   return (angle > TWOPI2D-CORRECT2 && angle < TWOPI2D + CORRECT2);
}


/* ******************************************************************************************
****************************************************************************************** */
int face_work_type::query_internal_diagonal(vector3f *verts, vertex_type *pt1, vertex_type *pt2) {

   vertex_type *vtr, *wtr;
   vector3f intersect, v;

   vtr = (vertex_type *)vlist.head;
   wtr = (vertex_type *)vlist.head->next;

   do {
      if (!vtr->vsimilar(pt1, textureflag) && !vtr->vsimilar(pt2, textureflag) && !wtr->vsimilar(pt1, textureflag) && !wtr->vsimilar(pt2, textureflag)) {
         if (edge_intersect_edge(verts[pt1->vertex_index], verts[pt2->vertex_index], verts[vtr->vertex_index], verts[wtr->vertex_index], intersect))
            return 0;
      }

      vtr = wtr;
      wtr = (vertex_type *)wtr->next;
   } while (vtr != (vertex_type *)vlist.head);


   // its a diagonal -> check for internal/external

   v[0] = (verts[pt2->vertex_index][0] + verts[pt1->vertex_index][0]) * 0.5f;
   v[1] = (verts[pt2->vertex_index][1] + verts[pt1->vertex_index][1]) * 0.5f;
   v[2] = (verts[pt2->vertex_index][2] + verts[pt1->vertex_index][2]) * 0.5f;

   return query_pt_in_polygon(v, verts);
}


/* ******************************************************************************************
****************************************************************************************** */
face_work_type *face_work_type::make_subface(vertex_type *vtr, vertex_type *wtr, vector3f *verts, int orders) {

   face_work_type *new_face;
   vertex_type *atr, *btr, *ttr;

   new_face = new face_work_type;

   copyarray4(new_face->face_normal, face_normal);
   new_face->material_index = material_index;
   new_face->textureflag = textureflag;
   vlist.clone_list(&new_face->vlist);

   for (atr = (vertex_type *)new_face->vlist.head, ttr = (vertex_type *)vlist.head; ttr != vtr; atr=(vertex_type *)atr->next, ttr = (vertex_type *)ttr->next);
   for (btr = (vertex_type *)new_face->vlist.head, ttr = (vertex_type *)vlist.head; ttr != wtr; btr=(vertex_type *)btr->next, ttr = (vertex_type *)ttr->next);

   while (btr != atr->back) {
      ttr = (vertex_type *)atr->back;
      new_face->vlist.remove(ttr);
      delete ttr;
   }

   if (!new_face->vlist.count) {
      delete new_face;
      return NULL;
   }

   new_face->post_smash(verts, 1);

   if (!new_face->vlist.validate(verts)) {
      delete new_face;
      return NULL;
   }
   
   ttr = (vertex_type *)new_face->vlist.head;

   do {

      if (ttr == atr) {
         calculate_normal(verts[((vertex_type *)atr->next)->vertex_index], verts[atr->vertex_index], verts[((vertex_type *)atr->back)->vertex_index], atr->normal);
         atr->concaveflag = (dotproduct3(atr->normal, face_normal) < CORRECT);
         if (orders != OVERRIDE && atr->concaveflag) {
            delete new_face;
            return NULL;
         }

      }

      else if (ttr == btr) {
         calculate_normal (verts[((vertex_type *)btr->next)->vertex_index], verts[btr->vertex_index], verts[((vertex_type *)btr->back)->vertex_index], btr->normal);
         btr->concaveflag = (dotproduct3(btr->normal, face_normal) < CORRECT);
         if (orders != OVERRIDE && btr->concaveflag) {
            delete new_face;
            return NULL;
         }

      }

      ttr = (vertex_type *)ttr->next;
   } while (ttr != (vertex_type *)new_face->vlist.head);

   return new_face;
}


/* ******************************************************************************************
****************************************************************************************** */
void face_work_type::triangulate(vector3f *verts, dbl_llist_manager *triman) {

   vertex_type *ptr, *ntr, *btr, *ntr1, *btr1;
   int flag;
   vertex_manager thead;

   face_work_type *ttr;

   vector3f n;

   triman->dest();

   if (vlist.count < 3)
      return;

   vlist.clone_list(&thead);

   ptr = (vertex_type *)thead.head;

   do {				// should be augmented to check w/ each vertex, not adjacent 2....

      flag = 0;

      do {
         ntr = (vertex_type *)ptr->next;
         btr = (vertex_type *)ntr->next;
         ntr1 = (vertex_type *)ptr->back;
         btr1 = (vertex_type *)ntr1->back;

         // determine if start point is not co-linear with more than one point
         if (query_calc_normal(verts[ptr->vertex_index], verts[ntr->vertex_index], verts[btr->vertex_index]) &&
             query_calc_normal(verts[btr1->vertex_index], verts[ntr1->vertex_index], verts[ptr->vertex_index])) {
            flag = 1;
            break;
         }

         ptr = (vertex_type *)btr->next;
      } while (ptr != (vertex_type *)thead.head);

      if (flag)
         break;

      // couldn't find a good point so chop off a triangle and try again
      do {
         ntr = (vertex_type *)ptr->next;
         btr = (vertex_type *)ntr->next;
         if (query_calc_normal(verts[ptr->vertex_index], verts[ntr->vertex_index], verts[btr->vertex_index])) {
            flag = 1;
            break;
         }

         ptr = ntr;
      } while (ptr != (vertex_type *)thead.head);

      if (!flag) {
         mbprintf("Warning: Unable to triangulate polygon - REMOVED");
         thead.dest();
         triman->dest();
         return;
      }

      calculate_normal(verts[btr->vertex_index], verts[ntr->vertex_index], verts[ptr->vertex_index], n);

      if (fabs(dotproduct3(face_normal, n)) > 0.1) {
         triman->insert(ttr = new face_work_type, NULL);

         copyarray4(ttr->face_normal, face_normal);
         ttr->material_index = material_index;
         ttr->textureflag = textureflag;
         ttr->vlist.triangle(ptr, ntr, btr);

         thead.remove(ntr);
      }	

      else {
         mbprintf("Warning: Unable to resolve linear polygon - REMOVED");
         thead.remove(ntr);
         delete ntr;
      }

      ptr = (vertex_type *)thead.head;
   } while (thead.count > 3);
			
   if (thead.count < 3) {
      thead.dest();
      return;
   }

   btr = (vertex_type *)ptr->next;

   // found a good fan point, use it to get the triangle
   while (thead.head) {
      ntr = btr;
      btr = (vertex_type *)btr->next;

      calculate_normal(verts[btr->vertex_index], verts[ntr->vertex_index], verts[ptr->vertex_index], n);

      if (thead.count == 3) {
         if (fabs(dotproduct3(face_normal, n)) > 0.1) {
            triman->insert(ttr = new face_work_type, NULL);

            copyarray4(ttr->face_normal, face_normal);
            ttr->material_index = material_index;
            ttr->textureflag = textureflag;
            ttr->vlist.triangle(ptr, ntr, btr);
         }

         else
            mbprintf("Warning: Unable to resolve linear polygon - REMOVED");

         thead.dest();
         return;
      }

      if (fabs(dotproduct3(face_normal, n)) > 0.1) {
         triman->insert(ttr = new face_work_type, NULL);

         copyarray4(ttr->face_normal, face_normal);
         ttr->material_index = material_index;
         ttr->textureflag = textureflag;
         ttr->vlist.triangle(ptr, ntr, btr);

         thead.remove(ntr);
      }	

      else {
         mbprintf("Warning: Unable to resolve linear polygon - REMOVED");
         thead.remove(ntr);
         delete ntr;
      }

   }

}


/* ******************************************************************************************
****************************************************************************************** */
void face_work_type::affinemap(vector2f *uv, vector3f *verts) {

   vlist.affinemap(uv, verts);

   textureflag = 1;
}


