

#include "amessage.h"
#include "timer.h"


#define mbprintf(xxx)    MessageBox( NULL, xxx, "", MB_OK );


/* ************************************************************************
************************************************************************ */
class amsg_win_link : public dbl_llist {

   public:
      HWND hwnd;
      amsg_win *source;
      
      amsg_win_link() { hwnd = (HWND)0; source = NULL; }
      virtual ~amsg_win_link() {}
};


dbl_llist_manager controller_manager;


/* ************************************************************************
************************************************************************ */
LRESULT WINAPI msg_win_proc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam) {

   amsg_win_link *ptr;
   COPYDATASTRUCT *cds;
   
   switch (msg) {
      case WM_DESTROY:
         PostQuitMessage(0);
         // should have exited previously but...
         break;

      case WM_COPYDATA:
         for (ptr = (amsg_win_link *)controller_manager.head; ptr && ptr->hwnd != hwnd; ptr = (amsg_win_link *)ptr->next);
         if (!ptr)
            break;

         cds = (COPYDATASTRUCT *)lParam;
         ptr->source->process_message((char *)cds->lpData, cds->cbData);
         break;

      default:
         break;
   }

   return DefWindowProc(hwnd, msg, wParam, lParam);
}


/* ************************************************************************
************************************************************************ */
amsg_win::amsg_win() {

   target_window = window = (HWND)0;
}


/* ************************************************************************
************************************************************************ */
void amsg_win::dest() {

   amsg_win_link *ptr; 

   if (!window)
      return;
      
   for (ptr = (amsg_win_link *)controller_manager.head; ptr; ptr = (amsg_win_link *)ptr->next)
      if (ptr->hwnd == window) {
         controller_manager.remove(ptr);
         delete ptr;
         break;
      }
      
   DestroyWindow(window);
   target_window = window = (HWND)0;

   backlog_manager.dest();
}


/* ************************************************************************
************************************************************************ */
int amsg_win::init(int argc, char **argv, int type) {

   WNDCLASS windowClass;
   int i;
   HINSTANCE inst = (HINSTANCE)0;
   amsg_win_link *ptr; 

   dest();
   config_type = type;

   for (i = 0; i<argc; i++) {

      if (argv[i][0] != '-')
         continue;

      if (!strcmp(TOKEN_MSGWIN_NAME, argv[i])) {
         i++;
         if (i >= argc)
            break;

         name.stringcpy(argv[i]);
         continue;
      }

      if (!strcmp(TOKEN_MSGWIN_INSTANCE, argv[i])) {
         i++;
         if (i >= argc)
            break;

         inst = (HINSTANCE)atoi(argv[i]);
         continue;
      }

      if (!strcmp(TOKEN_MSGWIN_TARGET, argv[i])) {
         i++;
         if (i >= argc)
            break;

         target_window = (HWND)atoi(argv[i]);
         continue;
      }

   }

   // Fill the slots of and register the window class
   windowClass.style = 0;
   windowClass.lpfnWndProc = msg_win_proc;
   windowClass.cbClsExtra = 0;
   windowClass.cbWndExtra = 0;
   windowClass.hInstance = inst;
   windowClass.hIcon = NULL;
   windowClass.hCursor = NULL;
   windowClass.lpszMenuName = NULL;
   windowClass.lpszClassName = name.string;
   windowClass.hbrBackground = NULL;
   
   if (!RegisterClass(&windowClass)) {
      mbprintf("Error: Couldn't register Windoze Class\n");
      return 0;
   }

   // Create the main window
   window = CreateWindowEx(
      WS_EX_CONTROLPARENT,
      name.string,                // class
      name.string,                // caption
      WS_EX_TRANSPARENT,
      0,                          // init. x pos
      0,                          // init. y pos
      1,
      1,
      NULL,                       // parent window
      NULL,                       // menu handle
      inst,                       // program handle
      NULL);                      // create parms

   if (!window) {
      mbprintf("Error: Couldn't open a window\n");
      return 0;
   }

   ShowWindow(window, SW_HIDE);

   controller_manager.append(ptr = new amsg_win_link, NULL);
   ptr->hwnd = window;
   ptr->source = this;
   return 1;
}


/* ************************************************************************
************************************************************************ */
int amsg_win::receive_message(buffer_type *buffer) {

   buffer_type *msg;

   if (!backlog_manager.head)
      return 0;
      
   backlog_manager.remove(msg = (buffer_type *)backlog_manager.head);

   buffer->buffercpy(msg);
   delete msg;
   return 1;
}


/* ************************************************************************
************************************************************************ */
int amsg_win::send_message(buffer_type *buffer) {

   return send_message(buffer, (unsigned int)target_window);
}


/* ************************************************************************
************************************************************************ */
int amsg_win::query_message(buffer_type *buffer) {

   buffer_type *msg;

   if (!backlog_manager.head)
      return 0;
      
   msg = (buffer_type *)backlog_manager.head;

   buffer->buffercpy(msg);
   return 1;
}


/* ************************************************************************
************************************************************************ */
int amsg_win::receive_message_raw(buffer_type *buffer, int len) {

   return receive_message(buffer);
}


/* ************************************************************************
************************************************************************ */
int amsg_win::send_message_raw(buffer_type *buffer) {

   return send_message(buffer);
}


/* ************************************************************************
************************************************************************ */
int amsg_win::query_message_raw(buffer_type *buffer, int len) {

   return query_message(buffer);
}


/* ************************************************************************
************************************************************************ */
void amsg_win::process_message(char *buffer, int len) {

   buffer_type *msg;

   backlog_manager.append(msg = new buffer_type, NULL);
   
   msg->buffercpy(buffer, len);
}


/* ************************************************************************
************************************************************************ */
int amsg_win::send_message(buffer_type *buffer, unsigned int target) {

   COPYDATASTRUCT cds;

   if (!target)
      return 0;
      
   cds.dwData = (unsigned long)window;
   cds.cbData = buffer->bufferlen();
   cds.lpData = buffer->data;

   SendMessage((HWND)target, WM_COPYDATA, (WPARAM)window, (LPARAM)&cds);
   return 1;
}


/* ************************************************************************
************************************************************************ */
int amsg_win::init_connection(int tid, float timeout) {

   buffer_type buffer;   
   MSG message;
   TIME_STRUCT t;
   float oldtime, newtime;
   
   if (config_type == CONFIG_TYPE_CLIENT) {
      target_window = (HWND)tid;

      buffer.bufferlen(sizeof(int));
      *(unsigned int *)buffer.data = (unsigned int)window;
      
      send_message(&buffer);
      return 1;
   }

   if (timeout < 0) {
      do {
         while (PeekMessage(&message, NULL, 0, 0, PM_REMOVE))
            DispatchMessage(&message);
      } while (!receive_message(&buffer));

      target_window = *(HWND *)buffer.data;
      return 1;
   }

   GETTIME(&t);
   oldtime = (float)TIME2FLOAT(t);

   do {
      while (PeekMessage(&message, NULL, 0, 0, PM_REMOVE))
         DispatchMessage(&message);

      if (receive_message(&buffer)) {
         target_window = *(HWND *)buffer.data;
         return 1;
      }
      
      GETTIME(&t);
      newtime = (float)TIME2FLOAT(t);
   } while (newtime >= oldtime && newtime < oldtime + timeout);

   return 0;
}
