

#include <stdlib.h>
#include <string.h>
#include <sys/msg.h>
#include <errno.h>

#include "amessage.h"

#define PERMS         0666

#define CREATE_QUEUE   1  // Flag to denote creator of queue
#define ATTACH_QUEUE   0


/* ******************************************************************
****************************************************************** */
amsgqueue::amsgqueue() {

   queue_id = -1;
   queue_key = 0xdead;   
   rcv_flag = 0;
}


/* ******************************************************************
****************************************************************** */
int amsgqueue::init(int argc, char **argv, int type) {

   int i;

   dest();
   config_type = type;
         
   for (i = 0; i<argc; i++) {

      if (argv[i][0] != '-')
         continue;

      if (!strcmp(TOKEN_MSGQUEUE_KEY, argv[i])) {
         i++;
         if (i >= argc)
            break;

         queue_key = atoi(argv[i]);
         continue;
      }

   }

   // create queue
   queue_id = msgget(queue_key, IPC_CREAT | PERMS );
   return queue_id > -1;
}


/* ******************************************************************
****************************************************************** */
void amsgqueue::dest() {

   //  ONLY the server may remove the message queue
   if (queue_id > -1) {
      if (config_type == CONFIG_TYPE_SERVER)
         msgctl(queue_id, IPC_RMID, NULL);
      queue_id = -1;
   }

}


/* ******************************************************************
****************************************************************** */
int amsgqueue::query_message(buffer_type *buffer) {

   while (!rcv_flag) {

      if (msgrcv(queue_id, inbuffer.data, inbuffer.buffersize()-sizeof(long), 0, IPC_NOWAIT) <= 0)
         switch (errno) {
      
            case E2BIG:
               inbuffer.buffersize(inbuffer.buffersize() + 16);
               continue;
       
//            case ENOMSG:
            default:
               return 0;
         }

      else {
         rcv_flag = 1;
         inbuffer.bufferlen(inbuffer.buffersize());
         break;
      }
      
   }

   buffer->buffercpy(&inbuffer.data[sizeof(long)], inbuffer.bufferlen() - sizeof(long));
   return buffer->bufferlen();
}


/* ******************************************************************
****************************************************************** */
int amsgqueue::receive_message(buffer_type *buffer) {

   while (!rcv_flag) {

      if (msgrcv(queue_id, inbuffer.data, inbuffer.buffersize()-sizeof(long), 0, IPC_NOWAIT) <= 0)
         switch (errno) {
      
            case E2BIG:
               inbuffer.buffersize(inbuffer.buffersize() + 16);
               continue;
       
//            case ENOMSG:
            default:
               return 0;
         }

      else {
         rcv_flag = 1;
         inbuffer.bufferlen(inbuffer.buffersize());
         break;
      }

   }

   rcv_flag = 0;
   buffer->buffercpy(&inbuffer.data[sizeof(long)], inbuffer.bufferlen() - sizeof(long));
   return buffer->bufferlen();
}


/* ******************************************************************
****************************************************************** */
int amsgqueue::send_message(buffer_type *buffer) {

   int i = buffer->bufferlen()+sizeof(long);

   outbuffer.buffersize(i);
   outbuffer.bufferlen(i);
   *(long *)outbuffer.data = 1;
   memcpy(&outbuffer.data[sizeof(long)], buffer->data, buffer->bufferlen());
   
   return msgsnd(queue_id, outbuffer.data, buffer->bufferlen(), IPC_NOWAIT) == 0;
}


/* ******************************************************************
****************************************************************** */
int amsgqueue::query_message_raw(buffer_type *buffer, int len) {

   return query_message(buffer);
}


/* ******************************************************************
****************************************************************** */
int amsgqueue::receive_message_raw(buffer_type *buffer, int len) {

   return receive_message(buffer);
}


/* ******************************************************************
****************************************************************** */
int amsgqueue::send_message_raw(buffer_type *buffer) {

   return send_message(buffer);
}

