

#include <stdlib.h>
#include <string.h>

#include "amailbox.h"


/* ******************************************************************
****************************************************************** */
int post_office_type::init(int argc, char **argv, int id) {

   int i;

   message_list.dest();
   type = id;
   address = 0;
   
   for (i = 0; i<argc; i++) {

      if (argv[i][0] != '-')
         continue;

      if (!strcmp(TOKEN_MAILBOX_ID, argv[i])) {
         i++;
         if (i >= argc)
            break;

         address = atoi(argv[i]);
         continue;
      }

   }

   return address;
}


/* ******************************************************************
****************************************************************** */
void post_office_type::new_address(amessage *src, int id) {

   mailbox_type *ptr;
   
   mailbox_list.append(ptr = new mailbox_type, NULL);
   ptr->address = id;
   ptr->mailslot = src;
}


/* ******************************************************************
****************************************************************** */
amessage *post_office_type::delete_address(int id) {

   mailbox_type *ptr;
   amessage *atr;
   
   for (ptr = (mailbox_type *)mailbox_list.head; ptr; ptr = (mailbox_type *)ptr->next)
      if (ptr->address == id) {
         mailbox_list.remove(ptr);
         atr = ptr->mailslot;
         delete ptr;
         return atr;
      }

   return NULL;
}


/* ******************************************************************
****************************************************************** */
void post_office_type::update_mailboxes() {

   mailbox_type *ptr, *qtr;
   message_type *buffer;
   mail_header_type *header;

   for (ptr = (mailbox_type *)mailbox_list.head; ptr; ptr = (mailbox_type *)ptr->next)
      do {
         buffer = new message_type;
	 if (ptr->mailslot->receive_message(&buffer->buffer)) {
            header = (mail_header_type *)buffer->buffer.data;    

	    if (header->msg_to == address)
               message_list.append(buffer, NULL);
            else {
               for (qtr = (mailbox_type *)mailbox_list.head; qtr; qtr = (mailbox_type *)qtr->next)
                  if (header->msg_to == qtr->address) {
                     qtr->mailslot->send_message(&buffer->buffer);
                     break;
                  }

               delete buffer;
            }

	 }
	    
         else {
	    delete buffer;
	    buffer = NULL;
	 }
	 
      } while (buffer);
      
}


/* ******************************************************************
****************************************************************** */
int post_office_type::query_message(buffer_type *buffer) {

   update_mailboxes();

   if (!message_list.head)
      return 0;
      
   buffer->buffercpy(&((message_type *)message_list.head)->buffer);
   return 1;
}


/* ******************************************************************
****************************************************************** */
int post_office_type::find_message(int type, buffer_type *buffer) {

   message_type *ptr;
   mail_header_type *header;
   
   update_mailboxes();

   if (!message_list.head)
      return 0;

   for (ptr=(message_type *)message_list.head; ptr; ptr=(message_type *)ptr->next) {
      header = (mail_header_type *)ptr->buffer.data;
      if (header->msg_type == type) {
         message_list.remove(ptr);
         buffer->buffercpy(&ptr->buffer);
         delete ptr;
         return 1; 
      }

   }

   return 0;
}


/* ******************************************************************
****************************************************************** */
int post_office_type::receive_message(buffer_type *buffer) {

   message_type *ptr;
   
   update_mailboxes();

   if (!message_list.head)
      return 0;
      
   message_list.remove(ptr = (message_type *)message_list.head);
   buffer->buffercpy(&ptr->buffer);
   delete ptr;
   return 1;
}


/* ******************************************************************
****************************************************************** */
int post_office_type::send_message(buffer_type *buffer) {

   mailbox_type *ptr;
   mail_header_type *header;

   header = (mail_header_type *)buffer->data;    

   if (header->msg_from != address && type != CONFIG_TYPE_SERVER)
      header->msg_from = address;

   for (ptr = (mailbox_type *)mailbox_list.head; ptr; ptr = (mailbox_type *)ptr->next)
      if (ptr->address == header->msg_to)
         return ptr->mailslot->send_message(buffer);

   return 0;
}

