

/* *************************************************************
   This file handles all the matrix/vector/math operations

   Reminder: Spherical Linear intERPolation (SLERP) can be
             done by splining the quaternions

************************************************************* */

#include <string.h>
#include "matrix.h"

typedef float *pfloat;

float *cos_table = (float *)NULL;
float *sin_table = (float *)NULL;
float *asin_table = (float *)NULL;

double trigfactor = MAX_TRIG_SIZE/TWOPI;
double atrigfactor = MAX_TRIG_SIZE*0.5;

void dest_sin_cos() {

   if (sin_table) {
      delete [] sin_table;
      sin_table = NULL;
   }
   
}


void init_sin_cos() {

   register int i;

   dest_sin_cos();

   sin_table = new float[MAX_SIN_COS_TBL_SIZE];

   cos_table = &sin_table[COS_START];

   for (i=0 ; i <COS_START; i++)
      sin_table[i] = (float)sin((i*TWOPI)/MAX_TRIG_SIZE_PLUS);

   for (i=0 ; i <MAX_TRIG_SIZE_PLUS; i++)
      cos_table[i] =  (float)cos((i*TWOPI)/MAX_TRIG_SIZE_PLUS);
}


void dest_asin_acos() {

   if (asin_table) {
      delete [] asin_table;
      asin_table = NULL;
   }
   
}

void init_asin_acos() {

   register int i;

   dest_asin_acos();

   asin_table = new float[MAX_TRIG_SIZE_PLUS];

   for (i=0 ; i <MAX_TRIG_SIZE_PLUS; i++)
      asin_table[i] = (float)asin((((float)(i+i))/MAX_TRIG_SIZE_PLUS) - 1);
}


// ***************************************************************************

int *sqrt_mantissa_lut = NULL;
int *isqrt_mantissa_lut = NULL;
int bit_table[2] = { 0, 0x8000 };

void dest_sqrt() {

   if (sqrt_mantissa_lut) {
      delete [] sqrt_mantissa_lut;
      sqrt_mantissa_lut = NULL;
   }
   
   if (isqrt_mantissa_lut) {
      delete [] isqrt_mantissa_lut;
      isqrt_mantissa_lut = NULL;
   }
   
}

void init_sqrt() {

   int     i;
   conversion_type b;

   dest_sqrt();

   sqrt_mantissa_lut = new int[65536];
   isqrt_mantissa_lut = new int[65536];

   sqrt_mantissa_lut[0] = 0;
   isqrt_mantissa_lut[0] = 0;

   for (i = 1; i < 32768; i++) {

		// exponent 0
      b.bits = (i | (0x7F<<15)) << 8;
      b.f = (float)sqrt(b.f);
//      sqrt_mantissa_lut[i] = b.bits & 0x7FFFFF;
      sqrt_mantissa_lut[i+32768] = b.bits & 0x7FFFFF;

      b.bits = (i | (0x7F<<15)) << 8;
      b.f = 1.0f / (float)sqrt(b.f);
//      isqrt_mantissa_lut[i] = b.bits & 0x7FFFFF;
      isqrt_mantissa_lut[i+32768] = b.bits & 0x7FFFFF;
   }

   for (i = 0; i < 32768; i++) {

		// exponent 1
      b.bits = (i | (1<<22)) << 8;
      b.f = (float)sqrt(b.f);
//      sqrt_mantissa_lut[i + 32768] = b.bits & 0x7FFFFF;
      sqrt_mantissa_lut[i] = b.bits & 0x7FFFFF;

      b.bits = (i |(1<<22)) << 8;
      b.f = 1.0f / (float)sqrt(b.f);
//      isqrt_mantissa_lut[i + 32768] = b.bits & 0x7FFFFF;
      isqrt_mantissa_lut[i] = b.bits & 0x7FFFFF;
   }

}


// ***************************************************************************
unsigned char byte_lut[1024];
unsigned char *pbyte_lut = &byte_lut[128];

void init_byte() {

   unsigned int i;

   memset(byte_lut, 0, 128);

   for (i=0; i<256; i++)
      pbyte_lut[i] = (unsigned char)i;

   memset(&byte_lut[384], 255, 640);
}

// ***************************************************************************
float t_0_255_0_1[256];
float *table_0_255_0_1 = t_0_255_0_1;

void init_0_255_0_1() {

   unsigned int i;
   for (i=0; i<256; i++)
      table_0_255_0_1[i] = i/255.0f;
}


// ***************************************************************************

void init_lut(int fmask) {

   if (fmask & MASK_SIN_COS)
      init_sin_cos();

   if (fmask & MASK_ASIN_ACOS)
      init_asin_acos();

   if (fmask & MASK_SQRT)
      init_sqrt();

   if (fmask & MASK_BYTE)
      init_byte();

   if (fmask & MASK_0_255_0_1)
      init_0_255_0_1();
}


// ***************************************************************************

void dest_lut() {

   dest_sin_cos();
   dest_asin_acos();
   dest_sqrt();
}





/*


extern int *inv_lut;

inline float inverse(float x) {

    conversion_type b;

    b.f = x;

    //                  exponent                    |   mantissa
    if (b.bits & 0x007fff80)
        b.bits = ((253 - (b.bits >> 23))<<23) | inv_lut[(b.bits & 0x007fffff)>>7];
        else
        b.bits = ((254 - (b.bits >> 23))<<23);

    return b.f;
}


// ***************************************************************************

int *inv_lut = NULL;

void init_inv() {

   int i;
   conversion_type c;

   if (inv_lut)
      delete [] inv_lut;

   inv_lut = new int[65536];
   inv_lut[0] = 0;

   for (i = 1; i < 65536; i++) {

      c.bits = (0x7f<<23) | (i<<7) ;

      c.f = 1.0f / c.f;

      // Put into look up table
      inv_lut[i] = c.bits & 0x7fffff;
   }

}

// ***************************************************************************

float *pow_lut = NULL;
float **ppow_lut = NULL;

#define MAX_POW_X 100
#define MAX_POW_N 100
extern float **ppow_lut;

#define POW(x,y) ppow_lut[((int)(y))][(int)((x)*100)]

void init_pow() {

   unsigned int i, j;

   if (pow_lut)
      delete [] pow_lut;

   pow_lut = new float[(MAX_POW_N+1)*(MAX_POW_X+1)];

   if (ppow_lut)
      delete [] ppow_lut;

   ppow_lut = new pfloat[MAX_POW_N+1];

   for (i=j=0; i<=MAX_POW_N; i++, j+= MAX_POW_X+1)
      ppow_lut[i] = &pow_lut[j];

   for (j=0; j<=MAX_POW_X; j++)
      ppow_lut[0][j] = 1.0;

   for (i=1; i<=MAX_POW_N; i++)
      for (j=0; j<=MAX_POW_X; j++)
         ppow_lut[i][j] = (float)pow((float)(j*0.01), (float)i);
}



   if (fmask & MASK_POW)
      init_pow();




*/
