
#include <string.h>

#include "spg_load.h"


/* *******************************************************************
******************************************************************* */
void spg_loader::cleanup() {

   file_loader::cleanup();
   countobject = 0;
   ob = NULL;
}


/* *******************************************************************
   Auto exceptance
******************************************************************* */
basic_loader *spg_loader::find_loader(sfile *data) {

   sinfile = data;
   return this;
}


/* *******************************************************************
******************************************************************* */
int spg_loader::read_data() {

   if (!sinfile)
      return 0;

   ob = (polytype *)global_resource_manager->find_resource_object(RESOURCE_OBJECT, sinfile->filename.string, NULL);

   if (ob) {
      if (!(ob->statusflag & STATUSFLAG_LOADED))
         ob->read_data(sinfile->filename.string);

      countobject = ((polytype *)ob)->countobject;
      return 1;
   }

   ob = new polytype;

   if (!ob->read_data(sinfile->filename.string) || !((polytype *)ob)->countobject) {
      delete ob;
      ob = NULL;
      return 0;
   }

   global_resource_manager->register_resource_object(RESOURCE_OBJECT, ob);
   countobject = ((polytype *)ob)->countobject;
   return 1;
}


/* *******************************************************************
******************************************************************* */
void *spg_loader::extract(unsigned int type, char *altname, int level) {

   resource_type *dob;
   
   if (!ob)
      return NULL;

   switch (type) {
      case FILETYPE_SPG:
         return ob;

      case FILETYPE_ILM:

         // note: find for read_ilm() only works on "altname" - "dataname" irrelevant
         dob = (resource_type *)((frame_manager *)global_resource_manager)->read_ilm(altname, countobject);

         if (dob)
            dob->dataname.stringcpy(&ob->dataname);

         return dob;

      case FILETYPE_TEX:
         dob = (resource_type *)global_resource_manager->find_resource_object(RESOURCE_UVCOORD, ob->dataname.string, altname);
         if (dob) {
            if (!(dob->statusflag & STATUSFLAG_LOADED))
               ((texpolygon *)dob)->read_data(altname, ob);

            return dob;
         }

         dob = new texpolygon;

         if (!((texpolygon *)dob)->read_data(altname, ob)) {
            delete dob;
            return NULL;
         }

         dob->altname.stringcpy(altname);
         dob->dataname.stringcpy(&ob->dataname);

         global_resource_manager->register_resource_object(RESOURCE_UVCOORD, dob);
         return dob;

      case FILETYPE_TEX3D:
// asdf to be finished at a later date      
      default:
         return NULL;
   }

}

