

#include <stdlib.h>
#include <string.h>

#include "pstring.h"
#include "raw_load.h"
#include "global.h"


/* *******************************************************************
******************************************************************* */
class vertex_type : public dbl_llist {

   public:
      vector3f v;
      int index;
};


/* *******************************************************************
******************************************************************* */
class vertexman : public dbl_llist_manager {

   public:
      dbl_llist *sort(vertex_type *v) {
      
         vertex_type *vtr;
	 int i;
	 
	 for (i=0, vtr=(vertex_type *)head; vtr; i++, vtr=(vertex_type *)vtr->next)
            if (similar3(v->v, vtr->v)) {
	       delete v;
	       return vtr;
	    }
	    
	 v->index = i;
	 append(v, NULL);
	 return v;   
      }
      
};


/* *******************************************************************
******************************************************************* */
class poly_type : public dbl_llist {

   public:
      vector3i face;
};


/* *******************************************************************
******************************************************************* */
basic_loader *raw_loader::find_loader(sfile *data) {

   string_type buffer;
   int i;
   
   i = data->filename.stringlen();
   if (i > 6) {
      buffer.stringcpy(&data->filename.string[i-6]);
      lower_case(buffer.string);
      if (!buffer.stringcmp(".tpoly")) {
         sinfile = data;
         return this;
      }

   }
   
   return next ? ((basic_loader *)next)->find_loader(data) : NULL;
}


/* *******************************************************************
******************************************************************* */
void raw_loader::extract_object() {

   char token[MAXSTRLEN];
   dbl_llist_manager  fman;
   vertexman          vman;
   polygon_object_type *pot;
   int i, j;
   
   poly_type *ptr;
   vertex_type *vtr;

   sinfile->sseek(0);

   while (sinfile->scan_token(token, MAXSTRLEN)) {
   
      ptr = new poly_type;
      
      vtr = new vertex_type;
      vtr->v[0] = (float)atof(token);
      sinfile->scan_token(token, MAXSTRLEN);
      vtr->v[1] = (float)atof(token);
      sinfile->scan_token(token, MAXSTRLEN);
      vtr->v[2] = (float)atof(token);

      ptr->face[2] = ((vertex_type *)vman.sort(vtr))->index;
      
      vtr = new vertex_type;
      sinfile->scan_token(token, MAXSTRLEN);
      vtr->v[0] = (float)atof(token);
      sinfile->scan_token(token, MAXSTRLEN);
      vtr->v[1] = (float)atof(token);
      sinfile->scan_token(token, MAXSTRLEN);
      vtr->v[2] = (float)atof(token);

      ptr->face[1] = ((vertex_type *)vman.sort(vtr))->index;
      
      vtr = new vertex_type;
      sinfile->scan_token(token, MAXSTRLEN);
      vtr->v[0] = (float)atof(token);
      sinfile->scan_token(token, MAXSTRLEN);
      vtr->v[1] = (float)atof(token);
      sinfile->scan_token(token, MAXSTRLEN);
      vtr->v[2] = (float)atof(token);

      ptr->face[0] = ((vertex_type *)vman.sort(vtr))->index;

      fman.append(ptr, NULL);
   }
   
   if (!ob) {
      ob = new polytype;
      ob->dataname.stringcpy(&sinfile->filename);
   }
   
   ob->statusflag = STATUSFLAG_VOID;
   ob->build(vman.count, fman.count, fman.count*3);
   pot = (polygon_object_type *)ob->query_data();

   for (i=0, vtr=(vertex_type *)vman.head; vtr; i++, vtr=(vertex_type *)vtr->next) {
      copyarray3(pot->vlist[i], vtr->v);
      pot->vlist[i][3] = 1.0f;
   }

   ob->countedge = 0;

   for (i=0, ptr=(poly_type *)fman.head; ptr; i++, ptr=(poly_type *)ptr->next) {
      pot->flist[i].polynum = 3;
      pot->flist[i].edgeptr = &pot->vindex[ob->countedge];

      ob->countedge += 3;

      for (j=0; j<3; j+=3) {
         pot->flist[i].edgeptr[j] = ptr->face[0];
         pot->flist[i].edgeptr[j+1] = ptr->face[1];
         pot->flist[i].edgeptr[j+2] = ptr->face[2];
      }
      
   }

   ob->preprocess();
   ob->statusflag = STATUSFLAG_LOADABLE | STATUSFLAG_LOADED;
}


/* *******************************************************************
******************************************************************* */
int raw_loader::read_data() {

   if (!sinfile)
      return 0;

   ob = (polytype *)global_resource_manager->find_resource_object(RESOURCE_OBJECT, sinfile->filename.string, NULL);

   if (ob)
      return 1;
      
   return (int)extract(FILETYPE_SPG, sinfile->filename.string);
}


/* *******************************************************************
******************************************************************* */
void *raw_loader::extract(unsigned int type, char *altname, int level) {

   switch (type) {

      case FILETYPE_SPG:

         if (ob)
            return ob;

         extract_object();

         if (ob)
            global_resource_manager->register_resource_object(RESOURCE_OBJECT, ob);

         return ob;

      default:
         return NULL;
   }
   
}

