

#include <stdlib.h>
#include <string.h>

#include "polygon.h"
#include "pstring.h"

#include "obj_load.h"


/* *******************************************************************
******************************************************************* */
class obj_vertex_type : public dbl_llist {

   public:
      vector3f v;
      
      virtual ~obj_vertex_type() {}
};


/* *******************************************************************
******************************************************************* */
class obj_uv_type : public dbl_llist {

   public:
      vector2f uv;
      
      virtual ~obj_uv_type() {}
};


/* *******************************************************************
******************************************************************* */
class obj_material_file_type : public dbl_llist {

   public:
      string_type name;

      virtual ~obj_material_file_type() {}
};


/* *******************************************************************
******************************************************************* */
class obj_face_type : public dbl_llist {

   public:
      int *edgelist;
      int *uvlist;
      int countedge;
      obj_material_type *ilm;
      texbase *tob;
      
      obj_face_type() { edgelist = uvlist = NULL; ilm = NULL; tob = NULL; }
      virtual ~obj_face_type() { if (edgelist) delete [] edgelist; if (uvlist) delete [] uvlist; }
};


/* *******************************************************************
******************************************************************* */
obj_material_type::obj_material_type() {

   ambient[0] = ambient[1] = ambient[2] = 0;
   diffuse[0] = diffuse[1] = diffuse[2] = 0;
   specular[0] = specular[1] = specular[2] = 0;
   specn = 1.0f;
   facecount = 0;
   material_id = 0;
   tob = NULL;
}


/* *******************************************************************
******************************************************************* */
void obj_loader::cleanup() {

   file_loader::cleanup();

   ob = NULL;
   current = NULL;
   
   v_manager.dest();
   f_manager.dest();
   i_manager.dest();
   if_manager.dest();
   u_manager.dest();
}


/* *******************************************************************
******************************************************************* */
basic_loader *obj_loader::find_loader(sfile *data) {

   int i;
   char buffer[8];

   i = data->filename.stringlen();

   if (i > 4) {
      strcpy(buffer, &data->filename.string[i-4]);
      lower_case(buffer);
      if (!strcmp(buffer, ".obj")) {
         sinfile = data;
         return this;
      }

   }

   return next ? ((basic_loader *)next)->find_loader(data) : NULL;
}


/* *******************************************************************
******************************************************************* */
int obj_loader::read_material(char *filename) {
   
   int errorflag;
   char token[MAXSTRLEN];
   obj_material_type *mtr;
   sfile sinfile;

   if (sinfile.filename.stringcmp(filename) &&
       !sinfile.scan_data(filename, OBJECT_PATH.string,(char)PLATFORM_SLASH))
      return 0;

   while ((errorflag = sinfile.scan_token(token, MAXSTRLEN)))

      switch (token[0]) {

         case '\\':
            break;

         case 0:				// comment
         case '#':
         case '!':
         case '$':
            while ((errorflag=sinfile.sgetc()) != '\n' && errorflag != EOF);
            break;

         case 'K':
            // ambient
            if (!strcmp(token, "Ka")) {
               sinfile.scan_token(token, MAXSTRLEN);
               mtr->ambient[0] = (float)atof(token);
               sinfile.scan_token(token, MAXSTRLEN);
               mtr->ambient[1] = (float)atof(token);
               sinfile.scan_token(token, MAXSTRLEN);
               mtr->ambient[2] = (float)atof(token);
               break;
            }

            // diffuse
            if (!strcmp(token, "Kd")) {
               sinfile.scan_token(token, MAXSTRLEN);
               mtr->diffuse[0] = (float)atof(token);
               sinfile.scan_token(token, MAXSTRLEN);
               mtr->diffuse[1] = (float)atof(token);
               sinfile.scan_token(token, MAXSTRLEN);
               mtr->diffuse[2] = (float)atof(token);
               break;
            }

            if (!strcmp(token, "Ks")) {		// specular
               sinfile.scan_token(token, MAXSTRLEN);
               mtr->specular[0] = (float)atof(token);
               sinfile.scan_token(token, MAXSTRLEN);
               mtr->specular[1] = (float)atof(token);
               sinfile.scan_token(token, MAXSTRLEN);
               mtr->specular[2] = (float)atof(token);
               break;
            }

            break;

         case 'm':
            if (!strcmp(token, "map_Kd")) {
               sinfile.scan_token(token, MAXSTRLEN);
               mtr->tob = (texbase *)((frame_manager *)global_resource_manager)->read_tex(token);
               break;
             }

             break;

         case 'n':				// new color definition
            if (!strcmp(token, "newmtl")) {
               sinfile.scan_token(token, MAXSTRLEN);
               i_manager.append(mtr = new obj_material_type, NULL);
               mtr->name.stringcpy(token);
               mtr->material_id = i_manager.count-1;
               break;
            }

            break;

         case 'N':
            if (!strcmp(token, "Ns")) {		// specular exponent - shinyness
               sinfile.scan_token(token, MAXSTRLEN);
               mtr->specn = (float)atof(token);
               break;
            }

            break;

         default:	// refl map_Ka, map_Ks, map_d, sharpness, illum, d, vp
            break;
      }

   return 1;
}


/* *******************************************************************
******************************************************************* */
int obj_loader::read_data() {

   char token[MAXSTRLEN];
   char buffer[MAXSTRLEN];
   int errorflag;
   texbase *tob = NULL;
   int i, j, k;
   int texflag = 0;
   obj_material_type *mtr;
   obj_face_type *ftr;
   obj_material_file_type *mftr;
   obj_vertex_type *vtr;
   obj_uv_type *uvtr;
   char *sptr, *cptr;

   if (!sinfile)
      return 0;

   strcpy(token, sinfile->filename.string);
   i = strlen(token)-4;
   if (token[i] == '.')
      token[i] = 0;
   
   strcat(token, ".mtl");

   i_manager.insert(mtr = new obj_material_type, NULL);
   mtr->name.stringcpy("generic_default");
   mtr->material_id = i_manager.count-1;

   if_manager.append(mftr = new obj_material_file_type, NULL);
   mftr->name.stringcpy(token);
   read_material(token);

   ob = (polytype *)global_resource_manager->find_resource_object(RESOURCE_OBJECT, sinfile->filename.string, NULL);

   sinfile->sseek(0);

   while ((errorflag = sinfile->scan_token(token, MAXSTRLEN))) {

      switch (token[0]) {

         case '\\':
            break;

         case 0:				// comment to eoln
         case '#':
         case '!':
         case '$':
            while ((errorflag=sinfile->sgetc()) != '\n' && errorflag != EOF);
            break;

         case 'f':
            if (!strcmp(token, "f") || !strcmp(token, "fo")) {	// polygon face

               sinfile->sgets(buffer, MAXSTRLEN);
               cptr = buffer;

               // count # of vertices in face
               for (texflag = j = 0; (errorflag = sscanf(cptr, "%s%n", token, &i)) && errorflag != EOF; j++) {
                  cptr += i;

                  if ((sptr=strchr(token, '/')) && (k = atoi(sptr+1)))
                     texflag = 1;
               }

               f_manager.append(ftr = new obj_face_type, NULL);

               if (!mtr)
                  mtr = (obj_material_type *)i_manager.head;

               if (texflag)
                  if (tob)
                     ftr->tob = tob;
                  else if (mtr->tob)
                     ftr->tob = mtr->tob;

               ftr->ilm = mtr;
               mtr->facecount++;

               ftr->countedge = j;
               ftr->edgelist = new int[j];

               if (ftr->tob)
                  ftr->uvlist = new int[j];

               cptr = buffer;

               // process vertex indices,
               // format: f v/t/n v/t/n v/t/n .....
               for (i=j-1; i>-1; i--) {
                  sscanf(cptr, "%s%n", token, &k);
                  cptr += k;
                  k = atoi(token) - 1;

                  ftr->edgelist[i] = k;

                  if (ftr->uvlist)
                     if ((sptr=strchr(token, '/')) && (k = atoi(sptr+1)))
                        ftr->uvlist[i] = k-1;
                     else {
                        delete [] ftr->uvlist;
                        ftr->uvlist = NULL;
                        ftr->tob = NULL;
                     }

               }

               break;
            }

            break;

         case 'm':
            // format: "mtllib <.mtl>"
            if (!strcmp(token, "mtllib")) {
               sinfile->scan_token(token, MAXSTRLEN);
               for (mftr = (obj_material_file_type *)if_manager.head; mftr && mftr->name.stringcmp(token); mftr = (obj_material_file_type *)mftr->next);

               if (mftr)
                  break;

               if_manager.append(mftr = new obj_material_file_type, NULL);
               mftr->name.stringcpy(token);

               read_material(token);
               break;
            }

            break;

         case 'u':
            // format: "usemtl <surface name>"
            if (!strcmp(token, "usemtl")) {
               sinfile->scan_token(token, MAXSTRLEN);
               for (mtr = (obj_material_type *)i_manager.head; mtr && mtr->name.stringcmp(token); mtr = (obj_material_type *)mtr->next);
               break;
            }

            // format: "usemap <texname>"
            if (!strcmp(token, "usemap")) {
               sinfile->scan_token(token, MAXSTRLEN);

               if (!strcmp("off", token)) {
                  tob = NULL;
                  break;
               }
	       
               tob = (texbase *)((frame_manager *)global_resource_manager)->read_tex(token);
               break;
            }

            break;

         case 'v':
            // vertex format: "v <x> <y> <z>"
            if (!strcmp(token, "v")) {
               v_manager.append(vtr = new obj_vertex_type, NULL);
	       
               sinfile->scan_token(token, MAXSTRLEN);
               vtr->v[0] = (float)atof(token);
               sinfile->scan_token(token, MAXSTRLEN);
               vtr->v[1] = (float)atof(token);
               sinfile->scan_token(token, MAXSTRLEN);
               vtr->v[2] = (float)atof(token);
               break;
            }

            // normal format "vn <dx> <dy> <dz>"
            if (!strcmp(token, "vn")) {
               sinfile->scan_token(token, MAXSTRLEN);
               sinfile->scan_token(token, MAXSTRLEN);
               sinfile->scan_token(token, MAXSTRLEN);
               break;
            }

            // texture format "vt <tx> <ty>"
            if (!strcmp(token, "vt")) {
               u_manager.append(uvtr = new obj_uv_type, NULL);
	       
               sinfile->scan_token(token, MAXSTRLEN);
               uvtr->uv[0] = (float)atof(token);
               sinfile->scan_token(token, MAXSTRLEN);
               uvtr->uv[1] = (float)atof(token);
               break;
            }

            break;

         // bevel bmat bsp bzp c_interp cdc con cstype ctech curv curv2 d_interp deg end hole l lod maplib mg o p param res s scrv shadow_obj sp stech step surf trace_obj trim usemap vp
         default:
            break;
      }

   }

   extract(FILETYPE_SPG, sinfile->filename.string);
   return 1;
}


/* *******************************************************************
******************************************************************* */
int obj_loader::extract_uv(char *filename, char *altname) {

   obj_face_type *ftr;
   int i, j;
   vector2f *uv;
   obj_uv_type **uvlist;
   obj_uv_type *uvptr;
   
   if (!u_manager.head || !f_manager.head) {
      current = NULL;
      return 0;
   }
   
   for (ftr=(obj_face_type *)f_manager.head; ftr && !(ftr->tob && ftr->uvlist); ftr = (obj_face_type *)ftr->next);
   
   if (!ftr) {
      current = NULL;
      return 0;
   }

   if (!current) {
      current = new texpolygon;
      current->dataname.stringcpy(filename);
      current->altname.stringcpy(altname);
   }

   ((texpolygon *)current)->setup(ob->countobject);

   uvlist = new obj_uv_type *[u_manager.count];
   for (i=0, uvptr = (obj_uv_type *)u_manager.head; uvptr; i++, uvptr = (obj_uv_type *)uvptr->next)
      uvlist[i] = uvptr;

   for (i = 0, ftr = (obj_face_type *)f_manager.head; ftr; i++, ftr = (obj_face_type *)ftr->next)
      if (ftr->tob && ftr->uvlist) {
         uv = new vector2f[ftr->countedge];
         for (j=0; j<ftr->countedge; j++)
            copyarray2(uv[j], uvlist[ftr->uvlist[j]]->uv);

         ((texpolygon *)current)->direct2Dmap(i, uv, ftr->tob, ftr->countedge, 0);
         delete [] uv;
      }

   delete [] uvlist;
      
   current->statusflag = STATUSFLAG_LOADABLE | STATUSFLAG_LOADED;
   return 1; 
}


/* *******************************************************************
******************************************************************* */
void obj_loader::extract_shade(obj_material_type *mtr, shadetype *ilm) {

   copyarray3(ilm->fka, mtr->ambient);
   copyarray3(ilm->fkp, mtr->diffuse);
   copyarray3(ilm->fks, mtr->specular);

   ilm->specn = mtr->specn;
   ilm->flum[0] = ilm->flum[1] = ilm->flum[2] = 0;
   ilm->update_int();
}


/* *******************************************************************
******************************************************************* */
int obj_loader::extract_material(char *filename, char *altname) {

   shade_block *sblock;
   obj_face_type *ftr;
   obj_material_type *mtr;
   obj_material_type *btr = NULL;
   int i;
   
   if (!i_manager.head || !f_manager.head) {
      current = NULL;
      return 0;
   }
   
   if (!current) {
      current = new shadelist;
      current->dataname.stringcpy(filename);
      current->altname.stringcpy(altname);
   }

   current->replace_data(sblock = new shade_block);

   // find most commonly used material

   btr = (obj_material_type *)i_manager.head;
   sblock->index_count = btr->facecount;

   for (mtr = (obj_material_type *)i_manager.head->next; mtr; mtr = (obj_material_type *)mtr->next) {
      sblock->index_count += mtr->facecount;
      if (btr->facecount < mtr->facecount)
         btr = mtr;
   }

   // copy material palette
   sblock->shade_palette = new shadetype[sblock->shade_count = i_manager.count];

   extract_shade(btr, &sblock->shade_palette[0]);
   memcpy(&((shadelist *)current)->base, &sblock->shade_palette[0], sizeof(shadetype));

   for (mtr = (obj_material_type *)i_manager.head, i=1; mtr; mtr = (obj_material_type *)mtr->next)
      if (mtr != btr) {
         extract_shade(mtr, &sblock->shade_palette[i]);
         i++;
      }

   // copy palette indicies
   sblock->index_palette = new int[sblock->index_count];
   memset(sblock->index_palette, 0, sblock->index_count * sizeof(int));

   for (i=0, ftr = (obj_face_type *)f_manager.head, i++; ftr; ftr = (obj_face_type *)ftr->next, i++)
      if (ftr->ilm == btr)
         sblock->index_palette[i] = 0;
      else if (ftr->ilm->material_id < btr->material_id)
         sblock->index_palette[i] = ftr->ilm->material_id + 1;
      else
         sblock->index_palette[i] = ftr->ilm->material_id;

   ((shadelist *)current)->postprocess(ob->countobject);
   current->statusflag = STATUSFLAG_LOADABLE | STATUSFLAG_LOADED;
   return 1;
}


/* *******************************************************************
******************************************************************* */
int obj_loader::extract_object(char *filename, char *altname) {

   obj_face_type *ftr;
   obj_vertex_type *vtr;
   int countedge = 0;
   polygon_object_type *pot;
   int i, j, k;

   if (!v_manager.head || !f_manager.head)
      return 0;

   for (ftr = (obj_face_type *)f_manager.head; ftr; ftr = (obj_face_type *)ftr->next)
      countedge += ftr->countedge;

   if (!ob) {
      ob = new polytype;
      ob->dataname.stringcpy(filename);
   }

   ob->statusflag = STATUSFLAG_VOID;
   ob->build(v_manager.count, f_manager.count, countedge);
      
   pot = (polygon_object_type *)ob->query_data();

   for (i=0, vtr = (obj_vertex_type *)v_manager.head; vtr; i++, vtr = (obj_vertex_type *)vtr->next) {
      copyarray3(pot->vlist[i], vtr->v);
      pot->vlist[i][3] = 1.0f;
   }

   for (i=j=0, ftr = (obj_face_type *)f_manager.head; ftr; i++, ftr = (obj_face_type *)ftr->next) {
      pot->flist[i].polynum = ftr->countedge;
      pot->flist[i].edgeptr = &pot->vindex[j];

      j += ftr->countedge;
      
      for (k=0; k<ftr->countedge; k++)
         pot->flist[i].edgeptr[k] = ftr->edgelist[k];
   }

   ob->preprocess();
   ob->statusflag = STATUSFLAG_LOADABLE | STATUSFLAG_LOADED;
   return 1;
}


/* *******************************************************************
******************************************************************* */
void *obj_loader::extract(unsigned int type, char *altname, int level) {

   switch (type) {

      case FILETYPE_SPG:

         if (ob) {
            if (!(ob->statusflag & STATUSFLAG_LOADED))
               extract_object(altname, altname);

            return ob;
         }

         extract_object(altname, altname);

         if (ob)
            global_resource_manager->register_resource_object(RESOURCE_OBJECT, ob);

         return ob;

      case FILETYPE_ILM:
         current = (resource_type *)global_resource_manager->find_resource_object(RESOURCE_MATERIAL, altname, altname);

         if (current) {
            if (!(current->statusflag & STATUSFLAG_LOADED))
               extract_material(altname, altname);

            return current;
         }

         extract_material(altname, altname);

         if (current) {
            global_resource_manager->register_resource_object(RESOURCE_MATERIAL, current);
            return current;
         }

         // try processing .ilm file
         current = (resource_type *)((frame_manager *)global_resource_manager)->read_ilm(altname, ob->countobject);

         if (current)
            current->dataname.stringcpy(&ob->dataname);

         return current;

      case FILETYPE_TEX:
         current = (resource_type *)global_resource_manager->find_resource_object(RESOURCE_UVCOORD, altname, altname);

         if (current) {
            if (!(current->statusflag & STATUSFLAG_LOADED))
               extract_uv(altname, altname);

            return current;
         }

         extract_uv(altname, altname);

         if (current)
            global_resource_manager->register_resource_object(RESOURCE_UVCOORD, current);

         return current;

      default:
         return NULL;
   }

}

