

#include <stdlib.h>
#include <string.h>

#include "byu_load.h"
#include "global.h"
#include "pstring.h"


/* *******************************************************************
******************************************************************* */
class byu_vertex_type : public dbl_llist {

   public:
      int index;
};


/* *******************************************************************
******************************************************************* */
class byu_face_type : public dbl_llist {

   public:
      dbl_llist_manager edgelist;

      virtual ~byu_face_type() {}
};


/* *******************************************************************
******************************************************************* */
void byu_loader::cleanup() {

   file_loader::cleanup();

   if (vertex) {
      delete [] vertex;
      vertex = NULL; 
   }
   
   f_manager.dest();
   ob = NULL;
}


/* *******************************************************************
******************************************************************* */
basic_loader *byu_loader::find_loader(sfile *data) {

   string_type buffer;
   int i;
   
   i = data->filename.stringlen();
   if (i > 4) {
      buffer.stringcpy(&data->filename.string[i-4]);
      lower_case(buffer.string);
      if (!buffer.stringcmp(".byu")) {
         sinfile = data;
         return this;
      }

   }
   
   return next ? ((basic_loader *)next)->find_loader(data) : NULL;
}


/* *******************************************************************
******************************************************************* */
int byu_loader::read_data() {

   int countpart;
   char token[MAXSTRLEN];
   int i;
   byu_face_type *ftr;
   byu_vertex_type *vtr;

   if (sinfile)
      return 0;

   ob = (polytype *)global_resource_manager->find_resource_object(RESOURCE_OBJECT, sinfile->filename.string, NULL);

   sinfile->sseek(0);

   sinfile->scan_token(token, MAXSTRLEN);
   countpart = atoi(token);
   
   sinfile->scan_token(token, MAXSTRLEN);
   countvertex = atoi(token);
   
   sinfile->scan_token(token, MAXSTRLEN);
   countobject = atoi(token);
   
   sinfile->scan_token(token, MAXSTRLEN);
   countedge = atoi(token);
   
   for (i=0; i<countpart; i++) {
      sinfile->scan_token(token, MAXSTRLEN);
      sinfile->scan_token(token, MAXSTRLEN);
   }
   
   if (vertex)
      delete [] vertex;

   vertex = new vector3f[countvertex];

   for (i=0; i<countvertex; i++) {
      sinfile->scan_token(token, MAXSTRLEN);
      vertex[i][0] = (float)atof(token);
   
      sinfile->scan_token(token, MAXSTRLEN);
      vertex[i][1] = (float)atof(token);
   
      sinfile->scan_token(token, MAXSTRLEN);
      vertex[i][2] = (float)atof(token);
   }   
   
   for(i=0; i<countobject; i++) {

      f_manager.append(ftr = new byu_face_type, NULL);
      
      while (1) {
         ftr->edgelist.append(vtr = new byu_vertex_type, NULL);
         sinfile->scan_token(token, MAXSTRLEN);
         vtr->index = atoi(token);
         if (vtr->index < 0) {
            vtr->index = -(vtr->index + 1);
            break;
         }

         vtr->index--;
      }

   }

   extract(FILETYPE_SPG, sinfile->filename.string);
   
   return 1;
}


/* *******************************************************************
******************************************************************* */
int byu_loader::extract_object() {

   polygon_object_type *pot;
   int i, j;
   byu_face_type *ftr;
   byu_vertex_type *vtr;
   int count = 0;
      
   if (!f_manager.head)
      return 0;
      
   if (!ob) {
      ob = new polytype;
      ob->dataname.stringcpy(&sinfile->filename);
   }

   ob->statusflag = STATUSFLAG_VOID;
   ob->build(countvertex, countobject, countedge);
   pot = (polygon_object_type *)ob->query_data();

   for (i=0; i<countvertex; i++) {
      copyarray3(pot->vlist[i], vertex[i]);
      pot->vlist[i][3] = 1.0f;
   }

   for (i=0, ftr = (byu_face_type *)f_manager.head; ftr; i++, ftr = (byu_face_type *)ftr->next) {
      pot->flist[i].polynum = ftr->edgelist.count;
      pot->flist[i].edgeptr = &pot->vindex[count];

      count += ftr->edgelist.count;

      for (j=0, vtr = (byu_vertex_type *)ftr->edgelist.head; vtr; j++, vtr = (byu_vertex_type *)vtr->next)
         pot->flist[i].edgeptr[j] = vtr->index;
   }

   ob->preprocess();
   ob->statusflag = STATUSFLAG_LOADABLE | STATUSFLAG_LOADED;
   return 1;
}


/* *******************************************************************
******************************************************************* */
void *byu_loader::extract(unsigned int type, char *altname, int level) {

   switch (type) {

      case FILETYPE_SPG:

         if (ob) {
            // Note: this could cause the same object to be submitted more than once
            if (!(ob->statusflag & STATUSFLAG_LOADED))
               extract_object();

            return ob;
         }

         extract_object();

         if (ob)
            global_resource_manager->register_resource_object(RESOURCE_OBJECT, ob);

         return ob;

      default:
         return NULL;
   }

}

