

#if !defined __ZBUFFER_H
#define __ZBUFFER_H


#include "datatype.h"


/* *************************************************************
   this is the definition of the zbuffer class
************************************************************* */
class zbuffer : public mapul {

   protected:
      int read_filter(char *fname, mapf *filter);

   public:
      float        *zdata;
      unsigned int *adata;

      zbuffer() { zdata = NULL; adata = NULL; }
      virtual ~zbuffer() { if (zdata) delete [] zdata; if (adata) delete [] adata; }

      int      initbuff(unsigned int x, unsigned int y, float backplane);
      int      initbuff(unsigned int *d, puint *pd, unsigned int *ad, float *zd, unsigned int x, unsigned int y, float backplane);
      int      initbuff(unsigned int *d, puint *pd, float *zd, unsigned int x, unsigned int y, float backplane);
      void     save_image(char *filename, image_coder *coder);
      void     antialias(char *fname);
      void     antialias_edge(char *fname);
      void     gammabuff(unsigned char *pgamma);
      void     render(mapul *mcanvas);
};


void init_buff(unsigned int *buffer, unsigned int padd, unsigned int count);


// can do this way - fst acolor, fist acolor, fadd dcolor, fistp dcolor
#define set_zdata(zbuff, index, z, acolor, dcolor, a0, a1, a2, d0, d1, d2)       \
   F2I(a0, acolor[0]);          \
   F2I(a1, acolor[1]);          \
   F2I(a2, acolor[2]);          \
   F2I(d0, dcolor[0]+acolor[0]);          \
   F2I(d1, dcolor[1]+acolor[1]);          \
   F2I(d2, dcolor[2]+acolor[2]);          \
   zbuff->zdata[index] = z;            \
   ((unsigned char *)&zbuff->adata[index])[REDINDEX]   = BYTE_LUT(a0.iflt2int[0]);  \
   ((unsigned char *)&zbuff->adata[index])[GREENINDEX] = BYTE_LUT(a1.iflt2int[0]);  \
   ((unsigned char *)&zbuff->adata[index])[BLUEINDEX]  = BYTE_LUT(a2.iflt2int[0]);  \
   ((unsigned char *) &zbuff->data[index])[REDINDEX]   = BYTE_LUT(d0.iflt2int[0]);  \
   ((unsigned char *) &zbuff->data[index])[GREENINDEX] = BYTE_LUT(d1.iflt2int[0]);  \
   ((unsigned char *) &zbuff->data[index])[BLUEINDEX]  = BYTE_LUT(d2.iflt2int[0])

#define set_nzbuff(zbuff, index, acolor, dcolor, a0, a1, a2, d0, d1, d2)       \
   F2I(a0, acolor[0]);          \
   F2I(a1, acolor[1]);          \
   F2I(a2, acolor[2]);          \
   F2I(d0, dcolor[0]+acolor[0]);          \
   F2I(d1, dcolor[1]+acolor[1]);          \
   F2I(d2, dcolor[2]+acolor[2]);          \
   ((unsigned char *)&zbuff->adata[index])[REDINDEX]   = BYTE_LUT(a0.iflt2int[0]);  \
   ((unsigned char *)&zbuff->adata[index])[GREENINDEX] = BYTE_LUT(a1.iflt2int[0]);  \
   ((unsigned char *)&zbuff->adata[index])[BLUEINDEX]  = BYTE_LUT(a2.iflt2int[0]);  \
   ((unsigned char *) &zbuff->data[index])[REDINDEX]   = BYTE_LUT(d0.iflt2int[0]);  \
   ((unsigned char *) &zbuff->data[index])[GREENINDEX] = BYTE_LUT(d1.iflt2int[0]);  \
   ((unsigned char *) &zbuff->data[index])[BLUEINDEX]  = BYTE_LUT(d2.iflt2int[0])

#define set_datatr(zbuff, index, acolor, dcolor, a0, a1, a2, d0, d1, d2)     \
   F2I(a0, acolor[0]);          \
   F2I(a1, acolor[1]);          \
   F2I(a2, acolor[2]);          \
   F2I(d0, dcolor[0]+acolor[0]);          \
   F2I(d1, dcolor[1]+acolor[1]);          \
   F2I(d2, dcolor[2]+acolor[2]);          \
   if (a0.iflt2int[0] > ((unsigned char *)&zbuff->adata[index])[REDINDEX])  \
      ((unsigned char *)&zbuff->adata[index])[REDINDEX] = BYTE_LUT(a0.iflt2int[0]);  \
   if (a1.iflt2int[0] > ((unsigned char *)&zbuff->adata[index])[GREENINDEX])  \
      ((unsigned char *)&zbuff->adata[index])[GREENINDEX] = BYTE_LUT(a1.iflt2int[0]);  \
   if (a2.iflt2int[0] > ((unsigned char *)&zbuff->adata[index])[BLUEINDEX])  \
      ((unsigned char *)&zbuff->adata[index])[BLUEINDEX] = BYTE_LUT(a2.iflt2int[0]);  \
   if (d0.iflt2int[0] > ((unsigned char *)&zbuff->data[index])[REDINDEX])  \
      ((unsigned char *)&zbuff->data[index])[REDINDEX] = BYTE_LUT(d0.iflt2int[0]);  \
   if (d1.iflt2int[0] > ((unsigned char *)&zbuff->data[index])[GREENINDEX])  \
      ((unsigned char *)&zbuff->data[index])[GREENINDEX] = BYTE_LUT(d1.iflt2int[0]);  \
   if (d2.iflt2int[0] > ((unsigned char *)&zbuff->data[index])[BLUEINDEX])  \
      ((unsigned char *)&zbuff->data[index])[BLUEINDEX] = BYTE_LUT(d2.iflt2int[0])

#endif

