

#if !defined __WINSND_H
#define __WINSND_H

#include "soundman.h"
#include "WIN_VIRTUAL.h"
#include "dataio.h"


#include <dsound.h>
#include <dmusici.h>


class soundman_win;


/************************************************************************************************
********************************************************************************************** */
class midi_sample_type : public dbl_llist {

   public:
      string_type name;
      
      virtual ~midi_sample_type() {}
};


/************************************************************************************************
********************************************************************************************** */
class midi_play_type : public sound_midi_type {

   public:
      // sound_type
      void volume(int v);

      // midi_play_type
      IDirectMusicSegment8 *sound;
      int *volumex;
      soundman_win *parent;
      
      midi_play_type() { sound = NULL; volumex = NULL; parent = NULL; }
      virtual ~midi_play_type();
};


/************************************************************************************************
********************************************************************************************** */
class midi_manager {

   protected:
      dbl_llist_manager play_manager;   // list of playing midi's
      dbl_llist_manager sample_manager; // list of midi's

   public:
      soundman_win *parent;

      virtual ~midi_manager() {}

      void dest();
      int find(sound_id_type *sound_id);
      sound_type *play(sound_id_type *sound_id, int *volumex);
      void update();
};


typedef struct {

   char        wFormatTag[2];         /* format type - 16 bits*/
   char        nChannels[2];          /* number of channels (i.e. mono, stereo...) 16 bits*/
   int         nSamplesPerSec;        /* sample rate */
   int         nAvgBytesPerSec;       /* for buffer estimation */
   char        nBlockAlign[2];        /* block size of data 16 bits */
   char        wBitsPerSample[2];     /* number of bits per sample of mono data 16 bits*/
   char        cbSize[2];             /* the count in bytes of the size of extra information (after cbSize) 16 bits */
} wav_header;


/************************************************************************************************
********************************************************************************************** */
class wav_sample_type : public dbl_llist {

   public:
      sfile wav_file;
      char *wav_raw;
      unsigned int wav_length;
      wav_header *wav_info;

      wav_sample_type() { wav_raw = NULL; wav_info = NULL; wav_length = 0; }
      virtual ~wav_sample_type() {}

      int parse(char *filename);
      int update(IDirectSoundBuffer *device);
      IDirectSoundBuffer *init(IDirectSound *driver, unsigned int flags);
};


/************************************************************************************************
********************************************************************************************** */
class wav_play_type : public sound_wav_type {

   public:
      void volume(int v);
      void update();
      void stop();
      
      IDirectSoundBuffer *device;
      int *volumex;
      wav_play_type() { device = NULL; volumex = NULL; }
      virtual ~wav_play_type();
};



/************************************************************************************************
********************************************************************************************** */
class wav_play3d_type : public sound_wav3d_type {

   public:
      // sound_type
      void volume(int v);
      void update();
      void stop();
      
      // sound_wav3d_type
      void location(float *pos);

      // wav_play3d_type
      IDirectSoundBuffer *device;
      IDirectSound3DBuffer *device3d;
      int *volumex;

      wav_play3d_type() { device = NULL; device3d = NULL; volumex = NULL; }
      virtual ~wav_play3d_type();
};



/************************************************************************************************
********************************************************************************************** */
class wav_manager {

   protected:
      dbl_llist_manager play_manager;   // list of playing midi's
      dbl_llist_manager sample_manager; // list of midi's
      int limit;
      
   public:
      virtual ~wav_manager() {}

      void dest();
      int find(sound_id_type *sound_id);
      sound_type *play(sound_id_type *sound_id, IDirectSound *driver, int *volumex);
      void update();
};


/************************************************************************************************
********************************************************************************************** */
class soundman_win : public soundman {

   protected:
      HWND window;
      IDirectSound8 *driver;
      IDirectSound3DListener *listener;

      wav_manager wav;
      midi_manager midi;
      
   public:

      // soundman
      int  init();
      int  dest();
      void reset();
      
      sound_type *play(sound_id_type *sound_id);
      void update(float *pos, float *dir, float *up);
      int  find(sound_id_type *sound_id);

      // soundman_win      
      IDirectMusicLoader8 *midi_loader;
      IDirectMusicPerformance8 *midi_performer;

      soundman_win();
      virtual ~soundman_win();
      
      void set_win(VIRTUALwindow *win);
};


#endif
