

#if !defined __WIN_WGL_H
#define __WIN_WGL_H


#include <windows.h>
#include <GL/gl.h>


#define GL_FUNC_ADD 0x8006
#define GL_MAX      0x8008

#define WGL_SUPPORT_OPENGL_ARB         0x2010
#define WGL_DOUBLE_BUFFER_ARB          0x2011
#define WGL_RED_BITS_ARB               0x2015
#define WGL_GREEN_BITS_ARB             0x2017
#define WGL_BLUE_BITS_ARB              0x2019
#define WGL_ALPHA_BITS_ARB             0x201B
#define WGL_DEPTH_BITS_ARB             0x2022
#define WGL_DRAW_TO_PBUFFER_ARB        0x202D
#define WGL_PBUFFER_WIDTH_ARB          0x2034
#define WGL_PBUFFER_HEIGHT_ARB         0x2035

DECLARE_HANDLE(HPBUFFERARB);

typedef int (WINAPI *glPROC)(int);
typedef void (WINAPI *glPROCCT)(GLenum, GLenum, GLsizei, GLenum, GLenum, GLvoid *);
typedef void (WINAPI *glLTM) (const GLfloat *m);
typedef void (WINAPI *glMTM) (const GLfloat *m);

typedef HPBUFFERARB (WINAPI *glCP)(HDC, int, int, int, const int *);
typedef HDC  (WINAPI *glGPDC)(HPBUFFERARB);
typedef int  (WINAPI *glRPDC)(HPBUFFERARB, HDC);
typedef BOOL (WINAPI *glDP)(HPBUFFERARB);
typedef BOOL (WINAPI *glQP)(HPBUFFERARB, int, int *);
                                                                                
typedef BOOL (WINAPI *glCPF)(HDC, const int *, const FLOAT *, UINT, int *, UINT *);

extern glPROC   glBlendEquation;
extern glPROCCT glColorTable;
extern glLTM    glLoadTransposeMatrixf;
extern glMTM    glMultTransposeMatrixf;

extern glCP     glCreatePbuffer;
extern glGPDC   glGetPbufferDC;
extern glRPDC   glReleasePbufferDC;
extern glDP     glDestroyPbuffer;
extern glQP     glQueryPbuffer;

extern glCPF    glChoosePixelFormat;

void init_wgl();

#endif

